/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public record BeeDebugPayload(BeeInfo beeInfo) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, BeeDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BeeDebugPayload::write, BeeDebugPayload::new);
    public static final CustomPacketPayload.Type<BeeDebugPayload> TYPE = CustomPacketPayload.createType("debug/bee");

    private BeeDebugPayload(FriendlyByteBuf var0) {
        this(new BeeInfo(var0));
    }

    private void write(FriendlyByteBuf var0) {
        this.beeInfo.write(var0);
    }

    public CustomPacketPayload.Type<BeeDebugPayload> type() {
        return TYPE;
    }

    public record BeeInfo(UUID uuid, int id, Vec3 pos, @Nullable Path path, @Nullable BlockPos hivePos, @Nullable BlockPos flowerPos, int travelTicks, Set<String> goals, List<BlockPos> blacklistedHives) {
        public BeeInfo(FriendlyByteBuf var0) {
            this(var0.readUUID(), var0.readInt(), var0.readVec3(), var0.readNullable(Path::createFromStream), var0.readNullable(BlockPos.STREAM_CODEC), var0.readNullable(BlockPos.STREAM_CODEC), var0.readInt(), var0.readCollection(HashSet::new, FriendlyByteBuf::readUtf), var0.readList(BlockPos.STREAM_CODEC));
        }

        public void write(FriendlyByteBuf var02) {
            var02.writeUUID(this.uuid);
            var02.writeInt(this.id);
            var02.writeVec3(this.pos);
            var02.writeNullable(this.path, (var0, var1) -> var1.writeToStream((FriendlyByteBuf)((Object)var0)));
            var02.writeNullable(this.hivePos, BlockPos.STREAM_CODEC);
            var02.writeNullable(this.flowerPos, BlockPos.STREAM_CODEC);
            var02.writeInt(this.travelTicks);
            var02.writeCollection(this.goals, FriendlyByteBuf::writeUtf);
            var02.writeCollection(this.blacklistedHives, BlockPos.STREAM_CODEC);
        }

        public boolean hasHive(BlockPos var0) {
            return Objects.equals(var0, this.hivePos);
        }

        public String generateName() {
            return DebugEntityNameGenerator.getEntityName(this.uuid);
        }

        @Override
        public String toString() {
            return this.generateName();
        }
    }
}

