/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.BossEvent;

public class ClientboundBossEventPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundBossEventPacket> STREAM_CODEC = Packet.codec(ClientboundBossEventPacket::write, ClientboundBossEventPacket::new);
    private static final int FLAG_DARKEN = 1;
    private static final int FLAG_MUSIC = 2;
    private static final int FLAG_FOG = 4;
    private final UUID id;
    private final Operation operation;
    static final Operation REMOVE_OPERATION = new Operation(){

        @Override
        public OperationType getType() {
            return OperationType.REMOVE;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.remove(var0);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
        }
    };

    private ClientboundBossEventPacket(UUID var0, Operation var1) {
        this.id = var0;
        this.operation = var1;
    }

    private ClientboundBossEventPacket(RegistryFriendlyByteBuf var0) {
        this.id = var0.readUUID();
        OperationType var1 = var0.readEnum(OperationType.class);
        this.operation = var1.reader.decode(var0);
    }

    public static ClientboundBossEventPacket createAddPacket(BossEvent var0) {
        return new ClientboundBossEventPacket(var0.getId(), new AddOperation(var0));
    }

    public static ClientboundBossEventPacket createRemovePacket(UUID var0) {
        return new ClientboundBossEventPacket(var0, REMOVE_OPERATION);
    }

    public static ClientboundBossEventPacket createUpdateProgressPacket(BossEvent var0) {
        return new ClientboundBossEventPacket(var0.getId(), new UpdateProgressOperation(var0.getProgress()));
    }

    public static ClientboundBossEventPacket createUpdateNamePacket(BossEvent var0) {
        return new ClientboundBossEventPacket(var0.getId(), new UpdateNameOperation(var0.getName()));
    }

    public static ClientboundBossEventPacket createUpdateStylePacket(BossEvent var0) {
        return new ClientboundBossEventPacket(var0.getId(), new UpdateStyleOperation(var0.getColor(), var0.getOverlay()));
    }

    public static ClientboundBossEventPacket createUpdatePropertiesPacket(BossEvent var0) {
        return new ClientboundBossEventPacket(var0.getId(), new UpdatePropertiesOperation(var0.shouldDarkenScreen(), var0.shouldPlayBossMusic(), var0.shouldCreateWorldFog()));
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeUUID(this.id);
        var0.writeEnum(this.operation.getType());
        this.operation.write(var0);
    }

    static int encodeProperties(boolean var0, boolean var1, boolean var2) {
        int var3 = 0;
        if (var0) {
            var3 |= 1;
        }
        if (var1) {
            var3 |= 2;
        }
        if (var2) {
            var3 |= 4;
        }
        return var3;
    }

    @Override
    public PacketType<ClientboundBossEventPacket> type() {
        return GamePacketTypes.CLIENTBOUND_BOSS_EVENT;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleBossUpdate(this);
    }

    public void dispatch(Handler var0) {
        this.operation.dispatch(this.id, var0);
    }

    static interface Operation {
        public OperationType getType();

        public void dispatch(UUID var1, Handler var2);

        public void write(RegistryFriendlyByteBuf var1);
    }

    static enum OperationType {
        ADD(AddOperation::new),
        REMOVE(var0 -> REMOVE_OPERATION),
        UPDATE_PROGRESS(UpdateProgressOperation::new),
        UPDATE_NAME(UpdateNameOperation::new),
        UPDATE_STYLE(UpdateStyleOperation::new),
        UPDATE_PROPERTIES(UpdatePropertiesOperation::new);

        final StreamDecoder<RegistryFriendlyByteBuf, Operation> reader;

        private OperationType(StreamDecoder var2) {
            this.reader = var2;
        }
    }

    static class AddOperation
    implements Operation {
        private final Component name;
        private final float progress;
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        AddOperation(BossEvent var0) {
            this.name = var0.getName();
            this.progress = var0.getProgress();
            this.color = var0.getColor();
            this.overlay = var0.getOverlay();
            this.darkenScreen = var0.shouldDarkenScreen();
            this.playMusic = var0.shouldPlayBossMusic();
            this.createWorldFog = var0.shouldCreateWorldFog();
        }

        private AddOperation(RegistryFriendlyByteBuf var0) {
            this.name = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
            this.progress = var0.readFloat();
            this.color = var0.readEnum(BossEvent.BossBarColor.class);
            this.overlay = var0.readEnum(BossEvent.BossBarOverlay.class);
            short var1 = var0.readUnsignedByte();
            this.darkenScreen = (var1 & 1) > 0;
            this.playMusic = (var1 & 2) > 0;
            this.createWorldFog = (var1 & 4) > 0;
        }

        @Override
        public OperationType getType() {
            return OperationType.ADD;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.add(var0, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.name);
            var0.writeFloat(this.progress);
            var0.writeEnum(this.color);
            var0.writeEnum(this.overlay);
            var0.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    record UpdateProgressOperation(float progress) implements Operation
    {
        private UpdateProgressOperation(RegistryFriendlyByteBuf var0) {
            this(var0.readFloat());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROGRESS;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.updateProgress(var0, this.progress);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
            var0.writeFloat(this.progress);
        }
    }

    record UpdateNameOperation(Component name) implements Operation
    {
        private UpdateNameOperation(RegistryFriendlyByteBuf var0) {
            this((Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0));
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_NAME;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.updateName(var0, this.name);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.name);
        }
    }

    static class UpdateStyleOperation
    implements Operation {
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;

        UpdateStyleOperation(BossEvent.BossBarColor var0, BossEvent.BossBarOverlay var1) {
            this.color = var0;
            this.overlay = var1;
        }

        private UpdateStyleOperation(RegistryFriendlyByteBuf var0) {
            this.color = var0.readEnum(BossEvent.BossBarColor.class);
            this.overlay = var0.readEnum(BossEvent.BossBarOverlay.class);
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_STYLE;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.updateStyle(var0, this.color, this.overlay);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
            var0.writeEnum(this.color);
            var0.writeEnum(this.overlay);
        }
    }

    static class UpdatePropertiesOperation
    implements Operation {
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        UpdatePropertiesOperation(boolean var0, boolean var1, boolean var2) {
            this.darkenScreen = var0;
            this.playMusic = var1;
            this.createWorldFog = var2;
        }

        private UpdatePropertiesOperation(RegistryFriendlyByteBuf var0) {
            short var1 = var0.readUnsignedByte();
            this.darkenScreen = (var1 & 1) > 0;
            this.playMusic = (var1 & 2) > 0;
            this.createWorldFog = (var1 & 4) > 0;
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROPERTIES;
        }

        @Override
        public void dispatch(UUID var0, Handler var1) {
            var1.updateProperties(var0, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(RegistryFriendlyByteBuf var0) {
            var0.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    public static interface Handler {
        default public void add(UUID var0, Component var1, float var2, BossEvent.BossBarColor var3, BossEvent.BossBarOverlay var4, boolean var5, boolean var6, boolean var7) {
        }

        default public void remove(UUID var0) {
        }

        default public void updateProgress(UUID var0, float var1) {
        }

        default public void updateName(UUID var0, Component var1) {
        }

        default public void updateStyle(UUID var0, BossEvent.BossBarColor var1, BossEvent.BossBarOverlay var2) {
        }

        default public void updateProperties(UUID var0, boolean var1, boolean var2, boolean var3) {
        }
    }
}

