/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;

public class ClientboundPlayerInfoUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerInfoUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundPlayerInfoUpdatePacket::write, ClientboundPlayerInfoUpdatePacket::new);
    private final EnumSet<Action> actions;
    private final List<Entry> entries;

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> var0, Collection<ServerPlayer> var1) {
        this.actions = var0;
        this.entries = var1.stream().map(Entry::new).toList();
    }

    public ClientboundPlayerInfoUpdatePacket(Action var0, ServerPlayer var1) {
        this.actions = EnumSet.of(var0);
        this.entries = List.of(new Entry(var1));
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> var0) {
        EnumSet<Action[]> var1 = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME, Action.UPDATE_HAT, Action.UPDATE_LIST_ORDER});
        return new ClientboundPlayerInfoUpdatePacket(var1, var0);
    }

    private ClientboundPlayerInfoUpdatePacket(RegistryFriendlyByteBuf var02) {
        this.actions = var02.readEnumSet(Action.class);
        this.entries = var02.readList(var0 -> {
            EntryBuilder var1 = new EntryBuilder(var0.readUUID());
            for (Action var3 : this.actions) {
                var3.reader.read(var1, (RegistryFriendlyByteBuf)((Object)var0));
            }
            return var1.build();
        });
    }

    private void write(RegistryFriendlyByteBuf var02) {
        var02.writeEnumSet(this.actions, Action.class);
        var02.writeCollection(this.entries, (var0, var1) -> {
            var0.writeUUID(var1.profileId());
            for (Action var3 : this.actions) {
                var3.writer.write((RegistryFriendlyByteBuf)((Object)var0), (Entry)var1);
            }
        });
    }

    @Override
    public PacketType<ClientboundPlayerInfoUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handlePlayerInfoUpdate(this);
    }

    public EnumSet<Action> actions() {
        return this.actions;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public List<Entry> newEntries() {
        return this.actions.contains((Object)Action.ADD_PLAYER) ? this.entries : List.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actions", this.actions).add("entries", this.entries).toString();
    }

    public static final class Entry
    extends Record {
        private final UUID profileId;
        @Nullable
        private final GameProfile profile;
        private final boolean listed;
        private final int latency;
        private final GameType gameMode;
        @Nullable
        private final Component displayName;
        final boolean showHat;
        final int listOrder;
        @Nullable
        final RemoteChatSession.Data chatSession;

        Entry(ServerPlayer var0) {
            this(var0.getUUID(), var0.getGameProfile(), true, var0.connection.latency(), var0.gameMode(), var0.getTabListDisplayName(), var0.isModelPartShown(PlayerModelPart.HAT), var0.getTabListOrder(), Optionull.map(var0.getChatSession(), RemoteChatSession::asData));
        }

        public Entry(UUID var0, @Nullable GameProfile var1, boolean var2, int var3, GameType var4, @Nullable Component var5, boolean var6, int var7, @Nullable RemoteChatSession.Data var8) {
            this.profileId = var0;
            this.profile = var1;
            this.listed = var2;
            this.latency = var3;
            this.gameMode = var4;
            this.displayName = var5;
            this.showHat = var6;
            this.listOrder = var7;
            this.chatSession = var8;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "profileId;profile;listed;latency;gameMode;displayName;showHat;listOrder;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "showHat", "listOrder", "chatSession"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "profileId;profile;listed;latency;gameMode;displayName;showHat;listOrder;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "showHat", "listOrder", "chatSession"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "profileId;profile;listed;latency;gameMode;displayName;showHat;listOrder;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "showHat", "listOrder", "chatSession"}, this, var0);
        }

        public UUID profileId() {
            return this.profileId;
        }

        @Nullable
        public GameProfile profile() {
            return this.profile;
        }

        public boolean listed() {
            return this.listed;
        }

        public int latency() {
            return this.latency;
        }

        public GameType gameMode() {
            return this.gameMode;
        }

        @Nullable
        public Component displayName() {
            return this.displayName;
        }

        public boolean showHat() {
            return this.showHat;
        }

        public int listOrder() {
            return this.listOrder;
        }

        @Nullable
        public RemoteChatSession.Data chatSession() {
            return this.chatSession;
        }
    }

    public static enum Action {
        ADD_PLAYER((var0, var1) -> {
            GameProfile var2 = new GameProfile(var0.profileId, var1.readUtf(16));
            var2.getProperties().putAll((Multimap)ByteBufCodecs.GAME_PROFILE_PROPERTIES.decode(var1));
            var0.profile = var2;
        }, (var0, var1) -> {
            GameProfile var2 = Objects.requireNonNull(var1.profile());
            var0.writeUtf(var2.getName(), 16);
            ByteBufCodecs.GAME_PROFILE_PROPERTIES.encode(var0, var2.getProperties());
        }),
        INITIALIZE_CHAT((var0, var1) -> {
            var0.chatSession = var1.readNullable(RemoteChatSession.Data::read);
        }, (var0, var1) -> var0.writeNullable(var1.chatSession, RemoteChatSession.Data::write)),
        UPDATE_GAME_MODE((var0, var1) -> {
            var0.gameMode = GameType.byId(var1.readVarInt());
        }, (var0, var1) -> var0.writeVarInt(var1.gameMode().getId())),
        UPDATE_LISTED((var0, var1) -> {
            var0.listed = var1.readBoolean();
        }, (var0, var1) -> var0.writeBoolean(var1.listed())),
        UPDATE_LATENCY((var0, var1) -> {
            var0.latency = var1.readVarInt();
        }, (var0, var1) -> var0.writeVarInt(var1.latency())),
        UPDATE_DISPLAY_NAME((var0, var1) -> {
            var0.displayName = FriendlyByteBuf.readNullable(var1, ComponentSerialization.TRUSTED_STREAM_CODEC);
        }, (var0, var1) -> FriendlyByteBuf.writeNullable(var0, var1.displayName(), ComponentSerialization.TRUSTED_STREAM_CODEC)),
        UPDATE_LIST_ORDER((var0, var1) -> {
            var0.listOrder = var1.readVarInt();
        }, (var0, var1) -> var0.writeVarInt(var1.listOrder)),
        UPDATE_HAT((var0, var1) -> {
            var0.showHat = var1.readBoolean();
        }, (var0, var1) -> var0.writeBoolean(var1.showHat));

        final Reader reader;
        final Writer writer;

        private Action(Reader var2, Writer var3) {
            this.reader = var2;
            this.writer = var3;
        }

        public static interface Reader {
            public void read(EntryBuilder var1, RegistryFriendlyByteBuf var2);
        }

        public static interface Writer {
            public void write(RegistryFriendlyByteBuf var1, Entry var2);
        }
    }

    static class EntryBuilder {
        final UUID profileId;
        @Nullable
        GameProfile profile;
        boolean listed;
        int latency;
        GameType gameMode = GameType.DEFAULT_MODE;
        @Nullable
        Component displayName;
        boolean showHat;
        int listOrder;
        @Nullable
        RemoteChatSession.Data chatSession;

        EntryBuilder(UUID var0) {
            this.profileId = var0;
        }

        Entry build() {
            return new Entry(this.profileId, this.profile, this.listed, this.latency, this.gameMode, this.displayName, this.showHat, this.listOrder, this.chatSession);
        }
    }
}

