/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.Entity;

public class ClientboundSetPassengersPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSetPassengersPacket> STREAM_CODEC = Packet.codec(ClientboundSetPassengersPacket::write, ClientboundSetPassengersPacket::new);
    private final int vehicle;
    private final int[] passengers;

    public ClientboundSetPassengersPacket(Entity var0) {
        this.vehicle = var0.getId();
        List<Entity> var1 = var0.getPassengers();
        this.passengers = new int[var1.size()];
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.passengers[var2] = var1.get(var2).getId();
        }
    }

    private ClientboundSetPassengersPacket(FriendlyByteBuf var0) {
        this.vehicle = var0.readVarInt();
        this.passengers = var0.readVarIntArray();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.vehicle);
        var0.writeVarIntArray(this.passengers);
    }

    @Override
    public PacketType<ClientboundSetPassengersPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_PASSENGERS;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleSetEntityPassengersPacket(this);
    }

    public int[] getPassengers() {
        return this.passengers;
    }

    public int getVehicle() {
        return this.vehicle;
    }
}

