/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> CODEC = Codec.STRING.comapFlatMap(ResourceLocation::read, ResourceLocation::toString).stable();
    public static final StreamCodec<ByteBuf, ResourceLocation> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, ResourceLocation::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    private final String namespace;
    private final String path;

    private ResourceLocation(String var0, String var1) {
        assert (ResourceLocation.isValidNamespace(var0));
        assert (ResourceLocation.isValidPath(var1));
        this.namespace = var0;
        this.path = var1;
    }

    private static ResourceLocation createUntrusted(String var0, String var1) {
        return new ResourceLocation(ResourceLocation.assertValidNamespace(var0, var1), ResourceLocation.assertValidPath(var0, var1));
    }

    public static ResourceLocation fromNamespaceAndPath(String var0, String var1) {
        return ResourceLocation.createUntrusted(var0, var1);
    }

    public static ResourceLocation parse(String var0) {
        return ResourceLocation.bySeparator(var0, ':');
    }

    public static ResourceLocation withDefaultNamespace(String var0) {
        return new ResourceLocation(DEFAULT_NAMESPACE, ResourceLocation.assertValidPath(DEFAULT_NAMESPACE, var0));
    }

    @Nullable
    public static ResourceLocation tryParse(String var0) {
        return ResourceLocation.tryBySeparator(var0, ':');
    }

    @Nullable
    public static ResourceLocation tryBuild(String var0, String var1) {
        if (ResourceLocation.isValidNamespace(var0) && ResourceLocation.isValidPath(var1)) {
            return new ResourceLocation(var0, var1);
        }
        return null;
    }

    public static ResourceLocation bySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return ResourceLocation.createUntrusted(var4, var3);
            }
            return ResourceLocation.withDefaultNamespace(var3);
        }
        return ResourceLocation.withDefaultNamespace(var0);
    }

    @Nullable
    public static ResourceLocation tryBySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (!ResourceLocation.isValidPath(var3)) {
                return null;
            }
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return ResourceLocation.isValidNamespace(var4) ? new ResourceLocation(var4, var3) : null;
            }
            return new ResourceLocation(DEFAULT_NAMESPACE, var3);
        }
        return ResourceLocation.isValidPath(var0) ? new ResourceLocation(DEFAULT_NAMESPACE, var0) : null;
    }

    public static DataResult<ResourceLocation> read(String var0) {
        try {
            return DataResult.success((Object)ResourceLocation.parse(var0));
        }
        catch (ResourceLocationException var1) {
            return DataResult.error(() -> "Not a valid resource location: " + var0 + " " + var1.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ResourceLocation withPath(String var0) {
        return new ResourceLocation(this.namespace, ResourceLocation.assertValidPath(this.namespace, var0));
    }

    public ResourceLocation withPath(UnaryOperator<String> var0) {
        return this.withPath((String)var0.apply(this.path));
    }

    public ResourceLocation withPrefix(String var0) {
        return this.withPath(var0 + this.path);
    }

    public ResourceLocation withSuffix(String var0) {
        return this.withPath(this.path + var0);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ResourceLocation) {
            ResourceLocation var1 = (ResourceLocation)var0;
            return this.namespace.equals(var1.namespace) && this.path.equals(var1.path);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation var0) {
        int var1 = this.path.compareTo(var0.path);
        if (var1 == 0) {
            var1 = this.namespace.compareTo(var0.namespace);
        }
        return var1;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toLanguageKey(String var0) {
        return var0 + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String var0, String var1) {
        return var0 + "." + this.toLanguageKey() + "." + var1;
    }

    private static String readGreedy(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && ResourceLocation.isAllowedInResourceLocation(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public static ResourceLocation read(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = ResourceLocation.readGreedy(var0);
        try {
            return ResourceLocation.parse(var2);
        }
        catch (ResourceLocationException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static ResourceLocation readNonEmpty(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = ResourceLocation.readGreedy(var0);
        if (var2.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
        try {
            return ResourceLocation.parse(var2);
        }
        catch (ResourceLocationException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static boolean isAllowedInResourceLocation(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'z' || var0 == '_' || var0 == ':' || var0 == '/' || var0 == '.' || var0 == '-';
    }

    public static boolean isValidPath(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (ResourceLocation.validPathChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (ResourceLocation.validNamespaceChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String var0, String var1) {
        if (!ResourceLocation.isValidNamespace(var0)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + var0 + ":" + var1);
        }
        return var0;
    }

    public static boolean validPathChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '/' || var0 == '.';
    }

    private static boolean validNamespaceChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '.';
    }

    private static String assertValidPath(String var0, String var1) {
        if (!ResourceLocation.isValidPath(var1)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + var0 + ":" + var1);
        }
        return var1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((ResourceLocation)object);
    }
}

