/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;

public class DifficultyCommand {
    private static final DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.difficulty.failure", object));

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder = Commands.literal("difficulty");
        for (Difficulty enumdifficulty : Difficulty.values()) {
            literalargumentbuilder.then(Commands.literal(enumdifficulty.getKey()).executes(commandcontext -> DifficultyCommand.setDifficulty((CommandSourceStack)commandcontext.getSource(), enumdifficulty)));
        }
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.requires(Commands.hasPermission(2))).executes(commandcontext -> {
            Difficulty enumdifficulty1 = ((CommandSourceStack)commandcontext.getSource()).getLevel().getDifficulty();
            ((CommandSourceStack)commandcontext.getSource()).sendSuccess(() -> Component.translatable("commands.difficulty.query", enumdifficulty1.getDisplayName()), false);
            return enumdifficulty1.getId();
        })));
    }

    public static int setDifficulty(CommandSourceStack commandlistenerwrapper, Difficulty enumdifficulty) throws CommandSyntaxException {
        MinecraftServer minecraftserver = commandlistenerwrapper.getServer();
        ServerLevel worldServer = commandlistenerwrapper.getLevel();
        if (worldServer.getDifficulty() == enumdifficulty) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)enumdifficulty.getKey());
        }
        worldServer.L.setDifficulty(enumdifficulty);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.difficulty.success", enumdifficulty.getDisplayName()), true);
        return 0;
    }
}

