/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class PublishCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.publish.alreadyPublished", var0));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("publish").requires(Commands.hasPermission(4))).executes(var0 -> PublishCommand.publish((CommandSourceStack)var0.getSource(), HttpUtil.getAvailablePort(), false, null))).then(((RequiredArgumentBuilder)Commands.argument("allowCommands", BoolArgumentType.bool()).executes(var0 -> PublishCommand.publish((CommandSourceStack)var0.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), null))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(var0 -> PublishCommand.publish((CommandSourceStack)var0.getSource(), HttpUtil.getAvailablePort(), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)var0, "gamemode")))).then(Commands.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(var0 -> PublishCommand.publish((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)var0, "gamemode"))))))));
    }

    private static int publish(CommandSourceStack var0, int var1, boolean var2, @Nullable GameType var3) throws CommandSyntaxException {
        if (var0.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)var0.getServer().getPort());
        }
        if (!var0.getServer().publishServer(var3, var2, var1)) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(() -> PublishCommand.getSuccessMessage(var1), true);
        return var1;
    }

    public static MutableComponent getSuccessMessage(int var0) {
        MutableComponent var1 = ComponentUtils.copyOnClickText(String.valueOf(var0));
        return Component.translatable("commands.publish.started", var1);
    }
}

