/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.entity.Entity;

public class TagCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tag").requires(Commands.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(Commands.literal("add").then(Commands.argument("name", StringArgumentType.word()).executes(var0 -> TagCommand.addTag((CommandSourceStack)var0.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets"), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(Commands.literal("remove").then(Commands.argument("name", StringArgumentType.word()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(TagCommand.getTags(EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets")), var1)).executes(var0 -> TagCommand.removeTag((CommandSourceStack)var0.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets"), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(Commands.literal("list").executes(var0 -> TagCommand.listTags((CommandSourceStack)var0.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets")))))));
    }

    private static Collection<String> getTags(Collection<? extends Entity> var0) {
        HashSet var1 = Sets.newHashSet();
        for (Entity entity : var0) {
            var1.addAll(entity.getTags());
        }
        return var1;
    }

    private static int addTag(CommandSourceStack var0, Collection<? extends Entity> var1, String var2) throws CommandSyntaxException {
        int var3 = 0;
        for (Entity entity : var1) {
            if (!entity.addTag(var2)) continue;
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_ADD_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.tag.add.success.single", var2, ((Entity)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.tag.add.success.multiple", var2, var1.size()), true);
        }
        return var3;
    }

    private static int removeTag(CommandSourceStack var0, Collection<? extends Entity> var1, String var2) throws CommandSyntaxException {
        int var3 = 0;
        for (Entity entity : var1) {
            if (!entity.removeTag(var2)) continue;
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_REMOVE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.tag.remove.success.single", var2, ((Entity)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.tag.remove.success.multiple", var2, var1.size()), true);
        }
        return var3;
    }

    private static int listTags(CommandSourceStack var0, Collection<? extends Entity> var1) {
        HashSet var2 = Sets.newHashSet();
        for (Entity entity : var1) {
            var2.addAll(entity.getTags());
        }
        if (var1.size() == 1) {
            Entity var3 = var1.iterator().next();
            if (var2.isEmpty()) {
                var0.sendSuccess(() -> Component.translatable("commands.tag.list.single.empty", var3.getDisplayName()), false);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.tag.list.single.success", var3.getDisplayName(), var2.size(), ComponentUtils.formatList(var2)), false);
            }
        } else if (var2.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.empty", var1.size()), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.success", var2.size(), var2.size(), ComponentUtils.formatList(var2)), false);
        }
        return var2.size();
    }
}

