/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;

public class VersionCommand {
    private static final Component HEADER = Component.translatable("commands.version.header");
    private static final Component STABLE = Component.translatable("commands.version.stable.yes");
    private static final Component UNSTABLE = Component.translatable("commands.version.stable.no");

    public static void register(CommandDispatcher<CommandSourceStack> var02, boolean var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("version").requires(Commands.hasPermission(var1 ? 2 : 0))).executes(var0 -> {
            CommandSourceStack var1 = (CommandSourceStack)var0.getSource();
            var1.sendSystemMessage(HEADER);
            VersionCommand.dumpVersion(var1::sendSystemMessage);
            return 1;
        })));
    }

    public static void dumpVersion(Consumer<Component> var0) {
        WorldVersion var1 = SharedConstants.getCurrentVersion();
        var0.accept(Component.translatable("commands.version.id", var1.id()));
        var0.accept(Component.translatable("commands.version.name", var1.name()));
        var0.accept(Component.translatable("commands.version.data", var1.dataVersion().version()));
        var0.accept(Component.translatable("commands.version.series", var1.dataVersion().series()));
        var0.accept(Component.translatable("commands.version.protocol", var1.protocolVersion(), "0x" + Integer.toHexString(var1.protocolVersion())));
        var0.accept(Component.translatable("commands.version.build_time", Component.translationArg(var1.buildTime())));
        var0.accept(Component.translatable("commands.version.pack.resource", var1.packVersion(PackType.CLIENT_RESOURCES)));
        var0.accept(Component.translatable("commands.version.pack.data", var1.packVersion(PackType.SERVER_DATA)));
        var0.accept(var1.stable() ? STABLE : UNSTABLE);
    }
}

