/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2;

public class WorldBorderCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_CENTER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_TIME = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.amount.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("worldborder").requires(Commands.hasPermission(2))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getLerpRemainingTime() + (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(Commands.literal("set").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(Commands.literal("center").then(Commands.argument("pos", Vec2Argument.vec2()).executes(commandcontext -> WorldBorderCommand.setCenter((CommandSourceStack)commandcontext.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)commandcontext, "pos")))))).then(((LiteralArgumentBuilder)Commands.literal("damage").then(Commands.literal("amount").then(Commands.argument("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> WorldBorderCommand.setDamageAmount((CommandSourceStack)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"damagePerBlock")))))).then(Commands.literal("buffer").then(Commands.argument("distance", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> WorldBorderCommand.setDamageBuffer((CommandSourceStack)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"distance"))))))).then(Commands.literal("get").executes(commandcontext -> WorldBorderCommand.getSize((CommandSourceStack)commandcontext.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("warning").then(Commands.literal("distance").then(Commands.argument("distance", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setWarningDistance((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"distance")))))).then(Commands.literal("time").then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setWarningTime((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"))))))));
    }

    private static int setDamageBuffer(CommandSourceStack commandlistenerwrapper, float f) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getDamageSafeZone() == (double)f) {
            throw ERROR_SAME_DAMAGE_BUFFER.create();
        }
        worldborder.setDamageSafeZone(f);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.damage.buffer.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(f))), true);
        return (int)f;
    }

    private static int setDamageAmount(CommandSourceStack commandlistenerwrapper, float f) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getDamagePerBlock() == (double)f) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create();
        }
        worldborder.setDamagePerBlock(f);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.damage.amount.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(f))), true);
        return (int)f;
    }

    private static int setWarningTime(CommandSourceStack commandlistenerwrapper, int i) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getWarningTime() == i) {
            throw ERROR_SAME_WARNING_TIME.create();
        }
        worldborder.setWarningTime(i);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.warning.time.success", i), true);
        return i;
    }

    private static int setWarningDistance(CommandSourceStack commandlistenerwrapper, int i) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getWarningBlocks() == i) {
            throw ERROR_SAME_WARNING_DISTANCE.create();
        }
        worldborder.setWarningBlocks(i);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.warning.distance.success", i), true);
        return i;
    }

    private static int getSize(CommandSourceStack commandlistenerwrapper) {
        double d0 = commandlistenerwrapper.getLevel().getWorldBorder().getSize();
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.get", String.format(Locale.ROOT, "%.0f", d0)), false);
        return Mth.floor(d0 + 0.5);
    }

    private static int setCenter(CommandSourceStack commandlistenerwrapper, Vec2 vec2f) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getCenterX() == (double)vec2f.x && worldborder.getCenterZ() == (double)vec2f.y) {
            throw ERROR_SAME_CENTER.create();
        }
        if ((double)Math.abs(vec2f.x) <= 2.9999984E7 && (double)Math.abs(vec2f.y) <= 2.9999984E7) {
            worldborder.setCenter(vec2f.x, vec2f.y);
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.center.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(vec2f.x)), String.format(Locale.ROOT, "%.2f", Float.valueOf(vec2f.y))), true);
            return 0;
        }
        throw ERROR_TOO_FAR_OUT.create();
    }

    private static int setSize(CommandSourceStack commandlistenerwrapper, double d0, long i) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        double d1 = worldborder.getSize();
        if (d1 == d0) {
            throw ERROR_SAME_SIZE.create();
        }
        if (d0 < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (d0 > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (i > 0L) {
            worldborder.lerpSizeBetween(d1, d0, i);
            if (d0 > d1) {
                commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.set.grow", String.format(Locale.ROOT, "%.1f", d0), Long.toString(i / 1000L)), true);
            } else {
                commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.set.shrink", String.format(Locale.ROOT, "%.1f", d0), Long.toString(i / 1000L)), true);
            }
        } else {
            worldborder.setSize(d0);
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.worldborder.set.immediate", String.format(Locale.ROOT, "%.1f", d0)), true);
        }
        return (int)(d0 - d1);
    }
}

