/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;

public interface ServerEntityGetter
extends EntityGetter {
    public ServerLevel getLevel();

    @Nullable
    default public Player getNearestPlayer(TargetingConditions var0, LivingEntity var1) {
        return this.getNearestEntity(this.players(), var0, var1, var1.getX(), var1.getY(), var1.getZ());
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions var0, LivingEntity var1, double var2, double var4, double var6) {
        return this.getNearestEntity(this.players(), var0, var1, var2, var4, var6);
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions var0, double var1, double var3, double var5) {
        return this.getNearestEntity(this.players(), var0, null, var1, var3, var5);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(Class<? extends T> var02, TargetingConditions var1, @Nullable LivingEntity var2, double var3, double var5, double var7, AABB var9) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(var02, var9, var0 -> true), var1, var2, var3, var5, var7);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(List<? extends T> var0, TargetingConditions var1, @Nullable LivingEntity var2, double var3, double var5, double var7) {
        double var9 = -1.0;
        LivingEntity var11 = null;
        for (LivingEntity var13 : var0) {
            if (!var1.test(this.getLevel(), var2, var13)) continue;
            double var14 = var13.distanceToSqr(var3, var5, var7);
            if (var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = var13;
        }
        return (T)var11;
    }

    default public List<Player> getNearbyPlayers(TargetingConditions var0, LivingEntity var1, AABB var2) {
        ArrayList<Player> var3 = new ArrayList<Player>();
        for (Player player : this.players()) {
            if (!var2.contains(player.getX(), player.getY(), player.getZ()) || !var0.test(this.getLevel(), var1, player)) continue;
            var3.add(player);
        }
        return var3;
    }

    default public <T extends LivingEntity> List<T> getNearbyEntities(Class<T> var02, TargetingConditions var1, LivingEntity var2, AABB var3) {
        List<LivingEntity> var4 = this.getEntitiesOfClass(var02, var3, var0 -> true);
        ArrayList<LivingEntity> var5 = new ArrayList<LivingEntity>();
        for (LivingEntity var7 : var4) {
            if (!var1.test(this.getLevel(), var2, var7)) continue;
            var5.add(var7);
        }
        return var5;
    }
}

