/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class Pack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    public final ResourcesSupplier resources;
    private final Metadata metadata;
    private final PackSelectionConfig selectionConfig;

    @Nullable
    public static Pack readMetaAndCreate(PackLocationInfo var0, ResourcesSupplier var1, PackType var2, PackSelectionConfig var3) {
        int var4 = SharedConstants.getCurrentVersion().packVersion(var2);
        Metadata var5 = Pack.readPackMetadata(var0, var1, var4);
        return var5 != null ? new Pack(var0, var1, var5, var3) : null;
    }

    public Pack(PackLocationInfo var0, ResourcesSupplier var1, Metadata var2, PackSelectionConfig var3) {
        this.location = var0;
        this.resources = var1;
        this.metadata = var2;
        this.selectionConfig = var3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Metadata readPackMetadata(PackLocationInfo var0, ResourcesSupplier var1, int var2) {
        try (PackResources var3 = var1.openPrimary(var0);){
            PackMetadataSection var4 = var3.getMetadataSection(PackMetadataSection.TYPE);
            if (var4 == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)var0.id());
                Metadata metadata = null;
                return metadata;
            }
            FeatureFlagsMetadataSection var5 = var3.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet var6 = var5 != null ? var5.flags() : FeatureFlagSet.of();
            InclusiveRange<Integer> var7 = Pack.getDeclaredPackVersions(var0.id(), var4);
            PackCompatibility var8 = PackCompatibility.forVersion(var7, var2);
            OverlayMetadataSection var9 = var3.getMetadataSection(OverlayMetadataSection.TYPE);
            List<String> var10 = var9 != null ? var9.overlaysForVersion(var2) : List.of();
            Metadata metadata = new Metadata(var4.description(), var8, var6, var10);
            return metadata;
        }
        catch (Exception var32) {
            LOGGER.warn("Failed to read pack {} metadata", (Object)var0.id(), (Object)var32);
            return null;
        }
    }

    private static InclusiveRange<Integer> getDeclaredPackVersions(String var0, PackMetadataSection var1) {
        int var2 = var1.packFormat();
        if (var1.supportedFormats().isEmpty()) {
            return new InclusiveRange<Integer>(var2);
        }
        InclusiveRange<Integer> var3 = var1.supportedFormats().get();
        if (!var3.isValueInRange(var2)) {
            LOGGER.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{var0, var3, var2, var2});
            return new InclusiveRange<Integer>(var2);
        }
        return var3;
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public Component getTitle() {
        return this.location.title();
    }

    public Component getDescription() {
        return this.metadata.description();
    }

    public Component getChatLink(boolean var0) {
        return this.location.createChatLink(var0, this.metadata.description);
    }

    public PackCompatibility getCompatibility() {
        return this.metadata.compatibility();
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.metadata.requestedFeatures();
    }

    public PackResources open() {
        return this.resources.openFull(this.location, this.metadata);
    }

    public String getId() {
        return this.location.id();
    }

    public PackSelectionConfig selectionConfig() {
        return this.selectionConfig;
    }

    public boolean isRequired() {
        return this.selectionConfig.required();
    }

    public boolean isFixedPosition() {
        return this.selectionConfig.fixedPosition();
    }

    public Position getDefaultPosition() {
        return this.selectionConfig.defaultPosition();
    }

    public PackSource getPackSource() {
        return this.location.source();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Pack)) {
            return false;
        }
        Pack var1 = (Pack)var0;
        return this.location.equals(var1.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public static interface ResourcesSupplier {
        public PackResources openPrimary(PackLocationInfo var1);

        public PackResources openFull(PackLocationInfo var1, Metadata var2);
    }

    public static final class Metadata
    extends Record {
        final Component description;
        private final PackCompatibility compatibility;
        private final FeatureFlagSet requestedFeatures;
        private final List<String> overlays;

        public Metadata(Component var0, PackCompatibility var1, FeatureFlagSet var2, List<String> var3) {
            this.description = var0;
            this.compatibility = var1;
            this.requestedFeatures = var2;
            this.overlays = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Metadata.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Metadata.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Metadata.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this, var0);
        }

        public Component description() {
            return this.description;
        }

        public PackCompatibility compatibility() {
            return this.compatibility;
        }

        public FeatureFlagSet requestedFeatures() {
            return this.requestedFeatures;
        }

        public List<String> overlays() {
            return this.overlays;
        }
    }

    public static enum Position {
        TOP,
        BOTTOM;


        public <T> int insert(List<T> var0, T var1, Function<T, PackSelectionConfig> var2, boolean var3) {
            PackSelectionConfig var6;
            int var5;
            Position var4;
            Position position = var4 = var3 ? this.opposite() : this;
            if (var4 == BOTTOM) {
                PackSelectionConfig var62;
                int var52;
                for (var52 = 0; var52 < var0.size() && (var62 = var2.apply(var0.get(var52))).fixedPosition() && var62.defaultPosition() == this; ++var52) {
                }
                var0.add(var52, var1);
                return var52;
            }
            for (var5 = var0.size() - 1; var5 >= 0 && (var6 = var2.apply(var0.get(var5))).fixedPosition() && var6.defaultPosition() == this; --var5) {
            }
            var0.add(var5 + 1, var1);
            return var5 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }
    }
}

