/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.players.StoredUserEntry;

public class ServerOpListEntry
extends StoredUserEntry<GameProfile> {
    private final int level;
    private final boolean bypassesPlayerLimit;

    public ServerOpListEntry(GameProfile var0, int var1, boolean var2) {
        super(var0);
        this.level = var1;
        this.bypassesPlayerLimit = var2;
    }

    public ServerOpListEntry(JsonObject var0) {
        super(ServerOpListEntry.createGameProfile(var0));
        this.level = var0.has("level") ? var0.get("level").getAsInt() : 0;
        this.bypassesPlayerLimit = var0.has("bypassesPlayerLimit") && var0.get("bypassesPlayerLimit").getAsBoolean();
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getBypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    protected void serialize(JsonObject var0) {
        if (this.getUser() == null) {
            return;
        }
        var0.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
        var0.addProperty("name", ((GameProfile)this.getUser()).getName());
        var0.addProperty("level", (Number)this.level);
        var0.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
    }

    @Nullable
    private static GameProfile createGameProfile(JsonObject var0) {
        UUID var2;
        if (!var0.has("uuid") || !var0.has("name")) {
            return null;
        }
        String var1 = var0.get("uuid").getAsString();
        try {
            var2 = UUID.fromString(var1);
        }
        catch (Throwable var3) {
            return null;
        }
        return new GameProfile(var2, var0.get("name").getAsString());
    }
}

