/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.util.datafix.fixes.References;

public class WallPropertyFix
extends DataFix {
    private static final Set<String> WALL_BLOCKS = ImmutableSet.of((Object)"minecraft:andesite_wall", (Object)"minecraft:brick_wall", (Object)"minecraft:cobblestone_wall", (Object)"minecraft:diorite_wall", (Object)"minecraft:end_stone_brick_wall", (Object)"minecraft:granite_wall", (Object[])new String[]{"minecraft:mossy_cobblestone_wall", "minecraft:mossy_stone_brick_wall", "minecraft:nether_brick_wall", "minecraft:prismarine_wall", "minecraft:red_nether_brick_wall", "minecraft:red_sandstone_wall", "minecraft:sandstone_wall", "minecraft:stone_brick_wall"});

    public WallPropertyFix(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WallPropertyFix", this.getInputSchema().getType(References.BLOCK_STATE), var0 -> var0.update(DSL.remainderFinder(), WallPropertyFix::upgradeBlockStateTag));
    }

    private static String mapProperty(String var0) {
        return "true".equals(var0) ? "low" : "none";
    }

    private static <T> Dynamic<T> fixWallProperty(Dynamic<T> var02, String var1) {
        return var02.update(var1, var0 -> (Dynamic)DataFixUtils.orElse(var0.asString().result().map(WallPropertyFix::mapProperty).map(arg_0 -> ((Dynamic)var0).createString(arg_0)), (Object)var0));
    }

    private static <T> Dynamic<T> upgradeBlockStateTag(Dynamic<T> var02) {
        boolean var1 = var02.get("Name").asString().result().filter(WALL_BLOCKS::contains).isPresent();
        if (!var1) {
            return var02;
        }
        return var02.update("Properties", var0 -> {
            Dynamic var1 = WallPropertyFix.fixWallProperty(var0, "east");
            var1 = WallPropertyFix.fixWallProperty(var1, "west");
            var1 = WallPropertyFix.fixWallProperty(var1, "north");
            return WallPropertyFix.fixWallProperty(var1, "south");
        });
    }
}

