/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;

public record GcHeapStat(Instant timestamp, long heapUsed, Timing timing) {
    public static GcHeapStat from(RecordedEvent var0) {
        return new GcHeapStat(var0.getStartTime(), var0.getLong("heapUsed"), var0.getString("when").equalsIgnoreCase("before gc") ? Timing.BEFORE_GC : Timing.AFTER_GC);
    }

    public static Summary summary(Duration var0, List<GcHeapStat> var1, Duration var2, int var3) {
        return new Summary(var0, var2, var3, GcHeapStat.calculateAllocationRatePerSecond(var1));
    }

    private static double calculateAllocationRatePerSecond(List<GcHeapStat> var02) {
        long var1 = 0L;
        Map<Timing, List<GcHeapStat>> var3 = var02.stream().collect(Collectors.groupingBy(var0 -> var0.timing));
        List<GcHeapStat> var4 = var3.get((Object)Timing.BEFORE_GC);
        List<GcHeapStat> var5 = var3.get((Object)Timing.AFTER_GC);
        for (int var6 = 1; var6 < var4.size(); ++var6) {
            GcHeapStat var7 = var4.get(var6);
            GcHeapStat var8 = var5.get(var6 - 1);
            var1 += var7.heapUsed - var8.heapUsed;
        }
        Duration var6 = Duration.between(var02.get((int)1).timestamp, var02.get((int)(var02.size() - 1)).timestamp);
        return (double)var1 / (double)var6.getSeconds();
    }

    static enum Timing {
        BEFORE_GC,
        AFTER_GC;

    }

    public record Summary(Duration duration, Duration gcTotalDuration, int totalGCs, double allocationRateBytesPerSecond) {
        public float gcOverHead() {
            return (float)this.gcTotalDuration.toMillis() / (float)this.duration.toMillis();
        }
    }
}

