/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedRandom;

public final class WeightedList<E> {
    private static final int FLAT_THRESHOLD = 64;
    private final int totalWeight;
    private final List<Weighted<E>> items;
    @Nullable
    private final Selector<E> selector;

    WeightedList(List<? extends Weighted<E>> var0) {
        this.items = List.copyOf(var0);
        this.totalWeight = WeightedRandom.getTotalWeight(var0, Weighted::weight);
        this.selector = this.totalWeight == 0 ? null : (this.totalWeight < 64 ? new Flat<E>(this.items, this.totalWeight) : new Compact<E>(this.items));
    }

    public static <E> WeightedList<E> of() {
        return new WeightedList<E>(List.of());
    }

    public static <E> WeightedList<E> of(E var0) {
        return new WeightedList<E>(List.of(new Weighted<E>(var0, 1)));
    }

    @SafeVarargs
    public static <E> WeightedList<E> of(Weighted<E> ... var0) {
        return new WeightedList<E>(List.of(var0));
    }

    public static <E> WeightedList<E> of(List<Weighted<E>> var0) {
        return new WeightedList<E>(var0);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public <T> WeightedList<T> map(Function<E, T> var0) {
        return new WeightedList<E>(Lists.transform(this.items, var1 -> var1.map(var0)));
    }

    public Optional<E> getRandom(RandomSource var0) {
        if (this.selector == null) {
            return Optional.empty();
        }
        int var1 = var0.nextInt(this.totalWeight);
        return Optional.of(this.selector.get(var1));
    }

    public E getRandomOrThrow(RandomSource var0) {
        if (this.selector == null) {
            throw new IllegalStateException("Weighted list has no elements");
        }
        int var1 = var0.nextInt(this.totalWeight);
        return this.selector.get(var1);
    }

    public List<Weighted<E>> unwrap() {
        return this.items;
    }

    public static <E> Codec<WeightedList<E>> codec(Codec<E> var0) {
        return Weighted.codec(var0).listOf().xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> codec(MapCodec<E> var0) {
        return Weighted.codec(var0).listOf().xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> nonEmptyCodec(Codec<E> var0) {
        return ExtraCodecs.nonEmptyList(Weighted.codec(var0).listOf()).xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> nonEmptyCodec(MapCodec<E> var0) {
        return ExtraCodecs.nonEmptyList(Weighted.codec(var0).listOf()).xmap(WeightedList::of, WeightedList::unwrap);
    }

    public boolean contains(E var0) {
        for (Weighted<E> var2 : this.items) {
            if (!var2.value().equals(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof WeightedList) {
            WeightedList var1 = (WeightedList)var0;
            return this.totalWeight == var1.totalWeight && Objects.equals(this.items, var1.items);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.totalWeight;
        var0 = 31 * var0 + this.items.hashCode();
        return var0;
    }

    static interface Selector<E> {
        public E get(int var1);
    }

    static class Flat<E>
    implements Selector<E> {
        private final Object[] entries;

        Flat(List<Weighted<E>> var0, int var1) {
            this.entries = new Object[var1];
            int var2 = 0;
            for (Weighted<E> var4 : var0) {
                int var5 = var4.weight();
                Arrays.fill(this.entries, var2, var2 + var5, var4.value());
                var2 += var5;
            }
        }

        @Override
        public E get(int var0) {
            return (E)this.entries[var0];
        }
    }

    static class Compact<E>
    implements Selector<E> {
        private final Weighted<?>[] entries;

        Compact(List<Weighted<E>> var0) {
            this.entries = (Weighted[])var0.toArray(Weighted[]::new);
        }

        @Override
        public E get(int var0) {
            for (Weighted<?> var4 : this.entries) {
                if ((var0 -= var4.weight()) >= 0) continue;
                return (E)var4.value();
            }
            throw new IllegalStateException(var0 + " exceeded total weight");
        }
    }

    public static class Builder<E> {
        private final ImmutableList.Builder<Weighted<E>> result = ImmutableList.builder();

        public Builder<E> add(E var0) {
            return this.add(var0, 1);
        }

        public Builder<E> add(E var0, int var1) {
            this.result.add(new Weighted<E>(var0, var1));
            return this;
        }

        public WeightedList<E> build() {
            return new WeightedList(this.result.build());
        }
    }
}

