/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_RESPONSE_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    private static final float DEFAULT_WIDTH = 1.0f;
    private static final float DEFAULT_HEIGHT = 1.0f;
    private static final boolean DEFAULT_RESPONSE = false;
    @Nullable
    public PlayerAction attack;
    @Nullable
    public PlayerAction interaction;

    public Interaction(EntityType<?> entitytypes, Level world) {
        super(entitytypes, world);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        datawatcher_a.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        datawatcher_a.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.setWidth(valueinput.getFloatOr(TAG_WIDTH, 1.0f));
        this.setHeight(valueinput.getFloatOr(TAG_HEIGHT, 1.0f));
        this.attack = valueinput.read(TAG_ATTACK, PlayerAction.CODEC).orElse(null);
        this.interaction = valueinput.read(TAG_INTERACTION, PlayerAction.CODEC).orElse(null);
        this.setResponse(valueinput.getBooleanOr(TAG_RESPONSE, false));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.putFloat(TAG_WIDTH, this.getWidth());
        valueoutput.putFloat(TAG_HEIGHT, this.getHeight());
        valueoutput.storeNullable(TAG_ATTACK, PlayerAction.CODEC, this.attack);
        valueoutput.storeNullable(TAG_INTERACTION, PlayerAction.CODEC, this.interaction);
        valueoutput.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (DATA_HEIGHT_ID.equals(datawatcherobject) || DATA_WIDTH_ID.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            DamageSource source = entityhuman.damageSources().playerAttack(entityhuman);
            EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(this, source, 1.0, false);
            if (event.isCancelled()) {
                return true;
            }
            this.attack = new PlayerAction(entityhuman.getUUID(), this.level().getGameTime());
            if (entityhuman instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(entityplayer, this, source, (float)event.getFinalDamage(), 1.0f, false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return false;
    }

    @Override
    public InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        if (this.level().isClientSide) {
            return this.getResponse() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(entityhuman.getUUID(), this.level().getGameTime());
        return InteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        return this.attack != null ? this.level().getPlayerByUUID(this.attack.player()) : null;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.interaction != null ? this.level().getPlayerByUUID(this.interaction.player()) : null;
    }

    public void setWidth(float f) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(f));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float f) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(f));
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    public void setResponse(boolean flag) {
        this.entityData.set(DATA_RESPONSE_ID, flag);
    }

    public boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntityDimensions getDimensions(Pose entitypose) {
        return this.getDimensions();
    }

    @Override
    protected AABB makeBoundingBox(Vec3 vec3d) {
        return this.getDimensions().makeBoundingBox(vec3d);
    }

    public record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)instance, PlayerAction::new));
    }
}

