/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;

public class RamTarget
extends Behavior<Goat> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<Goat, UniformInt> getTimeBetweenRams;
    private final TargetingConditions ramTargeting;
    private final float speed;
    private final ToDoubleFunction<Goat> getKnockbackForce;
    private Vec3 ramDirection;
    private final Function<Goat, SoundEvent> getImpactSound;
    private final Function<Goat, SoundEvent> getHornBreakSound;

    public RamTarget(Function<Goat, UniformInt> var0, TargetingConditions var1, float var2, ToDoubleFunction<Goat> var3, Function<Goat, SoundEvent> var4, Function<Goat, SoundEvent> var5) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.RAM_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 200);
        this.getTimeBetweenRams = var0;
        this.ramTargeting = var1;
        this.speed = var2;
        this.getKnockbackForce = var3;
        this.getImpactSound = var4;
        this.getHornBreakSound = var5;
        this.ramDirection = Vec3.ZERO;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Goat var1) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Goat var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected void start(ServerLevel var0, Goat var1, long var2) {
        BlockPos var4 = var1.blockPosition();
        Brain<Goat> var5 = var1.getBrain();
        Vec3 var6 = var5.getMemory(MemoryModuleType.RAM_TARGET).get();
        this.ramDirection = new Vec3((double)var4.getX() - var6.x(), 0.0, (double)var4.getZ() - var6.z()).normalize();
        var5.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(var6, this.speed, 0));
    }

    @Override
    protected void tick(ServerLevel var0, Goat var1, long var2) {
        List<LivingEntity> var4 = var0.getNearbyEntities(LivingEntity.class, this.ramTargeting, var1, var1.getBoundingBox());
        Brain<Goat> var5 = var1.getBrain();
        if (!var4.isEmpty()) {
            float var8;
            DamageSource var7;
            LivingEntity var6 = var4.get(0);
            if (var6.hurtServer(var0, var7 = var0.damageSources().noAggroMobAttack(var1), var8 = (float)var1.getAttributeValue(Attributes.ATTACK_DAMAGE))) {
                EnchantmentHelper.doPostAttackEffects(var0, var6, var7);
            }
            int var9 = var1.hasEffect(MobEffects.SPEED) ? var1.getEffect(MobEffects.SPEED).getAmplifier() + 1 : 0;
            int var10 = var1.hasEffect(MobEffects.SLOWNESS) ? var1.getEffect(MobEffects.SLOWNESS).getAmplifier() + 1 : 0;
            float var11 = 0.25f * (float)(var9 - var10);
            float var12 = Mth.clamp(var1.getSpeed() * 1.65f, 0.2f, 3.0f) + var11;
            DamageSource var13 = var0.damageSources().mobAttack(var1);
            float var14 = var6.applyItemBlocking(var0, var13, var8);
            float var15 = var14 > 0.0f ? 0.5f : 1.0f;
            var6.knockback((double)(var15 * var12) * this.getKnockbackForce.applyAsDouble(var1), this.ramDirection.x(), this.ramDirection.z());
            this.finishRam(var0, var1);
            var0.playSound(null, var1, this.getImpactSound.apply(var1), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (this.hasRammedHornBreakingBlock(var0, var1)) {
            var0.playSound(null, var1, this.getImpactSound.apply(var1), SoundSource.NEUTRAL, 1.0f, 1.0f);
            boolean var6 = var1.dropHorn();
            if (var6) {
                var0.playSound(null, var1, this.getHornBreakSound.apply(var1), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.finishRam(var0, var1);
        } else {
            boolean var8;
            Optional<WalkTarget> var6 = var5.getMemory(MemoryModuleType.WALK_TARGET);
            Optional<Vec3> var7 = var5.getMemory(MemoryModuleType.RAM_TARGET);
            boolean bl = var8 = var6.isEmpty() || var7.isEmpty() || var6.get().getTarget().currentPosition().closerThan(var7.get(), 0.25);
            if (var8) {
                this.finishRam(var0, var1);
            }
        }
    }

    private boolean hasRammedHornBreakingBlock(ServerLevel var0, Goat var1) {
        Vec3 var2 = var1.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        BlockPos var3 = BlockPos.containing(var1.position().add(var2));
        return var0.getBlockState(var3).is(BlockTags.SNAPS_GOAT_HORN) || var0.getBlockState(var3.above()).is(BlockTags.SNAPS_GOAT_HORN);
    }

    protected void finishRam(ServerLevel var0, Goat var1) {
        var0.broadcastEntityEvent(var1, (byte)59);
        var1.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, this.getTimeBetweenRams.apply(var1).sample(var0.random));
        var1.getBrain().eraseMemory(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Goat)livingEntity, l);
    }
}

