/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;

public class CatSitOnBlockGoal
extends MoveToBlockGoal {
    private final Cat cat;

    public CatSitOnBlockGoal(Cat var0, double var1) {
        super(var0, var1, 8);
        this.cat = var0;
    }

    @Override
    public boolean canUse() {
        return this.cat.isTame() && !this.cat.isOrderedToSit() && super.canUse();
    }

    @Override
    public void start() {
        super.start();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void stop() {
        super.stop();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void tick() {
        super.tick();
        this.cat.setInSittingPose(this.isReachedTarget());
    }

    @Override
    protected boolean isValidTarget(LevelReader var0, BlockPos var1) {
        if (!var0.isEmptyBlock(var1.above())) {
            return false;
        }
        BlockState var2 = var0.getBlockState(var1);
        if (var2.is(Blocks.CHEST)) {
            return ChestBlockEntity.getOpenCount(var0, var1) < 1;
        }
        if (var2.is(Blocks.FURNACE) && var2.getValue(FurnaceBlock.LIT).booleanValue()) {
            return true;
        }
        return var2.is(BlockTags.BEDS, var02 -> var02.getOptionalValue(BedBlock.PART).map(var0 -> var0 != BedPart.HEAD).orElse(true));
    }
}

