/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class GoalSelector {
    private static final WrappedGoal NO_GOAL = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<Goal.Flag, WrappedGoal> lockedFlags = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final Set<WrappedGoal> availableGoals = new ObjectLinkedOpenHashSet();
    private final EnumSet<Goal.Flag> disabledFlags = EnumSet.noneOf(Goal.Flag.class);

    public void addGoal(int var0, Goal var1) {
        this.availableGoals.add(new WrappedGoal(var0, var1));
    }

    public void removeAllGoals(Predicate<Goal> var0) {
        this.availableGoals.removeIf(var1 -> var0.test(var1.getGoal()));
    }

    public void removeGoal(Goal var0) {
        for (WrappedGoal var2 : this.availableGoals) {
            if (var2.getGoal() != var0 || !var2.isRunning()) continue;
            var2.stop();
        }
        this.availableGoals.removeIf(var1 -> var1.getGoal() == var0);
    }

    private static boolean goalContainsAnyFlags(WrappedGoal var0, EnumSet<Goal.Flag> var1) {
        for (Goal.Flag var3 : var0.getFlags()) {
            if (!var1.contains((Object)var3)) continue;
            return true;
        }
        return false;
    }

    private static boolean goalCanBeReplacedForAllFlags(WrappedGoal var0, Map<Goal.Flag, WrappedGoal> var1) {
        for (Goal.Flag var3 : var0.getFlags()) {
            if (var1.getOrDefault((Object)var3, NO_GOAL).canBeReplacedBy(var0)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        ProfilerFiller var02 = Profiler.get();
        var02.push("goalCleanup");
        for (WrappedGoal var2 : this.availableGoals) {
            if (!var2.isRunning() || !GoalSelector.goalContainsAnyFlags(var2, this.disabledFlags) && var2.canContinueToUse()) continue;
            var2.stop();
        }
        this.lockedFlags.entrySet().removeIf(var0 -> !((WrappedGoal)var0.getValue()).isRunning());
        var02.pop();
        var02.push("goalUpdate");
        for (WrappedGoal var2 : this.availableGoals) {
            if (var2.isRunning() || GoalSelector.goalContainsAnyFlags(var2, this.disabledFlags) || !GoalSelector.goalCanBeReplacedForAllFlags(var2, this.lockedFlags) || !var2.canUse()) continue;
            for (Goal.Flag var4 : var2.getFlags()) {
                WrappedGoal var5 = this.lockedFlags.getOrDefault((Object)var4, NO_GOAL);
                var5.stop();
                this.lockedFlags.put(var4, var2);
            }
            var2.start();
        }
        var02.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean var0) {
        ProfilerFiller var1 = Profiler.get();
        var1.push("goalTick");
        for (WrappedGoal var3 : this.availableGoals) {
            if (!var3.isRunning() || !var0 && !var3.requiresUpdateEveryTick()) continue;
            var3.tick();
        }
        var1.pop();
    }

    public Set<WrappedGoal> getAvailableGoals() {
        return this.availableGoals;
    }

    public void disableControlFlag(Goal.Flag var0) {
        this.disabledFlags.add(var0);
    }

    public void enableControlFlag(Goal.Flag var0) {
        this.disabledFlags.remove((Object)var0);
    }

    public void setControlFlag(Goal.Flag var0, boolean var1) {
        if (var1) {
            this.enableControlFlag(var0);
        } else {
            this.disableControlFlag(var0);
        }
    }
}

