/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class AbstractHorse
extends Animal
implements HasCustomInventoryScreen,
OwnableEntity,
PlayerRideableJumping {
    public static final int CHEST_SLOT_OFFSET = 499;
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final double BREEDING_CROSS_FACTOR = 0.15;
    private static final float MIN_MOVEMENT_SPEED = (float)AbstractHorse.generateSpeed(() -> 0.0);
    private static final float MAX_MOVEMENT_SPEED = (float)AbstractHorse.generateSpeed(() -> 1.0);
    private static final float MIN_JUMP_STRENGTH = (float)AbstractHorse.generateJumpStrength(() -> 0.0);
    private static final float MAX_JUMP_STRENGTH = (float)AbstractHorse.generateJumpStrength(() -> 1.0);
    private static final float MIN_HEALTH = AbstractHorse.generateMaxHealth(i -> 0);
    private static final float MAX_HEALTH = AbstractHorse.generateMaxHealth(i -> i - 1);
    private static final float BACKWARDS_MOVE_SPEED_FACTOR = 0.25f;
    private static final float SIDEWAYS_MOVE_SPEED_FACTOR = 0.5f;
    private static final TargetingConditions.Selector PARENT_HORSE_SELECTOR = (entityliving, worldserver) -> {
        AbstractHorse entityhorseabstract;
        if (entityliving instanceof AbstractHorse && (entityhorseabstract = (AbstractHorse)entityliving).isBred()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    };
    private static final TargetingConditions MOMMY_TARGETING = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().selector(PARENT_HORSE_SELECTOR);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(AbstractHorse.class, EntityDataSerializers.BYTE);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    public static final int INVENTORY_ROWS = 3;
    private static final int DEFAULT_TEMPER = 0;
    private static final boolean DEFAULT_EATING_HAYSTACK = false;
    private static final boolean DEFAULT_BRED = false;
    private static final boolean DEFAULT_TAME = false;
    private int eatingCounter;
    private int mouthCounter;
    private int standCounter;
    public int tailCounter;
    public int sprintCounter;
    public SimpleContainer inventory;
    protected int temper = 0;
    protected float playerJumpPendingScale;
    protected boolean allowStandSliding;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    @Nullable
    public EntityReference<LivingEntity> owner;
    public int maxDomestication = 100;

    protected AbstractHorse(EntityType<? extends AbstractHorse> entitytypes, Level world) {
        super((EntityType<? extends Animal>)entitytypes, world);
        this.createInventory();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.2));
        this.goalSelector.addGoal(1, new RunAroundLikeCrazyGoal(this, 1.2));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0, AbstractHorse.class));
        this.goalSelector.addGoal(4, new FollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(6, new WaterAvoidingRandomStrollGoal(this, 0.7));
        this.goalSelector.addGoal(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        if (this.canPerformRearing()) {
            this.goalSelector.addGoal(9, new RandomStandGoal(this));
        }
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(3, new TemptGoal(this, 1.25, itemstack -> itemstack.is(ItemTags.HORSE_TEMPT_ITEMS), false));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ID_FLAGS, (byte)0);
    }

    protected boolean getFlag(int i) {
        return (this.entityData.get(DATA_ID_FLAGS) & i) != 0;
    }

    protected void setFlag(int i, boolean flag) {
        byte b0 = this.entityData.get(DATA_ID_FLAGS);
        if (flag) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 | i));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 & ~i));
        }
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Override
    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity entityliving) {
        this.owner = entityliving != null ? new EntityReference<LivingEntity>(entityliving) : null;
    }

    public void setTamed(boolean flag) {
        this.setFlag(2, flag);
    }

    @Override
    public void onElasticLeashPull() {
        super.onElasticLeashPull();
        if (this.isEating()) {
            this.setEating(false);
        }
    }

    @Override
    public boolean supportQuadLeash() {
        return true;
    }

    @Override
    public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.04, 0.52, 0.23, 0.87);
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean flag) {
        this.setFlag(8, flag);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.SADDLE ? super.canUseSlot(enumitemslot) : this.isAlive() && !this.isBaby() && this.isTamed();
    }

    public void equipBodyArmor(Player entityhuman, ItemStack itemstack) {
        if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY)) {
            this.setBodyArmorItem(itemstack.consumeAndReturn(1, entityhuman));
        }
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return (enumitemslot == EquipmentSlot.BODY || enumitemslot == EquipmentSlot.SADDLE) && this.isTamed() || super.canDispenserEquipIntoSlot(enumitemslot);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int modifyTemper(int i) {
        int j = Mth.clamp(this.getTemper() + i, 0, this.getMaxTemper());
        this.setTemper(j);
        return j;
    }

    @Override
    public boolean isPushable() {
        return !this.isVehicle();
    }

    private void eating() {
        SoundEvent soundeffect;
        this.openMouth();
        if (!this.isSilent() && (soundeffect = this.getEatingSound()) != null) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean causeFallDamage(double d0, float f, DamageSource damagesource) {
        int i;
        if (d0 > 1.0) {
            this.playSound(SoundEvents.HORSE_LAND, 0.4f, 1.0f);
        }
        if ((i = this.calculateFallDamage(d0, f)) <= 0) {
            return false;
        }
        this.hurt(damagesource, i);
        this.propagateFallToPassengers(d0, f, damagesource);
        this.playBlockFallSound();
        return true;
    }

    public final int getInventorySize() {
        return AbstractHorse.getInventorySize(this.getInventoryColumns());
    }

    public static int getInventorySize(int i) {
        return i * 3;
    }

    public void createInventory() {
        SimpleContainer inventorysubcontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize(), (InventoryHolder)((org.bukkit.entity.AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            int i = Math.min(inventorysubcontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventorysubcontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EquipmentSlot.SADDLE ? SoundEvents.HORSE_SADDLE : super.getEquipSound(enumitemslot, itemstack, equippable);
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        boolean flag = super.hurtServer(worldserver, damagesource, f);
        if (flag && this.random.nextInt(3) == 0) {
            this.standIfPossible();
        }
        return flag;
    }

    protected boolean canPerformRearing() {
        return true;
    }

    @Nullable
    protected SoundEvent getEatingSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        return null;
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        if (!iblockdata.liquid()) {
            BlockState iblockdata1 = this.level().getBlockState(blockposition.above());
            SoundType soundeffecttype = iblockdata.getSoundType();
            if (iblockdata1.is(Blocks.SNOW)) {
                soundeffecttype = iblockdata1.getSoundType();
            }
            if (this.isVehicle() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundeffecttype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.playSound(SoundEvents.HORSE_STEP_WOOD, soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
                }
            } else if (this.isWoodSoundType(soundeffecttype)) {
                this.playSound(SoundEvents.HORSE_STEP_WOOD, soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
            } else {
                this.playSound(SoundEvents.HORSE_STEP, soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
            }
        }
    }

    private boolean isWoodSoundType(SoundType soundeffecttype) {
        return soundeffecttype == SoundType.WOOD || soundeffecttype == SoundType.NETHER_WOOD || soundeffecttype == SoundType.STEM || soundeffecttype == SoundType.CHERRY_WOOD || soundeffecttype == SoundType.BAMBOO_WOOD;
    }

    protected void playGallopSound(SoundType soundeffecttype) {
        this.playSound(SoundEvents.HORSE_GALLOP, soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
    }

    public static AttributeSupplier.Builder createBaseHorseAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.JUMP_STRENGTH, 0.7).add(Attributes.MAX_HEALTH, 53.0).add(Attributes.MOVEMENT_SPEED, 0.225f).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.SAFE_FALL_DISTANCE, 6.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.5);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 6;
    }

    public int getMaxTemper() {
        return this.maxDomestication;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 400;
    }

    @Override
    public void openCustomInventoryScreen(Player entityhuman) {
        if (!this.level().isClientSide && (!this.isVehicle() || this.hasPassenger(entityhuman)) && this.isTamed()) {
            entityhuman.openHorseInventory(this, this.inventory);
        }
    }

    public InteractionResult fedFood(Player entityhuman, ItemStack itemstack) {
        boolean flag = this.handleEating(entityhuman, itemstack);
        if (flag) {
            itemstack.consume(1, entityhuman);
        }
        return (InteractionResult)((Object)(!flag && !this.level().isClientSide ? InteractionResult.PASS : InteractionResult.SUCCESS_SERVER));
    }

    protected boolean handleEating(Player entityhuman, ItemStack itemstack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        if (itemstack.is(Items.WHEAT)) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (itemstack.is(Items.SUGAR)) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (itemstack.is(Blocks.HAY_BLOCK.asItem())) {
            f = 20.0f;
            i = 180;
        } else if (itemstack.is(Items.APPLE)) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (itemstack.is(Items.CARROT)) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (itemstack.is(Items.GOLDEN_CARROT)) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (!this.level().isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                flag = true;
                this.setInLove(entityhuman);
            }
        } else if (itemstack.is(Items.GOLDEN_APPLE) || itemstack.is(Items.ENCHANTED_GOLDEN_APPLE)) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (!this.level().isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                flag = true;
                this.setInLove(entityhuman);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && f > 0.0f) {
            this.heal(f, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.isBaby() && i > 0) {
            this.level().addParticle(ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide) {
                this.ageUp(i);
                flag = true;
            }
        }
        if (!(j <= 0 || !flag && this.isTamed() || this.getTemper() >= this.getMaxTemper() || this.level().isClientSide)) {
            this.modifyTemper(j);
            flag = true;
        }
        if (flag) {
            this.eating();
            this.gameEvent(GameEvent.EAT);
        }
        return flag;
    }

    protected void doPlayerRide(Player entityhuman) {
        this.setEating(false);
        this.clearStanding();
        if (!this.level().isClientSide) {
            entityhuman.setYRot(this.getYRot());
            entityhuman.setXRot(this.getXRot());
            entityhuman.startRiding(this);
        }
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() && this.isVehicle() && this.isSaddled() || this.isEating() || this.isStanding();
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.HORSE_FOOD);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    protected void dropEquipment(ServerLevel worldserver) {
        super.dropEquipment(worldserver);
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(worldserver, itemstack);
            }
        }
    }

    @Override
    public void aiStep() {
        if (this.random.nextInt(200) == 0) {
            this.moveTail();
        }
        super.aiStep();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.isAlive()) {
                if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.canEatGrass()) {
                    if (!this.isEating() && !this.isVehicle() && this.random.nextInt(300) == 0 && worldserver.getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                        this.setEating(true);
                    }
                    if (this.isEating() && ++this.eatingCounter > 50) {
                        this.eatingCounter = 0;
                        this.setEating(false);
                    }
                }
                this.followMommy(worldserver);
                return;
            }
        }
    }

    protected void followMommy(ServerLevel worldserver) {
        AbstractHorse entityliving;
        if (this.isBred() && this.isBaby() && !this.isEating() && (entityliving = worldserver.getNearestEntity(AbstractHorse.class, MOMMY_TARGETING, this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(16.0))) != null && this.distanceToSqr(entityliving) > 4.0) {
            this.navigation.createPath(entityliving, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
            this.setFlag(64, false);
        }
        if (this.standCounter > 0 && --this.standCounter <= 0) {
            this.clearStanding();
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.eatAnimO = this.eatAnim;
        if (this.isEating()) {
            this.eatAnim += (1.0f - this.eatAnim) * 0.4f + 0.05f;
            if (this.eatAnim > 1.0f) {
                this.eatAnim = 1.0f;
            }
        } else {
            this.eatAnim += (0.0f - this.eatAnim) * 0.4f - 0.05f;
            if (this.eatAnim < 0.0f) {
                this.eatAnim = 0.0f;
            }
        }
        this.standAnimO = this.standAnim;
        if (this.isStanding()) {
            this.eatAnimO = this.eatAnim = 0.0f;
            this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
            if (this.standAnim > 1.0f) {
                this.standAnim = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
            if (this.standAnim < 0.0f) {
                this.standAnim = 0.0f;
            }
        }
        this.mouthAnimO = this.mouthAnim;
        if (this.getFlag(64)) {
            this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
            if (this.mouthAnim > 1.0f) {
                this.mouthAnim = 1.0f;
            }
        } else {
            this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
            if (this.mouthAnim < 0.0f) {
                this.mouthAnim = 0.0f;
            }
        }
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        if (!this.isVehicle() && !this.isBaby()) {
            if (this.isTamed() && entityhuman.isSecondaryUseActive()) {
                this.openCustomInventoryScreen(entityhuman);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            if (!itemstack.isEmpty()) {
                InteractionResult enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand);
                if (enuminteractionresult.consumesAction()) {
                    return enuminteractionresult;
                }
                if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY) && !this.isWearingBodyArmor()) {
                    this.equipBodyArmor(entityhuman, itemstack);
                    return InteractionResult.SUCCESS;
                }
            }
            this.doPlayerRide(entityhuman);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(entityhuman, enumhand);
    }

    private void openMouth() {
        if (!this.level().isClientSide) {
            this.mouthCounter = 1;
            this.setFlag(64, true);
        }
    }

    public void setEating(boolean flag) {
        this.setFlag(16, flag);
    }

    public void setStanding(int i) {
        this.setEating(false);
        this.setFlag(32, true);
        this.standCounter = i;
    }

    public void clearStanding() {
        this.setFlag(32, false);
        this.standCounter = 0;
    }

    @Nullable
    public SoundEvent getAmbientStandSound() {
        return this.getAmbientSound();
    }

    public void standIfPossible() {
        if (this.canPerformRearing() && (this.isEffectiveAi() || !this.level().isClientSide)) {
            this.setStanding(20);
        }
    }

    public void makeMad() {
        if (!this.isStanding() && !this.level().isClientSide) {
            this.standIfPossible();
            this.makeSound(this.getAngrySound());
        }
    }

    public boolean tameWithName(Player entityhuman) {
        this.setOwner(entityhuman);
        this.setTamed(true);
        if (entityhuman instanceof ServerPlayer) {
            CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)entityhuman, this);
        }
        this.level().broadcastEntityEvent(this, (byte)7);
        return true;
    }

    @Override
    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
        super.tickRidden(entityhuman, vec3d);
        Vec2 vec2f = this.getRiddenRotation(entityhuman);
        this.setRot(vec2f.y, vec2f.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isLocalInstanceAuthoritative()) {
            if (vec3d.z <= 0.0) {
                this.gallopSoundCounter = 0;
            }
            if (this.onGround()) {
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                    this.executeRidersJump(this.playerJumpPendingScale, vec3d);
                }
                this.playerJumpPendingScale = 0.0f;
            }
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity entityliving) {
        return new Vec2(entityliving.getXRot() * 0.5f, entityliving.getYRot());
    }

    @Override
    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        if (this.onGround() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
            return Vec3.ZERO;
        }
        float f = entityhuman.xxa * 0.5f;
        float f1 = entityhuman.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3(f, 0.0, f1);
    }

    @Override
    protected float getRiddenSpeed(Player entityhuman) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    protected void executeRidersJump(float f, Vec3 vec3d) {
        double d0 = this.getJumpPower(f);
        Vec3 vec3d1 = this.getDeltaMovement();
        this.setDeltaMovement(vec3d1.x, d0, vec3d1.z);
        this.hasImpulse = true;
        if (vec3d.z > 0.0) {
            float f1 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float f2 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            this.setDeltaMovement(this.getDeltaMovement().add(-0.4f * f1 * f, 0.0, 0.4f * f2 * f));
        }
    }

    protected void playJumpSound() {
        this.playSound(SoundEvents.HORSE_JUMP, 0.4f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putBoolean("EatingHaystack", this.isEating());
        valueoutput.putBoolean("Bred", this.isBred());
        valueoutput.putInt("Temper", this.getTemper());
        valueoutput.putBoolean("Tame", this.isTamed());
        EntityReference.store(this.owner, valueoutput, "Owner");
        valueoutput.putInt("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.setEating(valueinput.getBooleanOr("EatingHaystack", false));
        this.setBred(valueinput.getBooleanOr("Bred", false));
        this.setTemper(valueinput.getIntOr("Temper", 0));
        this.setTamed(valueinput.getBooleanOr("Tame", false));
        this.owner = EntityReference.readWithOldOwnerConversion(valueinput, "Owner", this.level());
        this.maxDomestication = valueinput.getIntOr("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Override
    public boolean canMate(Animal entityanimal) {
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && this.isTamed() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        return null;
    }

    protected void setOffspringAttributes(AgeableMob entityageable, AbstractHorse entityhorseabstract) {
        this.setOffspringAttribute(entityageable, entityhorseabstract, Attributes.MAX_HEALTH, MIN_HEALTH, MAX_HEALTH);
        this.setOffspringAttribute(entityageable, entityhorseabstract, Attributes.JUMP_STRENGTH, MIN_JUMP_STRENGTH, MAX_JUMP_STRENGTH);
        this.setOffspringAttribute(entityageable, entityhorseabstract, Attributes.MOVEMENT_SPEED, MIN_MOVEMENT_SPEED, MAX_MOVEMENT_SPEED);
    }

    private void setOffspringAttribute(AgeableMob entityageable, AbstractHorse entityhorseabstract, Holder<Attribute> holder, double d0, double d1) {
        double d2 = AbstractHorse.createOffspringAttribute(this.getAttributeBaseValue(holder), entityageable.getAttributeBaseValue(holder), d0, d1, this.random);
        entityhorseabstract.getAttribute(holder).setBaseValue(d2);
    }

    static double createOffspringAttribute(double d0, double d1, double d2, double d3, RandomSource randomsource) {
        double d7;
        if (d3 <= d2) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        d0 = Mth.clamp(d0, d2, d3);
        d1 = Mth.clamp(d1, d2, d3);
        double d4 = 0.15 * (d3 - d2);
        double d6 = (d0 + d1) / 2.0;
        double d5 = Math.abs(d0 - d1) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (randomsource.nextDouble() + randomsource.nextDouble() + randomsource.nextDouble()) / 3.0 - 0.5);
        if (d8 > d3) {
            double d9 = d8 - d3;
            return d3 - d9;
        }
        if (d8 < d2) {
            double d10 = d2 - d8;
            return d2 + d10;
        }
        return d8;
    }

    public float getEatAnim(float f) {
        return Mth.lerp(f, this.eatAnimO, this.eatAnim);
    }

    public float getStandAnim(float f) {
        return Mth.lerp(f, this.standAnimO, this.standAnim);
    }

    public float getMouthAnim(float f) {
        return Mth.lerp(f, this.mouthAnimO, this.mouthAnim);
    }

    @Override
    public void onPlayerJump(int i) {
        if (this.isSaddled()) {
            if (i < 0) {
                i = 0;
            } else {
                this.allowStandSliding = true;
                this.standIfPossible();
            }
            this.playerJumpPendingScale = i >= 90 ? 1.0f : 0.4f + 0.4f * (float)i / 90.0f;
        }
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void handleStartJump(int i) {
        float power = i >= 90 ? 1.0f : 0.4f + 0.4f * (float)i / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.allowStandSliding = true;
        this.standIfPossible();
        this.playJumpSound();
    }

    @Override
    public void handleStopJump() {
    }

    protected void spawnTamingParticles(boolean flag) {
        SimpleParticleType particleparam = flag ? ParticleTypes.HEART : ParticleTypes.SMOKE;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleparam, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 7) {
            this.spawnTamingParticles(true);
        } else if (b0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    protected void positionRider(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.positionRider(entity, entity_movefunction);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).yBodyRot = this.yBodyRot;
        }
    }

    protected static float generateMaxHealth(IntUnaryOperator intunaryoperator) {
        return 15.0f + (float)intunaryoperator.applyAsInt(8) + (float)intunaryoperator.applyAsInt(9);
    }

    protected static double generateJumpStrength(DoubleSupplier doublesupplier) {
        return (double)0.4f + doublesupplier.getAsDouble() * 0.2 + doublesupplier.getAsDouble() * 0.2 + doublesupplier.getAsDouble() * 0.2;
    }

    protected static double generateSpeed(DoubleSupplier doublesupplier) {
        return ((double)0.45f + doublesupplier.getAsDouble() * 0.3 + doublesupplier.getAsDouble() * 0.3 + doublesupplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public SlotAccess getSlot(int i) {
        int j = i - 500;
        return j >= 0 && j < this.inventory.getContainerSize() ? SlotAccess.forContainer(this.inventory, j) : super.getSlot(i);
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player entityhuman = (Player)entity;
            return entityhuman;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 vec3d, LivingEntity entityliving) {
        double d0 = this.getX() + vec3d.x;
        double d1 = this.getBoundingBox().minY;
        double d2 = this.getZ() + vec3d.z;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        block0: for (Pose entitypose : entityliving.getDismountPoses()) {
            blockposition_mutableblockposition.set(d0, d1, d2);
            double d3 = this.getBoundingBox().maxY + 0.75;
            do {
                double d4 = this.level().getBlockFloorHeight(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.getY() + d4 > d3) continue block0;
                if (DismountHelper.isBlockFloorValid(d4)) {
                    AABB axisalignedbb = entityliving.getLocalBoundsForPose(entitypose);
                    Vec3 vec3d1 = new Vec3(d0, (double)blockposition_mutableblockposition.getY() + d4, d2);
                    if (DismountHelper.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d1))) {
                        entityliving.setPose(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.move(Direction.UP);
            } while (!((double)blockposition_mutableblockposition.getY() >= d3));
        }
        return null;
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity entityliving) {
        Vec3 vec3d = AbstractHorse.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), this.getYRot() + (entityliving.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f));
        Vec3 vec3d1 = this.getDismountLocationInDirection(vec3d, entityliving);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3 vec3d2 = AbstractHorse.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), this.getYRot() + (entityliving.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f));
        Vec3 vec3d3 = this.getDismountLocationInDirection(vec3d2, entityliving);
        return vec3d3 != null ? vec3d3 : this.position();
    }

    protected void randomizeAttributes(RandomSource randomsource) {
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        if (groupdataentity == null) {
            groupdataentity = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        this.randomizeAttributes(worldaccess.getRandom());
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public boolean hasInventoryChanged(Container iinventory) {
        return this.inventory != iinventory;
    }

    public int getAmbientStandInterval() {
        return this.getAmbientSoundInterval();
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entitysize, float f) {
        return super.getPassengerAttachmentPoint(entity, entitysize, f).add(new Vec3(0.0, 0.15 * (double)this.standAnimO * (double)f, -0.7 * (double)this.standAnimO * (double)f).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    public int getInventoryColumns() {
        return 0;
    }
}

