/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    private static final int DEFAULT_DEATH_TIME = 0;
    public final DragonFlightHistory flightHistory = new DragonFlightHistory();
    public final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime = 0;
    public float yRotA;
    @Nullable
    public EndCrystal nearestCrystal;
    @Nullable
    private EndDragonFight dragonFight;
    private BlockPos fightOrigin = BlockPos.ZERO;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    private final Explosion explosionSource;

    public EnderDragon(EntityType<? extends EnderDragon> entitytypes, Level world) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, world);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.phaseManager = new EnderDragonPhaseManager(this);
        this.explosionSource = new ServerExplosion(world.getMinecraftWorld(), this, null, null, new Vec3(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.BlockInteraction.DESTROY);
    }

    public void setDragonFight(EndDragonFight enderdragonbattle) {
        this.dragonFight = enderdragonbattle;
    }

    public void setFightOrigin(BlockPos blockposition) {
        this.fightOrigin = blockposition;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.CAMERA_DISTANCE, 16.0);
    }

    @Override
    public boolean isFlapping() {
        float f = Mth.cos(this.flapTime * ((float)Math.PI * 2));
        float f1 = Mth.cos(this.oFlapTime * ((float)Math.PI * 2));
        return f1 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    @Override
    public void aiStep() {
        ServerLevel worldserver;
        EndDragonFight enderdragonbattle;
        Level world;
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (world = this.level()) instanceof ServerLevel && (enderdragonbattle = (worldserver = (ServerLevel)world).getDragonFight()) != null && this.getUUID().equals(enderdragonbattle.getDragonUUID())) {
            this.dragonFight = enderdragonbattle;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec3d = this.getDeltaMovement();
            float f3 = 0.2f / ((float)vec3d.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f3 * 0.5f) : (this.flapTime += (f3 *= (float)Math.pow(2.0, vec3d.y))));
            this.setYRot(Mth.wrapDegrees(this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                this.flightHistory.record(this.getY(), this.getYRot());
                Level world1 = this.level();
                if (world1 instanceof ServerLevel) {
                    Vec3 vec3d1;
                    ServerLevel worldserver1 = (ServerLevel)world1;
                    DragonPhaseInstance idragoncontroller = this.phaseManager.getCurrentPhase();
                    idragoncontroller.doServerTick(worldserver1);
                    if (this.phaseManager.getCurrentPhase() != idragoncontroller) {
                        idragoncontroller = this.phaseManager.getCurrentPhase();
                        idragoncontroller.doServerTick(worldserver1);
                    }
                    if ((vec3d1 = idragoncontroller.getFlyTargetLocation()) != null && idragoncontroller.getPhase() != EnderDragonPhase.HOVERING) {
                        double d0 = vec3d1.x - this.getX();
                        double d1 = vec3d1.y - this.getY();
                        double d2 = vec3d1.z - this.getZ();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f4 = idragoncontroller.getFlySpeed();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = Mth.clamp(d1 / d4, (double)(-f4), (double)f4);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d1 * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees(this.getYRot()));
                        Vec3 vec3d2 = vec3d1.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vec3d3 = new Vec3(Mth.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -Mth.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                        float f5 = Math.max(((float)vec3d3.dot(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f6 = Mth.clamp(Mth.wrapDegrees(180.0f - (float)Mth.atan2(d0, d2) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f6 * idragoncontroller.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        float f7 = (float)(2.0 / (d3 + 1.0));
                        float f8 = 0.06f;
                        this.moveRelative(0.06f * (f5 * f7 + (1.0f - f7)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale(0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement());
                        }
                        Vec3 vec3d4 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec3d4.dot(vec3d3) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, 0.91f, d5));
                    }
                } else {
                    this.interpolation.interpolate();
                    this.phaseManager.getCurrentPhase().doClientTick();
                }
                if (!this.level().isClientSide()) {
                    this.applyEffectsFromBlocks();
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avec3d = new Vec3[this.subEntities.length];
                for (int i = 0; i < this.subEntities.length; ++i) {
                    avec3d[i] = new Vec3(this.subEntities[i].getX(), this.subEntities[i].getY(), this.subEntities[i].getZ());
                }
                float f9 = (float)(this.flightHistory.get(5).y() - this.flightHistory.get(10).y()) * 10.0f * ((float)Math.PI / 180);
                float f10 = Mth.cos(f9);
                float f11 = Mth.sin(f9);
                float f12 = this.getYRot() * ((float)Math.PI / 180);
                float f13 = Mth.sin(f12);
                float f14 = Mth.cos(f12);
                this.tickPart(this.body, f13 * 0.5f, 0.0, -f14 * 0.5f);
                this.tickPart(this.wing1, f14 * 4.5f, 2.0, f13 * 4.5f);
                this.tickPart(this.wing2, f14 * -4.5f, 2.0, f13 * -4.5f);
                Level world2 = this.level();
                if (world2 instanceof ServerLevel) {
                    ServerLevel worldserver2 = (ServerLevel)world2;
                    if (this.hurtTime == 0) {
                        this.knockBack(worldserver2, worldserver2.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.knockBack(worldserver2, worldserver2.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver2, worldserver2.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(worldserver2, worldserver2.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                }
                float f15 = Mth.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f16 = Mth.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f17 = this.getHeadYOffset();
                this.tickPart(this.head, f15 * 6.5f * f10, f17 + f11 * 6.5f, -f16 * 6.5f * f10);
                this.tickPart(this.neck, f15 * 5.5f * f10, f17 + f11 * 5.5f, -f16 * 5.5f * f10);
                DragonFlightHistory.Sample dragonflighthistory_a = this.flightHistory.get(5);
                for (int j = 0; j < 3; ++j) {
                    EnderDragonPart entitycomplexpart = null;
                    if (j == 0) {
                        entitycomplexpart = this.tail1;
                    }
                    if (j == 1) {
                        entitycomplexpart = this.tail2;
                    }
                    if (j == 2) {
                        entitycomplexpart = this.tail3;
                    }
                    DragonFlightHistory.Sample dragonflighthistory_a1 = this.flightHistory.get(12 + j * 2);
                    float f18 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(dragonflighthistory_a1.yRot() - dragonflighthistory_a.yRot()) * ((float)Math.PI / 180);
                    float f19 = Mth.sin(f18);
                    float f20 = Mth.cos(f18);
                    float f21 = 1.5f;
                    float f22 = (float)(j + 1) * 2.0f;
                    this.tickPart(entitycomplexpart, -(f13 * 1.5f + f19 * f22) * f10, dragonflighthistory_a1.y() - dragonflighthistory_a.y() - (double)((f22 + 1.5f) * f11) + 1.5, (f14 * 1.5f + f20 * f22) * f10);
                }
                Level world3 = this.level();
                if (world3 instanceof ServerLevel) {
                    ServerLevel worldserver3 = (ServerLevel)world3;
                    this.inWall = this.checkWalls(worldserver3, this.head.getBoundingBox()) | this.checkWalls(worldserver3, this.neck.getBoundingBox()) | this.checkWalls(worldserver3, this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                for (int k = 0; k < this.subEntities.length; ++k) {
                    this.subEntities[k].xo = avec3d[k].x;
                    this.subEntities[k].yo = avec3d[k].y;
                    this.subEntities[k].zo = avec3d[k].z;
                    this.subEntities[k].xOld = avec3d[k].x;
                    this.subEntities[k].yOld = avec3d[k].y;
                    this.subEntities[k].zOld = avec3d[k].z;
                }
            }
        }
    }

    private void tickPart(EnderDragonPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.setPos(this.getX() + d0, this.getY() + d1, this.getZ() + d2);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        DragonFlightHistory.Sample dragonflighthistory_a = this.flightHistory.get(5);
        DragonFlightHistory.Sample dragonflighthistory_a1 = this.flightHistory.get(0);
        return (float)(dragonflighthistory_a.y() - dragonflighthistory_a1.y());
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setHealth((float)((double)this.getHealth() + event.getAmount()));
                }
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EndCrystal> list = this.level().getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.distanceToSqr(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.nearestCrystal = entityendercrystal;
        }
    }

    private void knockBack(ServerLevel worldserver, List<Entity> list) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entityliving = (LivingEntity)entity;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || entityliving.getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurtServer(worldserver, damagesource, 5.0f);
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    private void hurt(ServerLevel worldserver, List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurtServer(worldserver, damagesource, 10.0f);
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    private float rotWrap(double d0) {
        return (float)Mth.wrapDegrees(d0);
    }

    private boolean checkWalls(ServerLevel worldserver, AABB axisalignedbb) {
        int i = Mth.floor(axisalignedbb.minX);
        int j = Mth.floor(axisalignedbb.minY);
        int k = Mth.floor(axisalignedbb.minZ);
        int l = Mth.floor(axisalignedbb.maxX);
        int i1 = Mth.floor(axisalignedbb.maxY);
        int j1 = Mth.floor(axisalignedbb.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockposition = new BlockPos(k1, l1, i2);
                    BlockState iblockdata = worldserver.getBlockState(blockposition);
                    if (iblockdata.isAir() || iblockdata.is(BlockTags.DRAGON_TRANSPARENT)) continue;
                    if (worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !iblockdata.is(BlockTags.DRAGON_IMMUNE)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(worldserver, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.getBlockInteraction());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.level().removeBlock(new BlockPos(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPos blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().getBlock();
                if (nmsBlock.dropFromExplosion(this.explosionSource)) {
                    BlockEntity tileentity = craftBlock.getNMS().hasBlockEntity() ? this.level().getBlockEntity(blockposition) : null;
                    LootParams.Builder loottableinfo_builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, ItemStack.EMPTY).withParameter(LootContextParams.EXPLOSION_RADIUS, Float.valueOf(1.0f / event.getYield())).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity);
                    craftBlock.getNMS().getDrops(loottableinfo_builder).forEach(itemstack -> Block.popResource(this.level(), blockposition, itemstack));
                    craftBlock.getNMS().spawnAfterBreak((ServerLevel)this.level(), blockposition, ItemStack.EMPTY, false);
                }
                nmsBlock.wasExploded((ServerLevel)this.level(), blockposition, this.explosionSource);
                this.level().removeBlock(blockposition, false);
            }
        }
        if (flag1) {
            BlockPos blockposition1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            worldserver.levelEvent(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean hurt(ServerLevel worldserver, EnderDragonPart entitycomplexpart, DamageSource damagesource, float f) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        f = this.phaseManager.getCurrentPhase().onHurt(damagesource, f);
        if (entitycomplexpart != this.head) {
            f = f / 4.0f + Math.min(f, 1.0f);
        }
        if (f < 0.01f) {
            return false;
        }
        if (damagesource.getEntity() instanceof Player || damagesource.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float f1 = this.getHealth();
            this.reallyHurt(worldserver, damagesource, f);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f1 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return this.hurt(worldserver, this.body, damagesource, f);
    }

    protected void reallyHurt(ServerLevel worldserver, DamageSource damagesource, float f) {
        super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    public void kill(ServerLevel worldserver) {
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    public int getExpReward(ServerLevel worldserver, Entity entity) {
        boolean flag = worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        int short0 = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void tickDeath() {
        Level world1;
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        int i = this.expToDrop;
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0) {
                ExperienceOrb.award(worldserver, this.position(), Mth.floor((float)i * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                for (ServerPlayer player : worldserver.getServer().getPlayerList().players) {
                    double deltaX = this.getX() - player.getX();
                    double deltaZ = this.getZ() - player.getZ();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (worldserver.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.dragonDeathSoundRadius * worldserver.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                        player.connection.send(new ClientboundLevelEventPacket(1028, new BlockPos((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.connection.send(new ClientboundLevelEventPacket(1028, new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()), 0, true));
                }
            }
        }
        Vec3 vec3d = new Vec3(0.0, 0.1f, 0.0);
        this.move(MoverType.SELF, vec3d);
        for (EnderDragonPart entitycomplexpart : this.subEntities) {
            entitycomplexpart.setOldPosAndRot();
            entitycomplexpart.setPos(entitycomplexpart.position().add(vec3d));
        }
        if (this.dragonDeathTime == 200 && (world1 = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver1 = (ServerLevel)world1;
            ExperienceOrb.award(worldserver1, this.position(), Mth.floor((float)i * 0.2f));
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int l;
                int k;
                int j = 5;
                if (i < 12) {
                    k = Mth.floor(60.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                    l = Mth.floor(60.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                } else if (i < 20) {
                    int i1 = i - 12;
                    k = Mth.floor(40.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l = Mth.floor(40.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j += 10;
                } else {
                    int j1 = i - 20;
                    k = Mth.floor(20.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                    l = Mth.floor(20.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                }
                int k1 = Math.max(73, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(k, 0, l)).getY() + j);
                this.nodes[i] = new Node(k, k1, l);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double d0, double d1, double d2) {
        float f = 10000.0f;
        int i = 0;
        Node pathpoint = new Node(Mth.floor(d0), Mth.floor(d1), Mth.floor(d2));
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].distanceToSqr(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int i, int j, @Nullable Node pathpoint) {
        for (int k = 0; k < 24; ++k) {
            Node pathpoint1 = this.nodes[k];
            pathpoint1.closed = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.h = 0.0f;
            pathpoint1.cameFrom = null;
            pathpoint1.heapIdx = -1;
        }
        Node pathpoint2 = this.nodes[i];
        Node pathpoint3 = this.nodes[j];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.h = pathpoint2.distanceTo(pathpoint3);
        this.openSet.clear();
        this.openSet.insert(pathpoint2);
        Node pathpoint4 = pathpoint2;
        int l = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            l = 12;
        }
        while (!this.openSet.isEmpty()) {
            Node pathpoint5 = this.openSet.pop();
            if (pathpoint5.equals(pathpoint3)) {
                if (pathpoint != null) {
                    pathpoint.cameFrom = pathpoint3;
                    pathpoint3 = pathpoint;
                }
                return this.reconstructPath(pathpoint2, pathpoint3);
            }
            if (pathpoint5.distanceTo(pathpoint3) < pathpoint4.distanceTo(pathpoint3)) {
                pathpoint4 = pathpoint5;
            }
            pathpoint5.closed = true;
            int i1 = 0;
            for (int j1 = 0; j1 < 24; ++j1) {
                if (this.nodes[j1] != pathpoint5) continue;
                i1 = j1;
                break;
            }
            for (int k1 = l; k1 < 24; ++k1) {
                if ((this.nodeAdjacency[i1] & 1 << k1) <= 0) continue;
                Node pathpoint6 = this.nodes[k1];
                if (pathpoint6.closed) continue;
                float f = pathpoint5.g + pathpoint5.distanceTo(pathpoint6);
                if (pathpoint6.inOpenSet() && !(f < pathpoint6.g)) continue;
                pathpoint6.cameFrom = pathpoint5;
                pathpoint6.g = f;
                pathpoint6.h = pathpoint6.distanceTo(pathpoint3);
                if (pathpoint6.inOpenSet()) {
                    this.openSet.changeCost(pathpoint6, pathpoint6.g + pathpoint6.h);
                    continue;
                }
                pathpoint6.f = pathpoint6.g + pathpoint6.h;
                this.openSet.insert(pathpoint6);
            }
        }
        if (pathpoint4 == pathpoint2) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)i, (Object)j);
        if (pathpoint != null) {
            pathpoint.cameFrom = pathpoint4;
            pathpoint4 = pathpoint;
        }
        return this.reconstructPath(pathpoint2, pathpoint4);
    }

    private Path reconstructPath(Node pathpoint, Node pathpoint1) {
        ArrayList list = Lists.newArrayList();
        Node pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.cameFrom != null) {
            pathpoint2 = pathpoint2.cameFrom;
            list.add(0, pathpoint2);
        }
        return new Path(list, new BlockPos(pathpoint1.x, pathpoint1.y, pathpoint1.z), true);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        valueoutput.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
        valueoutput.putInt("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        valueinput.getInt(DRAGON_PHASE_KEY).ifPresent(integer -> this.phaseManager.setPhase(EnderDragonPhase.getById(integer)));
        this.dragonDeathTime = valueinput.getIntOr(DRAGON_DEATH_TIME_KEY, 0);
        this.expToDrop = valueinput.getIntOr("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public Vec3 getHeadLookVector(float f) {
        Vec3 vec3d;
        DragonPhaseInstance idragoncontroller = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> dragoncontrollerphase = idragoncontroller.getPhase();
        if (dragoncontrollerphase != EnderDragonPhase.LANDING && dragoncontrollerphase != EnderDragonPhase.TAKEOFF) {
            if (idragoncontroller.isSitting()) {
                float f1 = this.getXRot();
                float f2 = 1.5f;
                this.setXRot(-45.0f);
                vec3d = this.getViewVector(f);
                this.setXRot(f1);
            } else {
                vec3d = this.getViewVector(f);
            }
        } else {
            BlockPos blockposition = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.fightOrigin));
            float f3 = Math.max((float)Math.sqrt(blockposition.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float f4 = 6.0f / f3;
            float f5 = this.getXRot();
            float f6 = 1.5f;
            this.setXRot(-f4 * 1.5f * 5.0f);
            vec3d = this.getViewVector(f);
            this.setXRot(f5);
        }
        return vec3d;
    }

    public void onCrystalDestroyed(ServerLevel worldserver, EndCrystal entityendercrystal, BlockPos blockposition, DamageSource damagesource) {
        Player entityhuman1;
        Entity entity = damagesource.getEntity();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : worldserver.getNearestPlayer(CRYSTAL_DESTROY_TARGETING, blockposition.getX(), blockposition.getY(), blockposition.getZ());
        if (entityendercrystal == this.nearestCrystal) {
            this.hurt(worldserver, this.head, this.damageSources().explosion(entityendercrystal, entityhuman), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_PHASE.equals(datawatcherobject) && this.level().isClientSide) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean canRide(Entity entity) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        EnderDragonPart[] aentitycomplexpart = this.getSubEntities();
        for (int i = 0; i < aentitycomplexpart.length; ++i) {
            aentitycomplexpart[i].setId(i + packetplayoutspawnentity.getId() + 1);
        }
    }

    @Override
    public boolean canAttack(LivingEntity entityliving) {
        return entityliving.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float f) {
        return 1.0f;
    }
}

