/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class ItemFrame
extends HangingEntity {
    public static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.INT);
    public static final int NUM_ROTATIONS = 8;
    private static final float DEPTH = 0.0625f;
    private static final float WIDTH = 0.75f;
    private static final float HEIGHT = 0.75f;
    private static final byte DEFAULT_ROTATION = 0;
    private static final float DEFAULT_DROP_CHANCE = 1.0f;
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final boolean DEFAULT_FIXED = false;
    public float dropChance = 1.0f;
    public boolean fixed = false;

    public ItemFrame(EntityType<? extends ItemFrame> entitytypes, Level world) {
        super((EntityType<? extends HangingEntity>)entitytypes, world);
        this.setInvisible(false);
    }

    public ItemFrame(Level world, BlockPos blockposition, Direction enumdirection) {
        this(EntityType.ITEM_FRAME, world, blockposition, enumdirection);
    }

    public ItemFrame(EntityType<? extends ItemFrame> entitytypes, Level world, BlockPos blockposition, Direction enumdirection) {
        super((EntityType<? extends HangingEntity>)entitytypes, world, blockposition);
        this.setDirection(enumdirection);
        this.setInvisible(false);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ITEM, ItemStack.EMPTY);
        datawatcher_a.define(DATA_ROTATION, 0);
    }

    @Override
    public void setDirection(Direction enumdirection) {
        Validate.notNull((Object)enumdirection);
        super.setDirectionRaw(enumdirection);
        if (enumdirection.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(enumdirection.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * enumdirection.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected final void recalculateBoundingBox() {
        super.recalculateBoundingBox();
        this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
    }

    @Override
    protected AABB calculateBoundingBox(BlockPos blockposition, Direction enumdirection) {
        return ItemFrame.calculateBoundingBoxStatic(blockposition, enumdirection);
    }

    public static AABB calculateBoundingBoxStatic(BlockPos blockposition, Direction enumdirection) {
        float f = 0.46875f;
        Vec3 vec3d = Vec3.atCenterOf(blockposition).relative(enumdirection, -0.46875);
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        double d0 = enumdirection_enumaxis == Direction.Axis.X ? 0.0625 : 0.75;
        double d1 = enumdirection_enumaxis == Direction.Axis.Y ? 0.0625 : 0.75;
        double d2 = enumdirection_enumaxis == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize(vec3d, d0, d1, d2);
    }

    @Override
    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision(this)) {
            return false;
        }
        BlockState iblockdata = this.level().getBlockState(this.pos.relative(this.getDirection().getOpposite()));
        return iblockdata.isSolid() || this.getDirection().getAxis().isHorizontal() && DiodeBlock.isDiode(iblockdata) ? this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty() : false;
    }

    @Override
    public void move(MoverType enummovetype, Vec3 vec3d) {
        if (!this.fixed) {
            super.move(enummovetype, vec3d);
        }
    }

    @Override
    public void push(double d0, double d1, double d2) {
        if (!this.fixed) {
            super.push(d0, d1, d2);
        }
    }

    @Override
    public void kill(ServerLevel worldserver) {
        this.removeFramedMap(this.getItem());
        super.kill(worldserver);
    }

    private boolean shouldDamageDropItem(DamageSource damagesource) {
        return !damagesource.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty();
    }

    private static boolean canHurtWhenFixed(DamageSource damagesource) {
        return damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || damagesource.isCreativePlayer();
    }

    @Override
    public boolean hurtClient(DamageSource damagesource) {
        return this.fixed && !ItemFrame.canHurtWhenFixed(damagesource) ? false : !this.isInvulnerableToBase(damagesource);
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (!this.fixed) {
            if (this.isInvulnerableToBase(damagesource)) {
                return false;
            }
            if (this.shouldDamageDropItem(damagesource)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f, false) || this.isRemoved()) {
                    return true;
                }
                this.dropItem(worldserver, damagesource.getEntity(), false);
                this.gameEvent(GameEvent.BLOCK_CHANGE, damagesource.getEntity());
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
                return true;
            }
            return super.hurtServer(worldserver, damagesource, f);
        }
        return ItemFrame.canHurtWhenFixed(damagesource) && super.hurtServer(worldserver, damagesource, f);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = 16.0;
        return d0 < (d1 *= 64.0 * ItemFrame.getViewScale()) * d1;
    }

    @Override
    public void dropItem(ServerLevel worldserver, @Nullable Entity entity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(worldserver, entity, true);
        this.gameEvent(GameEvent.BLOCK_CHANGE, entity);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.ITEM_FRAME_BREAK;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.ITEM_FRAME_PLACE;
    }

    private void dropItem(ServerLevel worldserver, @Nullable Entity entity, boolean flag) {
        if (!this.fixed) {
            ItemStack itemstack = this.getItem();
            this.setItem(ItemStack.EMPTY);
            if (!worldserver.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                if (entity == null) {
                    this.removeFramedMap(itemstack);
                }
            } else {
                Player entityhuman;
                if (entity instanceof Player && (entityhuman = (Player)entity).hasInfiniteMaterials()) {
                    this.removeFramedMap(itemstack);
                    return;
                }
                if (flag) {
                    this.spawnAtLocation(worldserver, this.getFrameItemStack());
                }
                if (!itemstack.isEmpty()) {
                    itemstack = itemstack.copy();
                    this.removeFramedMap(itemstack);
                    if (this.random.nextFloat() < this.dropChance) {
                        this.spawnAtLocation(worldserver, itemstack);
                    }
                }
            }
        }
    }

    private void removeFramedMap(ItemStack itemstack) {
        MapItemSavedData worldmap;
        MapId mapid = this.getFramedMapId(itemstack);
        if (mapid != null && (worldmap = MapItem.getSavedData(mapid, this.level())) != null) {
            worldmap.removedFromFrame(this.pos, this.getId());
        }
        itemstack.setEntityRepresentation(null);
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    @Nullable
    public MapId getFramedMapId(ItemStack itemstack) {
        return itemstack.get(DataComponents.MAP_ID);
    }

    public boolean hasFramedMap() {
        return this.getItem().has(DataComponents.MAP_ID);
    }

    public void setItem(ItemStack itemstack) {
        this.setItem(itemstack, true);
    }

    public void setItem(ItemStack itemstack, boolean flag) {
        this.setItem(itemstack, flag, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.isEmpty()) {
            itemstack = itemstack.copyWithCount(1);
        }
        this.onItemChanged(itemstack);
        this.getEntityData().set(DATA_ITEM, itemstack);
        if (!itemstack.isEmpty() && playSound) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (flag && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    @Override
    public SlotAccess getSlot(int i) {
        return i == 0 ? SlotAccess.of(this::getItem, this::setItem) : super.getSlot(i);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (datawatcherobject.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack itemstack) {
        if (!itemstack.isEmpty() && itemstack.getFrame() != this) {
            itemstack.setEntityRepresentation(this);
        }
        this.recalculateBoundingBox();
    }

    public int getRotation() {
        return this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int i) {
        this.setRotation(i, true);
    }

    private void setRotation(int i, boolean flag) {
        this.getEntityData().set(DATA_ROTATION, i % 8);
        if (flag && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        ItemStack itemstack = this.getItem();
        if (!itemstack.isEmpty()) {
            valueoutput.store("Item", ItemStack.CODEC, itemstack);
        }
        valueoutput.putByte("ItemRotation", (byte)this.getRotation());
        valueoutput.putFloat("ItemDropChance", this.dropChance);
        valueoutput.store("Facing", Direction.LEGACY_ID_CODEC, this.getDirection());
        valueoutput.putBoolean("Invisible", this.isInvisible());
        valueoutput.putBoolean("Fixed", this.fixed);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        ItemStack itemstack = valueinput.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        ItemStack itemstack1 = this.getItem();
        if (!itemstack1.isEmpty() && !ItemStack.matches(itemstack, itemstack1)) {
            this.removeFramedMap(itemstack1);
        }
        this.setItem(itemstack, false);
        this.setRotation(valueinput.getByteOr("ItemRotation", (byte)0), false);
        this.dropChance = valueinput.getFloatOr("ItemDropChance", 1.0f);
        this.setDirection(valueinput.read("Facing", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN));
        this.setInvisible(valueinput.getBooleanOr("Invisible", false));
        this.fixed = valueinput.getBooleanOr("Fixed", false);
    }

    @Override
    public InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        boolean flag1;
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        boolean flag = !this.getItem().isEmpty();
        boolean bl = flag1 = !itemstack.isEmpty();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (!entityhuman.level().isClientSide) {
            if (!flag) {
                if (flag1 && !this.isRemoved()) {
                    MapItemSavedData worldmap = MapItem.getSavedData(itemstack, this.level());
                    if (worldmap != null && worldmap.isTrackedCountOverLimit(256)) {
                        return InteractionResult.FAIL;
                    }
                    this.setItem(itemstack);
                    this.gameEvent(GameEvent.BLOCK_CHANGE, entityhuman);
                    itemstack.consume(1, entityhuman);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent(GameEvent.BLOCK_CHANGE, entityhuman);
            return InteractionResult.SUCCESS;
        }
        return (InteractionResult)((Object)(!flag && !flag1 ? InteractionResult.PASS : InteractionResult.SUCCESS));
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    public int getAnalogOutput() {
        return this.getItem().isEmpty() ? 0 : this.getRotation() % 8 + 1;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        return new ClientboundAddEntityPacket((Entity)this, this.getDirection().get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.setDirection(Direction.from3DDataValue(packetplayoutspawnentity.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? this.getFrameItemStack() : itemstack.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack(Items.ITEM_FRAME);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        Direction enumdirection = this.getDirection();
        int i = enumdirection.getAxis().isVertical() ? 90 * enumdirection.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees(180 + enumdirection.get2DDataValue() * 90 + this.getRotation() * 45 + i);
    }
}

