/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DismountOrSkipMounting;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.Mount;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.RememberIfHoglinWasKilled;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StartHuntingHoglin;
import net.minecraft.world.entity.monster.piglin.StopAdmiringIfItemTooFarAway;
import net.minecraft.world.entity.monster.piglin.StopAdmiringIfTiredOfTryingToReachItem;
import net.minecraft.world.entity.monster.piglin.StopHoldingItemIfNoLongerAdmiring;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.PiglinBarterEvent;

public class PiglinAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    public static final Item BARTERING_ITEM = Items.GOLD_INGOT;
    private static final int PLAYER_ANGER_RANGE = 16;
    private static final int ANGER_DURATION = 600;
    private static final int ADMIRE_DURATION = 119;
    private static final int MAX_DISTANCE_TO_WALK_TO_ITEM = 9;
    private static final int MAX_TIME_TO_WALK_TO_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_ADMIRE_WALKING_IF_CANT_REACH_ITEM = 200;
    private static final int CELEBRATION_TIME = 300;
    protected static final UniformInt TIME_BETWEEN_HUNTS = TimeUtil.rangeOfSeconds(30, 120);
    private static final int BABY_FLEE_DURATION_AFTER_GETTING_HIT = 100;
    private static final int HIT_BY_PLAYER_MEMORY_TIMEOUT = 400;
    private static final int MAX_WALK_DISTANCE_TO_START_RIDING = 8;
    private static final UniformInt RIDE_START_INTERVAL = TimeUtil.rangeOfSeconds(10, 40);
    private static final UniformInt RIDE_DURATION = TimeUtil.rangeOfSeconds(10, 30);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds(5, 20);
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final int EAT_COOLDOWN = 200;
    private static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    private static final int MAX_LOOK_DIST = 8;
    private static final int MAX_LOOK_DIST_FOR_PLAYER_HOLDING_LOVED_ITEM = 14;
    private static final int INTERACTION_RANGE = 8;
    private static final int MIN_DESIRED_DIST_FROM_TARGET_WHEN_HOLDING_CROSSBOW = 5;
    private static final float SPEED_WHEN_STRAFING_BACK_FROM_TARGET = 0.75f;
    private static final int DESIRED_DISTANCE_FROM_ZOMBIFIED = 6;
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeUtil.rangeOfSeconds(5, 7);
    private static final UniformInt BABY_AVOID_NEMESIS_DURATION = TimeUtil.rangeOfSeconds(5, 7);
    private static final float PROBABILITY_OF_CELEBRATION_DANCE = 0.1f;
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MOUNTING = 0.8f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_WANTED_ITEM = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_CELEBRATE_LOCATION = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_DANCING = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;

    protected static Brain<?> makeBrain(Piglin entitypiglin, Brain<Piglin> behaviorcontroller) {
        PiglinAi.initCoreActivity(behaviorcontroller);
        PiglinAi.initIdleActivity(behaviorcontroller);
        PiglinAi.initAdmireItemActivity(behaviorcontroller);
        PiglinAi.initFightActivity(entitypiglin, behaviorcontroller);
        PiglinAi.initCelebrateActivity(behaviorcontroller);
        PiglinAi.initRetreatActivity(behaviorcontroller);
        PiglinAi.initRideHoglinActivity(behaviorcontroller);
        behaviorcontroller.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        behaviorcontroller.setDefaultActivity(Activity.IDLE);
        behaviorcontroller.useDefaultActivity();
        return behaviorcontroller;
    }

    protected static void initMemories(Piglin entitypiglin, RandomSource randomsource) {
        int i = TIME_BETWEEN_HUNTS.sample(randomsource);
        entitypiglin.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, i);
    }

    private static void initCoreActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), InteractWithDoor.create(), PiglinAi.babyAvoidNemesis(), PiglinAi.avoidZombified(), StopHoldingItemIfNoLongerAdmiring.create(), StartAdmiringItemIfSeen.create(119), StartCelebratingIfTargetDead.create(300, PiglinAi::wantsToDance), StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 14.0f), StartAttacking.create((worldserver, entitypiglin) -> entitypiglin.isAdult(), PiglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(Piglin::canHunt, StartHuntingHoglin.create()), PiglinAi.avoidRepellent(), PiglinAi.babySometimesRideBabyHoglin(), PiglinAi.createIdleLookBehaviors(), PiglinAi.createIdleMovementBehaviors(), SetLookAndInteract.create(EntityType.PLAYER, 4)));
    }

    private static void initFightActivity(Piglin entitypiglin, Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(StopAttackingIfTargetInvalid.create((worldserver, entityliving) -> !PiglinAi.isNearestValidAttackTarget(worldserver, entitypiglin, entityliving)), BehaviorBuilder.triggerIf(PiglinAi::hasCrossbow, BackUpIfTooClose.create(5, 0.75f)), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f), MeleeAttack.create(20), new CrossbowAttack(), RememberIfHoglinWasKilled.create(), EraseMemoryIf.create(PiglinAi::isNearZombified, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCelebrateActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivityAndRemoveMemoryWhenStopped(Activity.CELEBRATE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(PiglinAi.avoidRepellent(), SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 14.0f), StartAttacking.create((worldserver, entitypiglin) -> entitypiglin.isAdult(), PiglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(entitypiglin -> !entitypiglin.isDancing(), GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 2, 1.0f)), BehaviorBuilder.triggerIf(Piglin::isDancing, GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 4, 0.6f)), new RunOne(ImmutableList.of((Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(RandomStroll.stroll(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.CELEBRATE_LOCATION);
    }

    private static void initAdmireItemActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(GoToWantedItem.create(PiglinAi::isNotHoldingLovedItemInOffHand, 1.0f, true, 9), StopAdmiringIfItemTooFarAway.create(9), StopAdmiringIfTiredOfTryingToReachItem.create(200, 200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static void initRetreatActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(SetWalkTargetAwayFrom.entity(MemoryModuleType.AVOID_TARGET, 1.0f, 12, true), PiglinAi.createIdleLookBehaviors(), PiglinAi.createIdleMovementBehaviors(), EraseMemoryIf.create(PiglinAi::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static void initRideHoglinActivity(Brain<Piglin> behaviorcontroller) {
        behaviorcontroller.addActivityAndRemoveMemoryWhenStopped(Activity.RIDE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(Mount.create(0.8f), SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 8.0f), BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(Entity::isPassenger), TriggerGate.triggerOneShuffled(ImmutableList.builder().addAll(PiglinAi.createLookBehaviors()).add((Object)Pair.of(BehaviorBuilder.triggerIf(entitypiglin -> true), (Object)1)).build())), DismountOrSkipMounting.create(8, PiglinAi::wantsToStopRiding)), MemoryModuleType.RIDE_TARGET);
    }

    private static ImmutableList<Pair<OneShot<LivingEntity>, Integer>> createLookBehaviors() {
        return ImmutableList.of((Object)Pair.of(SetEntityLookTarget.create(EntityType.PLAYER, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(8.0f), (Object)1));
    }

    private static RunOne<LivingEntity> createIdleLookBehaviors() {
        return new RunOne<LivingEntity>((List<Pair<BehaviorControl<LivingEntity>, Integer>>)ImmutableList.builder().addAll(PiglinAi.createLookBehaviors()).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }

    private static RunOne<Piglin> createIdleMovementBehaviors() {
        return new RunOne<Piglin>((List<Pair<BehaviorControl<Piglin>, Integer>>)ImmutableList.of((Object)Pair.of(RandomStroll.stroll(0.6f), (Object)2), (Object)Pair.of(InteractWith.of(EntityType.PIGLIN, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(BehaviorBuilder.triggerIf(PiglinAi::doesntSeeAnyPlayerHoldingLovedItem, SetWalkTargetFromLookTarget.create(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, false);
    }

    private static BehaviorControl<Piglin> babyAvoidNemesis() {
        return CopyMemoryWithExpiry.create(Piglin::isBaby, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.AVOID_TARGET, BABY_AVOID_NEMESIS_DURATION);
    }

    private static BehaviorControl<Piglin> avoidZombified() {
        return CopyMemoryWithExpiry.create(PiglinAi::isNearZombified, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.AVOID_TARGET, AVOID_ZOMBIFIED_DURATION);
    }

    protected static void updateActivity(Piglin entitypiglin) {
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        Activity activity = behaviorcontroller.getActiveNonCoreActivity().orElse(null);
        behaviorcontroller.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.RIDE, (Object)Activity.IDLE));
        Activity activity1 = behaviorcontroller.getActiveNonCoreActivity().orElse(null);
        if (activity != activity1) {
            Optional<SoundEvent> optional = PiglinAi.getSoundForCurrentActivity(entitypiglin);
            Objects.requireNonNull(entitypiglin);
            optional.ifPresent(entitypiglin::makeSound);
        }
        entitypiglin.setAggressive(behaviorcontroller.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.RIDE_TARGET) && PiglinAi.isBabyRidingBaby(entitypiglin)) {
            entitypiglin.stopRiding();
        }
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            behaviorcontroller.eraseMemory(MemoryModuleType.DANCING);
        }
        entitypiglin.setDancing(behaviorcontroller.hasMemoryValue(MemoryModuleType.DANCING));
    }

    private static boolean isBabyRidingBaby(Piglin entitypiglin) {
        if (!entitypiglin.isBaby()) {
            return false;
        }
        Entity entity = entitypiglin.getVehicle();
        return entity instanceof Piglin && ((Piglin)entity).isBaby() || entity instanceof Hoglin && ((Hoglin)entity).isBaby();
    }

    protected static void pickUpItem(ServerLevel worldserver, Piglin entitypiglin, ItemEntity entityitem) {
        ItemStack itemstack;
        PiglinAi.stopWalking(entitypiglin);
        if (entityitem.getItem().is(Items.GOLD_NUGGET) && !CraftEventFactory.callEntityPickupItemEvent(entitypiglin, entityitem, 0, false).isCancelled()) {
            entitypiglin.take(entityitem, entityitem.getItem().getCount());
            itemstack = entityitem.getItem();
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        } else if (!CraftEventFactory.callEntityPickupItemEvent(entitypiglin, entityitem, entityitem.getItem().getCount() - 1, false).isCancelled()) {
            entitypiglin.take(entityitem, 1);
            itemstack = PiglinAi.removeOneItemFromItemEntity(entityitem);
        } else {
            return;
        }
        if (PiglinAi.isLovedItem(itemstack, entitypiglin)) {
            entitypiglin.getBrain().eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
            PiglinAi.holdInOffhand(worldserver, entitypiglin, itemstack);
            PiglinAi.admireGoldItem(entitypiglin);
        } else if (PiglinAi.isFood(itemstack) && !PiglinAi.hasEatenRecently(entitypiglin)) {
            PiglinAi.eat(entitypiglin);
        } else {
            boolean flag;
            boolean bl = flag = !entitypiglin.equipItemIfPossible(worldserver, itemstack, entityitem).equals(ItemStack.EMPTY);
            if (!flag) {
                PiglinAi.putInInventory(entitypiglin, itemstack);
            }
        }
    }

    private static void holdInOffhand(ServerLevel worldserver, Piglin entitypiglin, ItemStack itemstack) {
        if (PiglinAi.isHoldingItemInOffHand(entitypiglin)) {
            entitypiglin.spawnAtLocation(worldserver, entitypiglin.getItemInHand(InteractionHand.OFF_HAND));
        }
        entitypiglin.holdInOffHand(itemstack);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity entityitem) {
        ItemStack itemstack = entityitem.getItem();
        ItemStack itemstack1 = itemstack.split(1);
        if (itemstack.isEmpty()) {
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            entityitem.setItem(itemstack);
        }
        return itemstack1;
    }

    protected static void stopHoldingOffHandItem(ServerLevel worldserver, Piglin entitypiglin, boolean flag) {
        ItemStack itemstack = entitypiglin.getItemInHand(InteractionHand.OFF_HAND);
        entitypiglin.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        if (entitypiglin.isAdult()) {
            boolean flag1 = PiglinAi.isBarterCurrency(itemstack, entitypiglin);
            if (flag && flag1) {
                PiglinBarterEvent event = CraftEventFactory.callPiglinBarterEvent(entitypiglin, PiglinAi.getBarterResponseItems(entitypiglin), itemstack);
                if (!event.isCancelled()) {
                    PiglinAi.throwItems(entitypiglin, event.getOutcome().stream().map(CraftItemStack::asNMSCopy).collect(Collectors.toList()));
                }
            } else if (!flag1) {
                boolean flag2;
                boolean bl = flag2 = !entitypiglin.equipItemIfPossible(worldserver, itemstack).isEmpty();
                if (!flag2) {
                    PiglinAi.putInInventory(entitypiglin, itemstack);
                }
            }
        } else {
            boolean flag3;
            boolean bl = flag3 = !entitypiglin.equipItemIfPossible(worldserver, itemstack).isEmpty();
            if (!flag3) {
                ItemStack itemstack1 = entitypiglin.getMainHandItem();
                if (PiglinAi.isLovedItem(itemstack1, entitypiglin)) {
                    PiglinAi.putInInventory(entitypiglin, itemstack1);
                } else {
                    PiglinAi.throwItems(entitypiglin, Collections.singletonList(itemstack1));
                }
                entitypiglin.holdInMainHand(itemstack);
            }
        }
    }

    protected static void cancelAdmiring(ServerLevel worldserver, Piglin entitypiglin) {
        if (PiglinAi.isAdmiringItem(entitypiglin) && !entitypiglin.getOffhandItem().isEmpty()) {
            entitypiglin.spawnAtLocation(worldserver, entitypiglin.getOffhandItem());
            entitypiglin.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
    }

    private static void putInInventory(Piglin entitypiglin, ItemStack itemstack) {
        ItemStack itemstack1 = entitypiglin.addToInventory(itemstack);
        PiglinAi.throwItemsTowardRandomPos(entitypiglin, Collections.singletonList(itemstack1));
    }

    private static void throwItems(Piglin entitypiglin, List<ItemStack> list) {
        Optional<Player> optional = entitypiglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (optional.isPresent()) {
            PiglinAi.throwItemsTowardPlayer(entitypiglin, optional.get(), list);
        } else {
            PiglinAi.throwItemsTowardRandomPos(entitypiglin, list);
        }
    }

    private static void throwItemsTowardRandomPos(Piglin entitypiglin, List<ItemStack> list) {
        PiglinAi.throwItemsTowardPos(entitypiglin, list, PiglinAi.getRandomNearbyPos(entitypiglin));
    }

    private static void throwItemsTowardPlayer(Piglin entitypiglin, Player entityhuman, List<ItemStack> list) {
        PiglinAi.throwItemsTowardPos(entitypiglin, list, entityhuman.position());
    }

    private static void throwItemsTowardPos(Piglin entitypiglin, List<ItemStack> list, Vec3 vec3d) {
        if (!list.isEmpty()) {
            entitypiglin.swing(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : list) {
                BehaviorUtils.throwItem(entitypiglin, itemstack, vec3d.add(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> getBarterResponseItems(Piglin entitypiglin) {
        LootTable loottable = entitypiglin.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(new LootParams.Builder((ServerLevel)entitypiglin.level()).withParameter(LootContextParams.THIS_ENTITY, entitypiglin).create(LootContextParamSets.PIGLIN_BARTER));
        return list;
    }

    private static boolean wantsToDance(LivingEntity entityliving, LivingEntity entityliving1) {
        return entityliving1.getType() != EntityType.HOGLIN ? false : RandomSource.create(entityliving.level().getGameTime()).nextFloat() < 0.1f;
    }

    protected static boolean wantsToPickup(Piglin entitypiglin, ItemStack itemstack) {
        if (entitypiglin.isBaby() && itemstack.is(ItemTags.IGNORED_BY_PIGLIN_BABIES)) {
            return false;
        }
        if (itemstack.is(ItemTags.PIGLIN_REPELLENTS)) {
            return false;
        }
        if (PiglinAi.isAdmiringDisabled(entitypiglin) && entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        if (PiglinAi.isBarterCurrency(itemstack, entitypiglin)) {
            return PiglinAi.isNotHoldingLovedItemInOffHand(entitypiglin);
        }
        boolean flag = entitypiglin.canAddToInventory(itemstack);
        return itemstack.is(Items.GOLD_NUGGET) ? flag : (PiglinAi.isFood(itemstack) ? !PiglinAi.hasEatenRecently(entitypiglin) && flag : (!PiglinAi.isLovedItem(itemstack) ? entitypiglin.canReplaceCurrentItem(itemstack) : PiglinAi.isNotHoldingLovedItemInOffHand(entitypiglin) && flag));
    }

    protected static boolean isLovedItem(ItemStack itemstack, Piglin piglin) {
        return PiglinAi.isLovedItem(itemstack) || piglin.interestItems.contains(itemstack.getItem()) || piglin.allowedBarterItems.contains(itemstack.getItem());
    }

    protected static boolean isLovedItem(ItemStack itemstack) {
        return itemstack.is(ItemTags.PIGLIN_LOVED);
    }

    private static boolean wantsToStopRiding(Piglin entitypiglin, Entity entity) {
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob entityinsentient = (Mob)entity;
        return !entityinsentient.isBaby() || !entityinsentient.isAlive() || PiglinAi.wasHurtRecently(entitypiglin) || PiglinAi.wasHurtRecently(entityinsentient) || entityinsentient instanceof Piglin && entityinsentient.getVehicle() == null;
    }

    private static boolean isNearestValidAttackTarget(ServerLevel worldserver, Piglin entitypiglin, LivingEntity entityliving) {
        return PiglinAi.findNearestValidAttackTarget(worldserver, entitypiglin).filter(entityliving1 -> entityliving1 == entityliving).isPresent();
    }

    private static boolean isNearZombified(Piglin entitypiglin) {
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        if (behaviorcontroller.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED)) {
            LivingEntity entityliving = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED).get();
            return entitypiglin.closerThan(entityliving, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel worldserver, Piglin entitypiglin) {
        Optional<Player> optional1;
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        if (PiglinAi.isNearZombified(entitypiglin)) {
            return Optional.empty();
        }
        Optional<LivingEntity> optional = BehaviorUtils.getLivingEntityFromUUIDMemory(entitypiglin, MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight(worldserver, entitypiglin, optional.get())) {
            return optional;
        }
        if (behaviorcontroller.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (optional1 = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return optional1;
        }
        Optional<Mob> optional2 = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Player> optional3 = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        return optional3.isPresent() && Sensor.isEntityAttackable(worldserver, entitypiglin, optional3.get()) ? optional3 : Optional.empty();
    }

    public static void angerNearbyPiglins(ServerLevel worldserver, Player entityhuman, boolean flag) {
        List<Piglin> list = entityhuman.level().getEntitiesOfClass(Piglin.class, entityhuman.getBoundingBox().inflate(16.0));
        list.stream().filter(PiglinAi::isIdle).filter(entitypiglin -> !flag || BehaviorUtils.canSee(entitypiglin, entityhuman)).forEach(entitypiglin -> {
            if (worldserver.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                PiglinAi.setAngerTargetToNearestTargetablePlayerIfFound(worldserver, entitypiglin, entityhuman);
            } else {
                PiglinAi.setAngerTarget(worldserver, entitypiglin, entityhuman);
            }
        });
    }

    public static InteractionResult mobInteract(ServerLevel worldserver, Piglin entitypiglin, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (PiglinAi.canAdmire(entitypiglin, itemstack)) {
            ItemStack itemstack1 = itemstack.consumeAndReturn(1, entityhuman);
            PiglinAi.holdInOffhand(worldserver, entitypiglin, itemstack1);
            PiglinAi.admireGoldItem(entitypiglin);
            PiglinAi.stopWalking(entitypiglin);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected static boolean canAdmire(Piglin entitypiglin, ItemStack itemstack) {
        return !PiglinAi.isAdmiringDisabled(entitypiglin) && !PiglinAi.isAdmiringItem(entitypiglin) && entitypiglin.isAdult() && PiglinAi.isBarterCurrency(itemstack, entitypiglin);
    }

    protected static void wasHurtBy(ServerLevel worldserver, Piglin entitypiglin, LivingEntity entityliving) {
        if (!(entityliving instanceof Piglin)) {
            if (PiglinAi.isHoldingItemInOffHand(entitypiglin)) {
                PiglinAi.stopHoldingOffHandItem(worldserver, entitypiglin, false);
            }
            Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
            behaviorcontroller.eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
            behaviorcontroller.eraseMemory(MemoryModuleType.DANCING);
            behaviorcontroller.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
            if (entityliving instanceof Player) {
                behaviorcontroller.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, true, 400L);
            }
            PiglinAi.getAvoidTarget(entitypiglin).ifPresent(entityliving1 -> {
                if (entityliving1.getType() != entityliving.getType()) {
                    behaviorcontroller.eraseMemory(MemoryModuleType.AVOID_TARGET);
                }
            });
            if (entitypiglin.isBaby()) {
                behaviorcontroller.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, entityliving, 100L);
                if (Sensor.isEntityAttackableIgnoringLineOfSight(worldserver, entitypiglin, entityliving)) {
                    PiglinAi.broadcastAngerTarget(worldserver, entitypiglin, entityliving);
                }
            } else if (entityliving.getType() == EntityType.HOGLIN && PiglinAi.hoglinsOutnumberPiglins(entitypiglin)) {
                PiglinAi.setAvoidTargetAndDontHuntForAWhile(entitypiglin, entityliving);
                PiglinAi.broadcastRetreat(entitypiglin, entityliving);
            } else {
                PiglinAi.maybeRetaliate(worldserver, entitypiglin, entityliving);
            }
        }
    }

    protected static void maybeRetaliate(ServerLevel worldserver, AbstractPiglin entitypiglinabstract, LivingEntity entityliving) {
        if (!entitypiglinabstract.getBrain().isActive(Activity.AVOID) && Sensor.isEntityAttackableIgnoringLineOfSight(worldserver, entitypiglinabstract, entityliving) && !BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(entitypiglinabstract, entityliving, 4.0)) {
            if (entityliving.getType() == EntityType.PLAYER && worldserver.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                PiglinAi.setAngerTargetToNearestTargetablePlayerIfFound(worldserver, entitypiglinabstract, entityliving);
                PiglinAi.broadcastUniversalAnger(worldserver, entitypiglinabstract);
            } else {
                PiglinAi.setAngerTarget(worldserver, entitypiglinabstract, entityliving);
                PiglinAi.broadcastAngerTarget(worldserver, entitypiglinabstract, entityliving);
            }
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Piglin entitypiglin) {
        return entitypiglin.getBrain().getActiveNonCoreActivity().map(activity -> PiglinAi.getSoundForActivity(entitypiglin, activity));
    }

    private static SoundEvent getSoundForActivity(Piglin entitypiglin, Activity activity) {
        return activity == Activity.FIGHT ? SoundEvents.PIGLIN_ANGRY : (entitypiglin.isConverting() ? SoundEvents.PIGLIN_RETREAT : (activity == Activity.AVOID && PiglinAi.isNearAvoidTarget(entitypiglin) ? SoundEvents.PIGLIN_RETREAT : (activity == Activity.ADMIRE_ITEM ? SoundEvents.PIGLIN_ADMIRING_ITEM : (activity == Activity.CELEBRATE ? SoundEvents.PIGLIN_CELEBRATE : (PiglinAi.seesPlayerHoldingLovedItem(entitypiglin) ? SoundEvents.PIGLIN_JEALOUS : (PiglinAi.isNearRepellent(entitypiglin) ? SoundEvents.PIGLIN_RETREAT : SoundEvents.PIGLIN_AMBIENT))))));
    }

    private static boolean isNearAvoidTarget(Piglin entitypiglin) {
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        return !behaviorcontroller.hasMemoryValue(MemoryModuleType.AVOID_TARGET) ? false : behaviorcontroller.getMemory(MemoryModuleType.AVOID_TARGET).get().closerThan(entitypiglin, 12.0);
    }

    protected static List<AbstractPiglin> getVisibleAdultPiglins(Piglin entitypiglin) {
        return entitypiglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse((List<AbstractPiglin>)ImmutableList.of());
    }

    private static List<AbstractPiglin> getAdultPiglins(AbstractPiglin entitypiglinabstract) {
        return entitypiglinabstract.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse((List<AbstractPiglin>)ImmutableList.of());
    }

    public static boolean isWearingSafeArmor(LivingEntity entityliving) {
        for (EquipmentSlot enumitemslot : EquipmentSlotGroup.ARMOR) {
            if (!entityliving.getItemBySlot(enumitemslot).is(ItemTags.PIGLIN_SAFE_ARMOR)) continue;
            return true;
        }
        return false;
    }

    private static void stopWalking(Piglin entitypiglin) {
        entitypiglin.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entitypiglin.getNavigation().stop();
    }

    private static BehaviorControl<LivingEntity> babySometimesRideBabyHoglin() {
        SetEntityLookTargetSometimes.Ticker setentitylooktargetsometimes_a = new SetEntityLookTargetSometimes.Ticker(RIDE_START_INTERVAL);
        return CopyMemoryWithExpiry.create(entityliving -> entityliving.isBaby() && setentitylooktargetsometimes_a.tickDownAndCheck(entityliving.level().random), MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.RIDE_TARGET, RIDE_DURATION);
    }

    protected static void broadcastAngerTarget(ServerLevel worldserver, AbstractPiglin entitypiglinabstract, LivingEntity entityliving) {
        PiglinAi.getAdultPiglins(entitypiglinabstract).forEach(entitypiglinabstract1 -> {
            if (entityliving.getType() != EntityType.HOGLIN || entitypiglinabstract1.canHunt() && ((Hoglin)entityliving).canBeHunted()) {
                PiglinAi.setAngerTargetIfCloserThanCurrent(worldserver, entitypiglinabstract1, entityliving);
            }
        });
    }

    protected static void broadcastUniversalAnger(ServerLevel worldserver, AbstractPiglin entitypiglinabstract) {
        PiglinAi.getAdultPiglins(entitypiglinabstract).forEach(entitypiglinabstract1 -> PiglinAi.getNearestVisibleTargetablePlayer(entitypiglinabstract1).ifPresent(entityhuman -> PiglinAi.setAngerTarget(worldserver, entitypiglinabstract1, entityhuman)));
    }

    protected static void setAngerTarget(ServerLevel worldserver, AbstractPiglin entitypiglinabstract, LivingEntity entityliving) {
        if (Sensor.isEntityAttackableIgnoringLineOfSight(worldserver, entitypiglinabstract, entityliving)) {
            entitypiglinabstract.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            entitypiglinabstract.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, entityliving.getUUID(), 600L);
            if (entityliving.getType() == EntityType.HOGLIN && entitypiglinabstract.canHunt()) {
                PiglinAi.dontKillAnyMoreHoglinsForAWhile(entitypiglinabstract);
            }
            if (entityliving.getType() == EntityType.PLAYER && worldserver.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                entitypiglinabstract.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, true, 600L);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(ServerLevel worldserver, AbstractPiglin entitypiglinabstract, LivingEntity entityliving) {
        Optional<Player> optional = PiglinAi.getNearestVisibleTargetablePlayer(entitypiglinabstract);
        if (optional.isPresent()) {
            PiglinAi.setAngerTarget(worldserver, entitypiglinabstract, optional.get());
        } else {
            PiglinAi.setAngerTarget(worldserver, entitypiglinabstract, entityliving);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(ServerLevel worldserver, AbstractPiglin entitypiglinabstract, LivingEntity entityliving) {
        Optional<LivingEntity> optional = PiglinAi.getAngerTarget(entitypiglinabstract);
        LivingEntity entityliving1 = BehaviorUtils.getNearestTarget(entitypiglinabstract, optional, entityliving);
        if (!optional.isPresent() || optional.get() != entityliving1) {
            PiglinAi.setAngerTarget(worldserver, entitypiglinabstract, entityliving1);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglin entitypiglinabstract) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory(entitypiglinabstract, MemoryModuleType.ANGRY_AT);
    }

    public static Optional<LivingEntity> getAvoidTarget(Piglin entitypiglin) {
        return entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET) ? entitypiglin.getBrain().getMemory(MemoryModuleType.AVOID_TARGET) : Optional.empty();
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(AbstractPiglin entitypiglinabstract) {
        return entitypiglinabstract.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) ? entitypiglinabstract.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) : Optional.empty();
    }

    private static void broadcastRetreat(Piglin entitypiglin, LivingEntity entityliving) {
        PiglinAi.getVisibleAdultPiglins(entitypiglin).stream().filter(entitypiglinabstract -> entitypiglinabstract instanceof Piglin).forEach(entitypiglinabstract -> PiglinAi.retreatFromNearestTarget((Piglin)entitypiglinabstract, entityliving));
    }

    private static void retreatFromNearestTarget(Piglin entitypiglin, LivingEntity entityliving) {
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        LivingEntity entityliving1 = BehaviorUtils.getNearestTarget(entitypiglin, behaviorcontroller.getMemory(MemoryModuleType.AVOID_TARGET), entityliving);
        entityliving1 = BehaviorUtils.getNearestTarget(entitypiglin, behaviorcontroller.getMemory(MemoryModuleType.ATTACK_TARGET), entityliving1);
        PiglinAi.setAvoidTargetAndDontHuntForAWhile(entitypiglin, entityliving1);
    }

    private static boolean wantsToStopFleeing(Piglin entitypiglin) {
        Brain<Piglin> behaviorcontroller = entitypiglin.getBrain();
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return true;
        }
        LivingEntity entityliving = behaviorcontroller.getMemory(MemoryModuleType.AVOID_TARGET).get();
        EntityType<?> entitytypes = entityliving.getType();
        return entitytypes == EntityType.HOGLIN ? PiglinAi.piglinsEqualOrOutnumberHoglins(entitypiglin) : (PiglinAi.isZombified(entitytypes) ? !behaviorcontroller.isMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, entityliving) : false);
    }

    private static boolean piglinsEqualOrOutnumberHoglins(Piglin entitypiglin) {
        return !PiglinAi.hoglinsOutnumberPiglins(entitypiglin);
    }

    private static boolean hoglinsOutnumberPiglins(Piglin entitypiglin) {
        int i = entitypiglin.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0) + 1;
        int j = entitypiglin.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0);
        return j > i;
    }

    private static void setAvoidTargetAndDontHuntForAWhile(Piglin entitypiglin, LivingEntity entityliving) {
        entitypiglin.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        entitypiglin.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        entitypiglin.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entitypiglin.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, entityliving, RETREAT_DURATION.sample(entitypiglin.level().random));
        PiglinAi.dontKillAnyMoreHoglinsForAWhile(entitypiglin);
    }

    protected static void dontKillAnyMoreHoglinsForAWhile(AbstractPiglin entitypiglinabstract) {
        entitypiglinabstract.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, TIME_BETWEEN_HUNTS.sample(entitypiglinabstract.level().random));
    }

    private static void eat(Piglin entitypiglin) {
        entitypiglin.getBrain().setMemoryWithExpiry(MemoryModuleType.ATE_RECENTLY, true, 200L);
    }

    private static Vec3 getRandomNearbyPos(Piglin entitypiglin) {
        Vec3 vec3d = LandRandomPos.getPos(entitypiglin, 4, 2);
        return vec3d == null ? entitypiglin.position() : vec3d;
    }

    private static boolean hasEatenRecently(Piglin entitypiglin) {
        return entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.ATE_RECENTLY);
    }

    protected static boolean isIdle(AbstractPiglin entitypiglinabstract) {
        return entitypiglinabstract.getBrain().isActive(Activity.IDLE);
    }

    private static boolean hasCrossbow(LivingEntity entityliving) {
        return entityliving.isHolding(Items.CROSSBOW);
    }

    private static void admireGoldItem(LivingEntity entityliving) {
        entityliving.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, true, 119L);
    }

    private static boolean isAdmiringItem(Piglin entitypiglin) {
        return entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }

    private static boolean isBarterCurrency(ItemStack itemstack, Piglin piglin) {
        return PiglinAi.isBarterCurrency(itemstack) || piglin.allowedBarterItems.contains(itemstack.getItem());
    }

    private static boolean isBarterCurrency(ItemStack itemstack) {
        return itemstack.is(BARTERING_ITEM);
    }

    private static boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.PIGLIN_FOOD);
    }

    private static boolean isNearRepellent(Piglin entitypiglin) {
        return entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity entityliving) {
        return entityliving.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity entityliving) {
        return !PiglinAi.seesPlayerHoldingLovedItem(entityliving);
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity entityliving) {
        return entityliving.getType() == EntityType.PLAYER && entityliving.isHolding(PiglinAi::isLovedItem);
    }

    private static boolean isAdmiringDisabled(Piglin entitypiglin) {
        return entitypiglin.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    private static boolean wasHurtRecently(LivingEntity entityliving) {
        return entityliving.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    private static boolean isHoldingItemInOffHand(Piglin entitypiglin) {
        return !entitypiglin.getOffhandItem().isEmpty();
    }

    private static boolean isNotHoldingLovedItemInOffHand(Piglin entitypiglin) {
        return entitypiglin.getOffhandItem().isEmpty() || !PiglinAi.isLovedItem(entitypiglin.getOffhandItem(), entitypiglin);
    }

    public static boolean isZombified(EntityType<?> entitytypes) {
        return entitytypes == EntityType.ZOMBIFIED_PIGLIN || entitytypes == EntityType.ZOGLIN;
    }
}

