/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WanderingTraderSpawner
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingTraderSpawner(ServerLevelData iworlddataserver) {
        this.serverLevelData = iworlddataserver;
        this.tickDelay = 1200;
        this.spawnDelay = iworlddataserver.getWanderingTraderSpawnDelay();
        this.spawnChance = iworlddataserver.getWanderingTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            iworlddataserver.setWanderingTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            iworlddataserver.setWanderingTraderSpawnChance(this.spawnChance);
        }
    }

    @Override
    public void tick(ServerLevel worldserver, boolean flag, boolean flag1) {
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING) && --this.tickDelay <= 0) {
            this.tickDelay = 1200;
            this.spawnDelay -= 1200;
            this.serverLevelData.setWanderingTraderSpawnDelay(this.spawnDelay);
            if (this.spawnDelay <= 0) {
                this.spawnDelay = 24000;
                if (worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
                    int i = this.spawnChance;
                    this.spawnChance = Mth.clamp(this.spawnChance + 25, 25, 75);
                    this.serverLevelData.setWanderingTraderSpawnChance(this.spawnChance);
                    if (this.random.nextInt(100) <= i && this.spawn(worldserver)) {
                        this.spawnChance = 25;
                    }
                }
            }
        }
    }

    private boolean spawn(ServerLevel worldserver) {
        ServerPlayer entityhuman = worldserver.getRandomPlayer();
        if (entityhuman == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPos blockposition = entityhuman.blockPosition();
        int i = 48;
        PoiManager villageplace = worldserver.getPoiManager();
        Optional<BlockPos> optional = villageplace.find(holder -> holder.is(PoiTypes.MEETING), blockposition1 -> true, blockposition, 48, PoiManager.Occupancy.ANY);
        BlockPos blockposition12 = optional.orElse(blockposition);
        BlockPos blockposition2 = this.findSpawnPositionNear(worldserver, blockposition12, 48);
        if (blockposition2 != null && this.hasEnoughSpace(worldserver, blockposition2)) {
            if (worldserver.getBiome(blockposition2).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            WanderingTrader entityvillagertrader = EntityType.WANDERING_TRADER.spawn(worldserver, blockposition2, EntitySpawnReason.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL);
            if (entityvillagertrader != null) {
                for (int j = 0; j < 2; ++j) {
                    this.tryToSpawnLlamaFor(worldserver, entityvillagertrader, 4);
                }
                this.serverLevelData.setWanderingTraderId(entityvillagertrader.getUUID());
                entityvillagertrader.setWanderTarget(blockposition12);
                entityvillagertrader.setHomeTo(blockposition12, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel worldserver, WanderingTrader entityvillagertrader, int i) {
        TraderLlama entityllamatrader;
        BlockPos blockposition = this.findSpawnPositionNear(worldserver, entityvillagertrader.blockPosition(), i);
        if (blockposition != null && (entityllamatrader = EntityType.TRADER_LLAMA.spawn(worldserver, blockposition, EntitySpawnReason.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL)) != null) {
            entityllamatrader.setLeashedTo(entityvillagertrader, true);
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader iworldreader, BlockPos blockposition, int i) {
        BlockPos blockposition1 = null;
        SpawnPlacementType spawnplacementtype = SpawnPlacements.getPlacementType(EntityType.WANDERING_TRADER);
        for (int j = 0; j < 10; ++j) {
            int l;
            int i1;
            int k = blockposition.getX() + this.random.nextInt(i * 2) - i;
            BlockPos blockposition2 = new BlockPos(k, i1 = iworldreader.getHeight(Heightmap.Types.WORLD_SURFACE, k, l = blockposition.getZ() + this.random.nextInt(i * 2) - i), l);
            if (!spawnplacementtype.isSpawnPositionOk(iworldreader, blockposition2, EntityType.WANDERING_TRADER)) continue;
            blockposition1 = blockposition2;
            break;
        }
        return blockposition1;
    }

    private boolean hasEnoughSpace(BlockGetter iblockaccess, BlockPos blockposition) {
        for (BlockPos blockposition1 : BlockPos.betweenClosed(blockposition, blockposition.offset(1, 2, 1))) {
            if (iblockaccess.getBlockState(blockposition1).getCollisionShape(iblockaccess, blockposition1).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

