/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PotionItem
extends Item {
    public PotionItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public ItemStack getDefaultInstance() {
        ItemStack var0 = super.getDefaultInstance();
        var0.set(DataComponents.POTION_CONTENTS, new PotionContents(Potions.WATER));
        return var0;
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        Player var3 = var0.getPlayer();
        ItemStack var4 = var0.getItemInHand();
        PotionContents var5 = var4.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        BlockState var6 = var1.getBlockState(var2);
        if (var0.getClickedFace() != Direction.DOWN && var6.is(BlockTags.CONVERTABLE_TO_MUD) && var5.is(Potions.WATER)) {
            var1.playSound(null, var2, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
            var3.setItemInHand(var0.getHand(), ItemUtils.createFilledResult(var4, var3, new ItemStack(Items.GLASS_BOTTLE)));
            var3.awardStat(Stats.ITEM_USED.get(var4.getItem()));
            if (!var1.isClientSide) {
                ServerLevel var7 = (ServerLevel)var1;
                for (int var8 = 0; var8 < 5; ++var8) {
                    var7.sendParticles(ParticleTypes.SPLASH, (double)var2.getX() + var1.random.nextDouble(), var2.getY() + 1, (double)var2.getZ() + var1.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            var1.playSound(null, var2, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            var1.gameEvent(null, GameEvent.FLUID_PLACE, var2);
            var1.setBlockAndUpdate(var2, Blocks.MUD.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Component getName(ItemStack var0) {
        PotionContents var1 = var0.get(DataComponents.POTION_CONTENTS);
        return var1 != null ? var1.getName(this.descriptionId + ".effect.") : super.getName(var0);
    }
}

