/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomData EMPTY = new CustomData(new CompoundTag());
    private static final String TYPE_TAG = "id";
    public static final Codec<CustomData> CODEC = Codec.withAlternative(CompoundTag.CODEC, TagParser.FLATTENED_CODEC).xmap(CustomData::new, var0 -> var0.tag);
    public static final Codec<CustomData> CODEC_WITH_ID = CODEC.validate(var0 -> var0.getUnsafe().getString(TYPE_TAG).isPresent() ? DataResult.success((Object)var0) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(var0)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, var0 -> var0.tag);
    private final CompoundTag tag;

    private CustomData(CompoundTag var0) {
        this.tag = var0;
    }

    public static CustomData of(CompoundTag var0) {
        return new CustomData(var0.copy());
    }

    public boolean matchedBy(CompoundTag var0) {
        return NbtUtils.compareNbt(var0, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> var0, ItemStack var1, Consumer<CompoundTag> var2) {
        CustomData var3 = var1.getOrDefault(var0, EMPTY).update(var2);
        if (var3.tag.isEmpty()) {
            var1.remove(var0);
        } else {
            var1.set(var0, var3);
        }
    }

    public static void set(DataComponentType<CustomData> var0, ItemStack var1, CompoundTag var2) {
        if (!var2.isEmpty()) {
            var1.set(var0, CustomData.of(var2));
        } else {
            var1.remove(var0);
        }
    }

    public CustomData update(Consumer<CompoundTag> var0) {
        CompoundTag var1 = this.tag.copy();
        var0.accept(var1);
        return new CustomData(var1);
    }

    @Nullable
    public ResourceLocation parseEntityId() {
        return this.tag.read(TYPE_TAG, ResourceLocation.CODEC).orElse(null);
    }

    @Nullable
    public <T> T parseEntityType(HolderLookup.Provider var0, ResourceKey<? extends Registry<T>> var1) {
        ResourceLocation var22 = this.parseEntityId();
        if (var22 == null) {
            return null;
        }
        return var0.lookup(var1).flatMap(var2 -> var2.get(ResourceKey.create(var1, var22))).map(Holder::value).orElse(null);
    }

    public void loadInto(Entity var0) {
        try (ProblemReporter.ScopedCollector var1 = new ProblemReporter.ScopedCollector(var0.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            CompoundTag var3 = var2.buildResult();
            UUID var4 = var0.getUUID();
            var3.merge(this.tag);
            var0.load(TagValueInput.create((ProblemReporter)var1, (HolderLookup.Provider)var0.registryAccess(), var3));
            var0.setUUID(var4);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean loadInto(BlockEntity var0, HolderLookup.Provider var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> DataResult<CustomData> update(DynamicOps<Tag> var02, MapEncoder<T> var1, T var2) {
        return var1.encode(var2, var02, var02.mapBuilder()).build((Object)this.tag).map(var0 -> new CustomData((CompoundTag)var0));
    }

    public <T> DataResult<T> read(MapDecoder<T> var0) {
        return this.read(NbtOps.INSTANCE, var0);
    }

    public <T> DataResult<T> read(DynamicOps<Tag> var0, MapDecoder<T> var1) {
        MapLike var2 = (MapLike)var0.getMap((Object)this.tag).getOrThrow();
        return var1.decode(var0, var2);
    }

    public int size() {
        return this.tag.size();
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public CompoundTag copyTag() {
        return this.tag.copy();
    }

    public boolean contains(String var0) {
        return this.tag.contains(var0);
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof CustomData) {
            CustomData var1 = (CustomData)var0;
            return this.tag.equals(var1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }

    private static /* synthetic */ String lambda$loadInto$5() {
        return "(rollback)";
    }
}

