/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerDuplicateRecipe
extends CustomRecipe {
    public BannerDuplicateRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (var0.ingredientCount() != 2) {
            return false;
        }
        DyeColor var2 = null;
        boolean var3 = false;
        boolean var4 = false;
        for (int var5 = 0; var5 < var0.size(); ++var5) {
            ItemStack var6 = var0.getItem(var5);
            if (var6.isEmpty()) continue;
            Item var7 = var6.getItem();
            if (var7 instanceof BannerItem) {
                BannerItem var8 = (BannerItem)var7;
                if (var2 == null) {
                    var2 = var8.getColor();
                } else if (var2 != var8.getColor()) {
                    return false;
                }
            } else {
                return false;
            }
            int var9 = var6.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size();
            if (var9 > 6) {
                return false;
            }
            if (var9 > 0) {
                if (var4) {
                    return false;
                }
                var4 = true;
                continue;
            }
            if (var3) {
                return false;
            }
            var3 = true;
        }
        return var4 && var3;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            int var4;
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty() || (var4 = var3.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size()) <= 0 || var4 > 6) continue;
            return var3.copyWithCount(1);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingInput var0) {
        NonNullList<ItemStack> var1 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty()) continue;
            ItemStack var4 = var3.getItem().getCraftingRemainder();
            if (!var4.isEmpty()) {
                var1.set(var2, var4);
                continue;
            }
            if (var3.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().isEmpty()) continue;
            var1.set(var2, var3.copyWithCount(1));
        }
        return var1;
    }

    @Override
    public RecipeSerializer<BannerDuplicateRecipe> getSerializer() {
        return RecipeSerializer.BANNER_DUPLICATE;
    }
}

