/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.trim.CraftTrimPattern;
import org.bukkit.inventory.Recipe;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final Holder<TrimPattern> pattern;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingTrimRecipe(Ingredient recipeitemstack, Ingredient recipeitemstack1, Ingredient recipeitemstack2, Holder<TrimPattern> holder) {
        this.template = recipeitemstack;
        this.base = recipeitemstack1;
        this.addition = recipeitemstack2;
        this.pattern = holder;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput smithingrecipeinput, HolderLookup.Provider holderlookup_a) {
        return SmithingTrimRecipe.applyTrim(holderlookup_a, smithingrecipeinput.base(), smithingrecipeinput.addition(), this.pattern);
    }

    public static ItemStack applyTrim(HolderLookup.Provider holderlookup_a, ItemStack itemstack, ItemStack itemstack1, Holder<TrimPattern> holder) {
        Optional<Holder<TrimMaterial>> optional = TrimMaterials.getFromIngredient(holderlookup_a, itemstack1);
        if (optional.isPresent()) {
            ArmorTrim armortrim1;
            ArmorTrim armortrim = itemstack.get(DataComponents.TRIM);
            if (Objects.equals(armortrim, armortrim1 = new ArmorTrim(optional.get(), holder))) {
                return ItemStack.EMPTY;
            }
            ItemStack itemstack2 = itemstack.copyWithCount(1);
            itemstack2.set(DataComponents.TRIM, armortrim1);
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<Ingredient> templateIngredient() {
        return Optional.of(this.template);
    }

    @Override
    public Ingredient baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<Ingredient> additionIngredient() {
        return Optional.of(this.addition);
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        SlotDisplay slotdisplay = this.base.display();
        SlotDisplay slotdisplay1 = this.addition.display();
        SlotDisplay slotdisplay2 = this.template.display();
        return List.of(new SmithingRecipeDisplay(slotdisplay2, slotdisplay, slotdisplay1, new SlotDisplay.SmithingTrimDemoSlotDisplay(slotdisplay, slotdisplay1, this.pattern), new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        return new CraftSmithingTrimRecipe(id, CraftRecipe.toBukkit(this.template), CraftRecipe.toBukkit(this.base), CraftRecipe.toBukkit(this.addition), CraftTrimPattern.minecraftHolderToBukkit(this.pattern));
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(smithingtrimrecipe -> smithingtrimrecipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(smithingtrimrecipe -> smithingtrimrecipe.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(smithingtrimrecipe -> smithingtrimrecipe.addition), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(smithingtrimrecipe -> smithingtrimrecipe.pattern)).apply((Applicative)instance, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.composite(Ingredient.CONTENTS_STREAM_CODEC, smithingtrimrecipe -> smithingtrimrecipe.template, Ingredient.CONTENTS_STREAM_CODEC, smithingtrimrecipe -> smithingtrimrecipe.base, Ingredient.CONTENTS_STREAM_CODEC, smithingtrimrecipe -> smithingtrimrecipe.addition, TrimPattern.STREAM_CODEC, smithingtrimrecipe -> smithingtrimrecipe.pattern, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

