/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;

public abstract class BaseCommandBlock
implements CommandSource {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final Component DEFAULT_NAME = Component.literal("@");
    private static final int NO_LAST_EXECUTION = -1;
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    private Component lastOutput;
    private String command = "";
    @Nullable
    private Component customName;

    @Override
    public abstract CommandSender getBukkitSender(CommandSourceStack var1);

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int i) {
        this.successCount = i;
    }

    public Component getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public void save(ValueOutput valueoutput) {
        valueoutput.putString("Command", this.command);
        valueoutput.putInt("SuccessCount", this.successCount);
        valueoutput.storeNullable("CustomName", ComponentSerialization.CODEC, this.customName);
        valueoutput.putBoolean("TrackOutput", this.trackOutput);
        if (this.trackOutput) {
            valueoutput.storeNullable("LastOutput", ComponentSerialization.CODEC, this.lastOutput);
        }
        valueoutput.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution != -1L) {
            valueoutput.putLong("LastExecution", this.lastExecution);
        }
    }

    public void load(ValueInput valueinput) {
        this.command = valueinput.getStringOr("Command", "");
        this.successCount = valueinput.getIntOr("SuccessCount", 0);
        this.setCustomName(BlockEntity.parseCustomNameSafe(valueinput, "CustomName"));
        this.trackOutput = valueinput.getBooleanOr("TrackOutput", true);
        this.lastOutput = this.trackOutput ? BlockEntity.parseCustomNameSafe(valueinput, "LastOutput") : null;
        this.updateLastExecution = valueinput.getBooleanOr("UpdateLastExecution", true);
        this.lastExecution = this.updateLastExecution ? valueinput.getLongOr("LastExecution", -1L) : -1L;
    }

    public void setCommand(String s) {
        this.command = s;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(Level world) {
        if (!world.isClientSide && world.getGameTime() != this.lastExecution) {
            if ("Searge".equalsIgnoreCase(this.command)) {
                this.lastOutput = Component.literal("#itzlipofutzli");
                this.successCount = 1;
                return true;
            }
            this.successCount = 0;
            MinecraftServer minecraftserver = this.getLevel().getServer();
            if (minecraftserver.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty(this.command)) {
                try {
                    this.lastOutput = null;
                    CommandSourceStack commandlistenerwrapper = this.createCommandSourceStack().withCallback((flag, i) -> {
                        if (flag) {
                            ++this.successCount;
                        }
                    });
                    minecraftserver.getCommands().dispatchServerCommand(commandlistenerwrapper, this.command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Executing command block");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Command to be executed");
                    crashreportsystemdetails.setDetail("Command", this::getCommand);
                    crashreportsystemdetails.setDetail("Name", () -> this.getName().getString());
                    throw new ReportedException(crashreport);
                }
            }
            this.lastExecution = this.updateLastExecution ? world.getGameTime() : -1L;
            return true;
        }
        return false;
    }

    public Component getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component ichatbasecomponent) {
        this.customName = ichatbasecomponent;
    }

    @Override
    public void sendSystemMessage(Component ichatbasecomponent) {
        if (this.trackOutput) {
            SimpleDateFormat simpledateformat = TIME_FORMAT;
            Date date = new Date();
            this.lastOutput = Component.literal("[" + simpledateformat.format(date) + "] ").append(ichatbasecomponent);
            this.onUpdated();
        }
    }

    public abstract ServerLevel getLevel();

    public abstract void onUpdated();

    public void setLastOutput(@Nullable Component ichatbasecomponent) {
        this.lastOutput = ichatbasecomponent;
    }

    public void setTrackOutput(boolean flag) {
        this.trackOutput = flag;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public InteractionResult usedBy(Player entityhuman) {
        if (!entityhuman.canUseGameMasterBlocks()) {
            return InteractionResult.PASS;
        }
        if (entityhuman.level().isClientSide) {
            entityhuman.openMinecartCommandBlock(this);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract Vec3 getPosition();

    public abstract CommandSourceStack createCommandSourceStack();

    @Override
    public boolean acceptsSuccess() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && this.trackOutput;
    }

    @Override
    public boolean acceptsFailure() {
        return this.trackOutput;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
    }

    public abstract boolean isValid();
}

