/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractCauldronBlock
extends Block {
    protected static final int FLOOR_LEVEL = 4;
    private static final VoxelShape SHAPE_INSIDE = Block.column(12.0, 4.0, 16.0);
    protected static final VoxelShape SHAPE = Util.make(() -> {
        int var0 = 4;
        int var1 = 3;
        int var2 = 2;
        return Shapes.join(Shapes.block(), Shapes.or(Block.column(16.0, 8.0, 0.0, 3.0), Block.column(8.0, 16.0, 0.0, 3.0), Block.column(12.0, 0.0, 3.0), SHAPE_INSIDE), BooleanOp.ONLY_FIRST);
    });
    protected final CauldronInteraction.InteractionMap interactions;

    protected abstract MapCodec<? extends AbstractCauldronBlock> codec();

    public AbstractCauldronBlock(BlockBehaviour.Properties var0, CauldronInteraction.InteractionMap var1) {
        super(var0);
        this.interactions = var1;
    }

    protected double getContentHeight(BlockState var0) {
        return 0.0;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        CauldronInteraction var7 = this.interactions.map().get(var0.getItem());
        return var7.interact(var1, var2, var3, var4, var5, var0);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getInteractionShape(BlockState var0, BlockGetter var1, BlockPos var2) {
        return SHAPE_INSIDE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    public abstract boolean isFull(BlockState var1);

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        BlockPos var4 = PointedDripstoneBlock.findStalactiteTipAboveCauldron(var1, var2);
        if (var4 == null) {
            return;
        }
        Fluid var5 = PointedDripstoneBlock.getCauldronFillFluidType(var1, var4);
        if (var5 != Fluids.EMPTY && this.canReceiveStalactiteDrip(var5)) {
            this.receiveStalactiteDrip(var0, var1, var2, var5);
        }
    }

    protected boolean canReceiveStalactiteDrip(Fluid var0) {
        return false;
    }

    protected void receiveStalactiteDrip(BlockState var0, Level var1, BlockPos var2, Fluid var3) {
    }
}

