/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class ComparatorBlock
extends DiodeBlock
implements EntityBlock {
    public static final MapCodec<ComparatorBlock> CODEC = ComparatorBlock.simpleCodec(ComparatorBlock::new);
    public static final EnumProperty<ComparatorMode> MODE = BlockStateProperties.MODE_COMPARATOR;

    public MapCodec<ComparatorBlock> codec() {
        return CODEC;
    }

    public ComparatorBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(MODE, ComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(BlockState iblockdata) {
        return 2;
    }

    @Override
    public BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection == Direction.DOWN && !this.canSurviveOn(iworldreader, blockposition1, iblockdata1) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected int getOutputSignal(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        BlockEntity tileentity = iblockaccess.getBlockEntity(blockposition);
        return tileentity instanceof ComparatorBlockEntity ? ((ComparatorBlockEntity)tileentity).getOutputSignal() : 0;
    }

    private int calculateOutputSignal(Level world, BlockPos blockposition, BlockState iblockdata) {
        int i = this.getInputSignal(world, blockposition, iblockdata);
        if (i == 0) {
            return 0;
        }
        int j = this.getAlternateSignal(world, blockposition, iblockdata);
        return j > i ? 0 : (iblockdata.getValue(MODE) == ComparatorMode.SUBTRACT ? i - j : i);
    }

    @Override
    protected boolean shouldTurnOn(Level world, BlockPos blockposition, BlockState iblockdata) {
        int i = this.getInputSignal(world, blockposition, iblockdata);
        if (i == 0) {
            return false;
        }
        int j = this.getAlternateSignal(world, blockposition, iblockdata);
        return i > j ? true : i == j && iblockdata.getValue(MODE) == ComparatorMode.COMPARE;
    }

    @Override
    protected int getInputSignal(Level world, BlockPos blockposition, BlockState iblockdata) {
        int i = super.getInputSignal(world, blockposition, iblockdata);
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        if (iblockdata1.hasAnalogOutputSignal()) {
            i = iblockdata1.getAnalogOutputSignal(world, blockposition1);
        } else if (i < 15 && iblockdata1.isRedstoneConductor(world, blockposition1)) {
            blockposition1 = blockposition1.relative(enumdirection);
            iblockdata1 = world.getBlockState(blockposition1);
            ItemFrame entityitemframe = this.getItemFrame(world, enumdirection, blockposition1);
            int j = Math.max(entityitemframe == null ? Integer.MIN_VALUE : entityitemframe.getAnalogOutput(), iblockdata1.hasAnalogOutputSignal() ? iblockdata1.getAnalogOutputSignal(world, blockposition1) : Integer.MIN_VALUE);
            if (j != Integer.MIN_VALUE) {
                i = j;
            }
        }
        return i;
    }

    @Nullable
    private ItemFrame getItemFrame(Level world, Direction enumdirection, BlockPos blockposition) {
        List<ItemFrame> list = world.getEntitiesOfClass(ItemFrame.class, new AABB(blockposition.getX(), blockposition.getY(), blockposition.getZ(), blockposition.getX() + 1, blockposition.getY() + 1, blockposition.getZ() + 1), entityitemframe -> entityitemframe != null && entityitemframe.getDirection() == enumdirection);
        return list.size() == 1 ? list.get(0) : null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (!entityhuman.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        float f = (iblockdata = (BlockState)iblockdata.cycle(MODE)).getValue(MODE) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        world.playSound((Entity)entityhuman, blockposition, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.3f, f);
        world.setBlock(blockposition, iblockdata, 2);
        this.refreshOutputState(world, blockposition, iblockdata);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void checkTickOnNeighbor(Level world, BlockPos blockposition, BlockState iblockdata) {
        if (!world.getBlockTicks().willTickThisTick(blockposition, this)) {
            int j;
            int i = this.calculateOutputSignal(world, blockposition, iblockdata);
            BlockEntity tileentity = world.getBlockEntity(blockposition);
            int n = j = tileentity instanceof ComparatorBlockEntity ? ((ComparatorBlockEntity)tileentity).getOutputSignal() : 0;
            if (i != j || iblockdata.getValue(POWERED).booleanValue() != this.shouldTurnOn(world, blockposition, iblockdata)) {
                TickPriority ticklistpriority = this.shouldPrioritize(world, blockposition, iblockdata) ? TickPriority.HIGH : TickPriority.NORMAL;
                world.scheduleTick(blockposition, this, 2, ticklistpriority);
            }
        }
    }

    private void refreshOutputState(Level world, BlockPos blockposition, BlockState iblockdata) {
        int i = this.calculateOutputSignal(world, blockposition, iblockdata);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        int j = 0;
        if (tileentity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity tileentitycomparator = (ComparatorBlockEntity)tileentity;
            j = tileentitycomparator.getOutputSignal();
            tileentitycomparator.setOutputSignal(i);
        }
        if (j != i || iblockdata.getValue(MODE) == ComparatorMode.COMPARE) {
            boolean flag = this.shouldTurnOn(world, blockposition, iblockdata);
            boolean flag1 = iblockdata.getValue(POWERED);
            if (flag1 && !flag) {
                if (CraftEventFactory.callRedstoneChange(world, blockposition, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, false), 2);
            } else if (!flag1 && flag) {
                if (CraftEventFactory.callRedstoneChange(world, blockposition, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, true), 2);
            }
            this.updateNeighborsInFront(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        this.refreshOutputState(worldserver, blockposition, iblockdata);
    }

    @Override
    protected boolean triggerEvent(BlockState iblockdata, Level world, BlockPos blockposition, int i, int j) {
        super.triggerEvent(iblockdata, world, blockposition, i, j);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        return tileentity != null && tileentity.triggerEvent(i, j);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new ComparatorBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, MODE, POWERED);
    }
}

