/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FallingBlock
extends Block
implements Fallable {
    public FallingBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends FallingBlock> codec();

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        var1.scheduleTick(var2, this, this.getDelayAfterPlace());
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        var2.scheduleTick(var3, this, this.getDelayAfterPlace());
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!FallingBlock.isFree(var1.getBlockState(var2.below())) || var2.getY() < var1.getMinY()) {
            return;
        }
        FallingBlockEntity var4 = FallingBlockEntity.fall(var1, var2, var0);
        this.falling(var4);
    }

    protected void falling(FallingBlockEntity var0) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(BlockState var0) {
        return var0.isAir() || var0.is(BlockTags.FIRE) || var0.liquid() || var0.canBeReplaced();
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        BlockPos var4;
        if (var3.nextInt(16) == 0 && FallingBlock.isFree(var1.getBlockState(var4 = var2.below()))) {
            ParticleUtils.spawnParticleBelow(var1, var2, var3, new BlockParticleOption(ParticleTypes.FALLING_DUST, var0));
        }
    }

    public abstract int getDustColor(BlockState var1, BlockGetter var2, BlockPos var3);
}

