/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class FarmBlock
extends Block {
    public static final MapCodec<FarmBlock> CODEC = FarmBlock.simpleCodec(FarmBlock::new);
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 15.0);
    public static final int MAX_MOISTURE = 7;

    public MapCodec<FarmBlock> codec() {
        return CODEC;
    }

    protected FarmBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(MOISTURE, 0));
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection == Direction.UP && !iblockdata.canSurvive(iworldreader, blockposition)) {
            scheduledtickaccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.above());
        return !iblockdata1.isSolid() || iblockdata1.getBlock() instanceof FenceGateBlock || iblockdata1.getBlock() instanceof MovingPistonBlock;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return !this.defaultBlockState().canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos()) ? Blocks.DIRT.defaultBlockState() : super.getStateForPlacement(blockactioncontext);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState iblockdata) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            FarmBlock.turnToDirt(null, iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        int i = iblockdata.getValue(MOISTURE);
        if (!FarmBlock.isNearWater(worldserver, blockposition) && !worldserver.isRainingAt(blockposition.above())) {
            if (i > 0) {
                CraftEventFactory.handleMoistureChangeEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(MOISTURE, i - 1), 2);
            } else if (!FarmBlock.shouldMaintainFarmland(worldserver, blockposition)) {
                FarmBlock.turnToDirt(null, iblockdata, worldserver, blockposition);
            }
        } else if (i < 7) {
            CraftEventFactory.handleMoistureChangeEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(MOISTURE, 7), 2);
        }
    }

    @Override
    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, net.minecraft.world.entity.Entity entity, double d0) {
        super.fallOn(world, iblockdata, blockposition, entity, d0);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if ((double)world.random.nextFloat() < d0 - 0.5 && entity instanceof LivingEntity && (entity instanceof Player || worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && entity.getBbWidth() * entity.getBbWidth() * entity.getBbHeight() > 0.512f) {
                PlayerInteractEvent cancellable;
                if (entity instanceof Player) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                    world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) {
                    return;
                }
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.DIRT.defaultBlockState())) {
                    return;
                }
                FarmBlock.turnToDirt(entity, iblockdata, world, blockposition);
            }
        }
    }

    public static void turnToDirt(@Nullable net.minecraft.world.entity.Entity entity, BlockState iblockdata, Level world, BlockPos blockposition) {
        if (CraftEventFactory.callBlockFadeEvent(world, blockposition, Blocks.DIRT.defaultBlockState()).isCancelled()) {
            return;
        }
        BlockState iblockdata1 = FarmBlock.pushEntitiesUp(iblockdata, Blocks.DIRT.defaultBlockState(), world, blockposition);
        world.setBlockAndUpdate(blockposition, iblockdata1);
        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, iblockdata1));
    }

    private static boolean shouldMaintainFarmland(BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockaccess.getBlockState(blockposition.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(LevelReader iworldreader, BlockPos blockposition) {
        for (BlockPos blockposition1 : BlockPos.betweenClosed(blockposition.offset(-4, 0, -4), blockposition.offset(4, 1, 4))) {
            if (!iworldreader.getFluidState(blockposition1).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(MOISTURE);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }
}

