/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronBarsBlock
extends CrossCollisionBlock {
    public static final MapCodec<IronBarsBlock> CODEC = IronBarsBlock.simpleCodec(IronBarsBlock::new);

    public MapCodec<? extends IronBarsBlock> codec() {
        return CODEC;
    }

    protected IronBarsBlock(BlockBehaviour.Properties var0) {
        super(2.0f, 16.0f, 2.0f, 16.0f, 16.0f, var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(WATERLOGGED, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        FluidState var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPos var4 = var2.north();
        BlockPos var5 = var2.south();
        BlockPos var6 = var2.west();
        BlockPos var7 = var2.east();
        BlockState var8 = var1.getBlockState(var4);
        BlockState var9 = var1.getBlockState(var5);
        BlockState var10 = var1.getBlockState(var6);
        BlockState var11 = var1.getBlockState(var7);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, this.attachsTo(var8, var8.isFaceSturdy(var1, var4, Direction.SOUTH)))).setValue(SOUTH, this.attachsTo(var9, var9.isFaceSturdy(var1, var5, Direction.NORTH)))).setValue(WEST, this.attachsTo(var10, var10.isFaceSturdy(var1, var6, Direction.EAST)))).setValue(EAST, this.attachsTo(var11, var11.isFaceSturdy(var1, var7, Direction.WEST)))).setValue(WATERLOGGED, var3.getType() == Fluids.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        if (var4.getAxis().isHorizontal()) {
            return (BlockState)var0.setValue((Property)PROPERTY_BY_DIRECTION.get(var4), this.attachsTo(var6, var6.isFaceSturdy(var1, var5, var4.getOpposite())));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getVisualShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return Shapes.empty();
    }

    @Override
    protected boolean skipRendering(BlockState var0, BlockState var1, Direction var2) {
        if (var1.is(this)) {
            if (!var2.getAxis().isHorizontal()) {
                return true;
            }
            if (((Boolean)var0.getValue((Property)PROPERTY_BY_DIRECTION.get(var2))).booleanValue() && ((Boolean)var1.getValue((Property)PROPERTY_BY_DIRECTION.get(var2.getOpposite()))).booleanValue()) {
                return true;
            }
        }
        return super.skipRendering(var0, var1, var2);
    }

    public final boolean attachsTo(BlockState var0, boolean var1) {
        return !IronBarsBlock.isExceptionForConnection(var0) && var1 || var0.getBlock() instanceof IronBarsBlock || var0.is(BlockTags.WALLS);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }
}

