/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;

public class JigsawBlock
extends Block
implements EntityBlock,
GameMasterBlock {
    public static final MapCodec<JigsawBlock> CODEC = JigsawBlock.simpleCodec(JigsawBlock::new);
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;

    public MapCodec<JigsawBlock> codec() {
        return CODEC;
    }

    protected JigsawBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, FrontAndTop.NORTH_UP));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(ORIENTATION);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return (BlockState)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Direction var1 = var0.getClickedFace();
        Direction var2 = var1.getAxis() == Direction.Axis.Y ? var0.getHorizontalDirection().getOpposite() : Direction.UP;
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, FrontAndTop.fromFrontAndTop(var1, var2));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new JigsawBlockEntity(var0, var1);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof JigsawBlockEntity && var3.canUseGameMasterBlocks()) {
            var3.openJigsawBlock((JigsawBlockEntity)var5);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAttach(StructureTemplate.JigsawBlockInfo var0, StructureTemplate.JigsawBlockInfo var1) {
        Direction var2 = JigsawBlock.getFrontFacing(var0.info().state());
        Direction var3 = JigsawBlock.getFrontFacing(var1.info().state());
        Direction var4 = JigsawBlock.getTopFacing(var0.info().state());
        Direction var5 = JigsawBlock.getTopFacing(var1.info().state());
        JigsawBlockEntity.JointType var6 = var0.jointType();
        boolean var7 = var6 == JigsawBlockEntity.JointType.ROLLABLE;
        return var2 == var3.getOpposite() && (var7 || var4 == var5) && var0.target().equals(var1.name());
    }

    public static Direction getFrontFacing(BlockState var0) {
        return var0.getValue(ORIENTATION).front();
    }

    public static Direction getTopFacing(BlockState var0) {
        return var0.getValue(ORIENTATION).top();
    }
}

