/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.Precipitation.CODEC.fieldOf("precipitation").forGetter(layeredcauldronblock -> layeredcauldronblock.precipitationType), (App)CauldronInteraction.CODEC.fieldOf("interactions").forGetter(layeredcauldronblock -> layeredcauldronblock.interactions), LayeredCauldronBlock.propertiesCodec()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 3;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_CAULDRON;
    private static final int BASE_CONTENT_HEIGHT = 6;
    private static final double HEIGHT_PER_LEVEL = 3.0;
    private static final VoxelShape[] FILLED_SHAPES = Util.make(() -> Block.boxes(2, i -> Shapes.or(AbstractCauldronBlock.SHAPE, Block.column(12.0, 4.0, LayeredCauldronBlock.getPixelContentHeight(i + 1)))));
    private final Biome.Precipitation precipitationType;

    public MapCodec<LayeredCauldronBlock> codec() {
        return CODEC;
    }

    public LayeredCauldronBlock(Biome.Precipitation biomebase_precipitation, CauldronInteraction.InteractionMap cauldroninteraction_a, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info, cauldroninteraction_a);
        this.precipitationType = biomebase_precipitation;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LEVEL, 1));
    }

    @Override
    public boolean isFull(BlockState iblockdata) {
        return iblockdata.getValue(LEVEL) == 3;
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid fluidtype) {
        return fluidtype == Fluids.WATER && this.precipitationType == Biome.Precipitation.RAIN;
    }

    @Override
    protected double getContentHeight(BlockState iblockdata) {
        return LayeredCauldronBlock.getPixelContentHeight(iblockdata.getValue(LEVEL)) / 16.0;
    }

    private static double getPixelContentHeight(int i) {
        return 6.0 + (double)i * 3.0;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        return FILLED_SHAPES[iblockdata.getValue(LEVEL) - 1];
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition1 = blockposition.immutable();
            insideblockeffectapplier.runBefore(InsideBlockEffectType.EXTINGUISH, entity1 -> {
                if (entity1.isOnFire() && entity1.mayInteract(worldserver, blockposition1) && this.handleEntityOnFireInside(iblockdata, world, blockposition1, entity)) {
                    insideblockeffectapplier.apply(InsideBlockEffectType.EXTINGUISH);
                }
            });
        }
    }

    private boolean handleEntityOnFireInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        if (this.precipitationType == Biome.Precipitation.SNOW) {
            return LayeredCauldronBlock.lowerFillLevel((BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue(LEVEL, iblockdata.getValue(LEVEL)), world, blockposition, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
        }
        return LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
    }

    public static void lowerFillLevel(BlockState iblockdata, Level world, BlockPos blockposition) {
        LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i = iblockdata.getValue(LEVEL) - 1;
        BlockState iblockdata1 = i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)iblockdata.setValue(LEVEL, i);
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, entity, reason);
    }

    public static boolean changeLevel(BlockState iblockdata, Level world, BlockPos blockposition, BlockState newBlock, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        CraftBlockState newState = CraftBlockStates.getBlockState(world, blockposition);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (org.bukkit.block.BlockState)newState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        newState.update(true);
        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(newBlock));
        return true;
    }

    @Override
    public void handlePrecipitation(BlockState iblockdata, Level world, BlockPos blockposition, Biome.Precipitation biomebase_precipitation) {
        if (CauldronBlock.shouldHandlePrecipitation(world, biomebase_precipitation) && iblockdata.getValue(LEVEL) != 3 && biomebase_precipitation == this.precipitationType) {
            BlockState iblockdata1 = (BlockState)iblockdata.cycle(LEVEL);
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition) {
        return iblockdata.getValue(LEVEL);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(LEVEL);
    }

    @Override
    protected void receiveStalactiteDrip(BlockState iblockdata, Level world, BlockPos blockposition, Fluid fluidtype) {
        if (!this.isFull(iblockdata)) {
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(LEVEL, iblockdata.getValue(LEVEL) + 1);
            if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            world.levelEvent(1047, blockposition, 0);
        }
    }
}

