/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.Event;
import org.bukkit.event.block.LeavesDecayEvent;

public abstract class LeavesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int DECAY_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final float leafParticleChance;
    private static final int TICK_DELAY = 1;

    public abstract MapCodec<? extends LeavesBlock> codec();

    public LeavesBlock(float f, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.leafParticleChance = f;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(PERSISTENT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return Shapes.empty();
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(DISTANCE) == 7 && iblockdata.getValue(PERSISTENT) == false;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (this.decaying(iblockdata)) {
            LeavesDecayEvent event = new LeavesDecayEvent(worldserver.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || worldserver.getBlockState(blockposition).getBlock() != this) {
                return;
            }
            LeavesBlock.dropResources(iblockdata, worldserver, blockposition);
            worldserver.removeBlock(blockposition, false);
        }
    }

    protected boolean decaying(BlockState iblockdata) {
        return iblockdata.getValue(PERSISTENT) == false && iblockdata.getValue(DISTANCE) == 7;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        worldserver.setBlock(blockposition, LeavesBlock.updateDistance(iblockdata, worldserver, blockposition), 3);
    }

    @Override
    protected int getLightBlock(BlockState iblockdata) {
        return 1;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        int i;
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        if ((i = LeavesBlock.getDistanceAt(iblockdata1) + 1) != 1 || iblockdata.getValue(DISTANCE) != i) {
            scheduledtickaccess.scheduleTick(blockposition, this, 1);
        }
        return iblockdata;
    }

    private static BlockState updateDistance(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition) {
        int i = 7;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.values()) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
            i = Math.min(i, LeavesBlock.getDistanceAt(generatoraccess.getBlockState(blockposition_mutableblockposition)) + 1);
            if (i == 1) break;
        }
        return (BlockState)iblockdata.setValue(DISTANCE, i);
    }

    private static int getDistanceAt(BlockState iblockdata) {
        return LeavesBlock.getOptionalDistanceAt(iblockdata).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState iblockdata) {
        return iblockdata.is(BlockTags.LOGS) ? OptionalInt.of(0) : (iblockdata.hasProperty(DISTANCE) ? OptionalInt.of(iblockdata.getValue(DISTANCE)) : OptionalInt.empty());
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        super.animateTick(iblockdata, world, blockposition, randomsource);
        BlockPos blockposition1 = blockposition.below();
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        LeavesBlock.makeDrippingWaterParticles(world, blockposition, randomsource, iblockdata1, blockposition1);
        this.makeFallingLeavesParticles(world, blockposition, randomsource, iblockdata1, blockposition1);
    }

    private static void makeDrippingWaterParticles(Level world, BlockPos blockposition, RandomSource randomsource, BlockState iblockdata, BlockPos blockposition1) {
        if (!(!world.isRainingAt(blockposition.above()) || randomsource.nextInt(15) != 1 || iblockdata.canOcclude() && iblockdata.isFaceSturdy(world, blockposition1, Direction.UP))) {
            ParticleUtils.spawnParticleBelow(world, blockposition, randomsource, ParticleTypes.DRIPPING_WATER);
        }
    }

    private void makeFallingLeavesParticles(Level world, BlockPos blockposition, RandomSource randomsource, BlockState iblockdata, BlockPos blockposition1) {
        if (randomsource.nextFloat() < this.leafParticleChance && !LeavesBlock.isFaceFull(iblockdata.getCollisionShape(world, blockposition1), Direction.UP)) {
            this.spawnFallingLeavesParticle(world, blockposition, randomsource);
        }
    }

    protected abstract void spawnFallingLeavesParticle(Level var1, BlockPos var2, RandomSource var3);

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(DISTANCE, PERSISTENT, WATERLOGGED);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(PERSISTENT, true)).setValue(WATERLOGGED, fluid.getType() == Fluids.WATER);
        return LeavesBlock.updateDistance(iblockdata, blockactioncontext.getLevel(), blockactioncontext.getClickedPos());
    }
}

