/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class RespawnAnchorBlock
extends Block {
    public static final MapCodec<RespawnAnchorBlock> CODEC = RespawnAnchorBlock.simpleCodec(RespawnAnchorBlock::new);
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty CHARGE = BlockStateProperties.RESPAWN_ANCHOR_CHARGES;
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::above).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public MapCodec<RespawnAnchorBlock> codec() {
        return CODEC;
    }

    public RespawnAnchorBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CHARGE, 0));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        if (RespawnAnchorBlock.isRespawnFuel(itemstack) && RespawnAnchorBlock.canBeCharged(iblockdata)) {
            RespawnAnchorBlock.charge(entityhuman, world, blockposition, iblockdata);
            itemstack.consume(1, entityhuman);
            return InteractionResult.SUCCESS;
        }
        return (InteractionResult)((Object)(enumhand == InteractionHand.MAIN_HAND && RespawnAnchorBlock.isRespawnFuel(entityhuman.getItemInHand(InteractionHand.OFF_HAND)) && RespawnAnchorBlock.canBeCharged(iblockdata) ? InteractionResult.PASS : InteractionResult.TRY_WITH_EMPTY_HAND));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (iblockdata.getValue(CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (!RespawnAnchorBlock.canSetSpawn(world)) {
            if (!world.isClientSide) {
                this.explode(iblockdata, world, blockposition);
            }
            return InteractionResult.SUCCESS;
        }
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            ServerPlayer.RespawnConfig entityplayer_respawnconfig = entityplayer.getRespawnConfig();
            ServerPlayer.RespawnConfig entityplayer_respawnconfig1 = new ServerPlayer.RespawnConfig(world.dimension(), blockposition, 0.0f, false);
            if (entityplayer_respawnconfig == null || !entityplayer_respawnconfig.isSamePosition(entityplayer_respawnconfig1)) {
                entityplayer.setRespawnPosition(entityplayer_respawnconfig1, true, PlayerSpawnChangeEvent.Cause.RESPAWN_ANCHOR);
                world.playSound((Entity)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack itemstack) {
        return itemstack.is(Items.GLOWSTONE);
    }

    private static boolean canBeCharged(BlockState iblockdata) {
        return iblockdata.getValue(CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPos blockposition, Level world) {
        FluidState fluid = world.getFluidState(blockposition);
        if (!fluid.is(FluidTags.WATER)) {
            return false;
        }
        if (fluid.isSource()) {
            return true;
        }
        float f = fluid.getAmount();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluid1 = world.getFluidState(blockposition.below());
        return !fluid1.is(FluidTags.WATER);
    }

    private void explode(BlockState iblockdata, Level world, final BlockPos blockposition) {
        org.bukkit.block.BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.removeBlock(blockposition, false);
        Stream<Direction> stream = Direction.Plane.HORIZONTAL.stream();
        Objects.requireNonNull(blockposition);
        boolean flag = stream.map(blockposition::relative).anyMatch(blockposition1 -> RespawnAnchorBlock.isWaterThatWouldFlow(blockposition1, world));
        final boolean flag1 = flag || world.getFluidState(blockposition.above()).is(FluidTags.WATER);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter iblockaccess, BlockPos blockposition1, BlockState iblockdata1, FluidState fluid) {
                return blockposition1.equals(blockposition) && flag1 ? Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance())) : super.getBlockExplosionResistance(explosion, iblockaccess, blockposition1, iblockdata1, fluid);
            }
        };
        Vec3 vec3d = blockposition.getCenter();
        world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), explosiondamagecalculator, vec3d, 5.0f, true, Level.ExplosionInteraction.BLOCK);
    }

    public static boolean canSetSpawn(Level world) {
        return world.dimensionType().respawnAnchorWorks();
    }

    public static void charge(@Nullable Entity entity, Level world, BlockPos blockposition, BlockState iblockdata) {
        BlockState iblockdata1 = (BlockState)iblockdata.setValue(CHARGE, iblockdata.getValue(CHARGE) + 1);
        world.setBlock(blockposition, iblockdata1, 3);
        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, iblockdata1));
        world.playSound((Entity)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(CHARGE) != 0) {
            if (randomsource.nextInt(100) == 0) {
                world.playLocalSound(blockposition, SoundEvents.RESPAWN_ANCHOR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double d0 = (double)blockposition.getX() + 0.5 + (0.5 - randomsource.nextDouble());
            double d1 = (double)blockposition.getY() + 1.0;
            double d2 = (double)blockposition.getZ() + 0.5 + (0.5 - randomsource.nextDouble());
            double d3 = (double)randomsource.nextFloat() * 0.04;
            world.addParticle(ParticleTypes.REVERSE_PORTAL, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(CHARGE);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    public static int getScaledChargeLevel(BlockState iblockdata, int i) {
        return Mth.floor((float)(iblockdata.getValue(CHARGE) - 0) / 4.0f * (float)i);
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition) {
        return RespawnAnchorBlock.getScaledChargeLevel(iblockdata, 15);
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> entitytypes, CollisionGetter icollisionaccess, BlockPos blockposition) {
        Optional<Vec3> optional = RespawnAnchorBlock.findStandUpPosition(entitytypes, icollisionaccess, blockposition, true);
        return optional.isPresent() ? optional : RespawnAnchorBlock.findStandUpPosition(entitytypes, icollisionaccess, blockposition, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> entitytypes, CollisionGetter icollisionaccess, BlockPos blockposition, boolean flag) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Vec3i baseblockposition : RESPAWN_OFFSETS) {
            blockposition_mutableblockposition.set(blockposition).move(baseblockposition);
            Vec3 vec3d = DismountHelper.findSafeDismountLocation(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }
}

