/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EnderChestBlockEntity
extends BlockEntity
implements LidBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(Level var0, BlockPos var1, BlockState var2) {
            var0.playSound(null, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEvents.ENDER_CHEST_OPEN, SoundSource.BLOCKS, 0.5f, var0.random.nextFloat() * 0.1f + 0.9f);
        }

        @Override
        protected void onClose(Level var0, BlockPos var1, BlockState var2) {
            var0.playSound(null, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEvents.ENDER_CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, var0.random.nextFloat() * 0.1f + 0.9f);
        }

        @Override
        protected void openerCountChanged(Level var0, BlockPos var1, BlockState var2, int var3, int var4) {
            var0.blockEvent(EnderChestBlockEntity.this.worldPosition, Blocks.ENDER_CHEST, 1, var4);
        }

        @Override
        protected boolean isOwnContainer(Player var0) {
            return var0.getEnderChestInventory().isActiveChest(EnderChestBlockEntity.this);
        }
    };

    public EnderChestBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.ENDER_CHEST, var0, var1);
    }

    public static void lidAnimateTick(Level var0, BlockPos var1, BlockState var2, EnderChestBlockEntity var3) {
        var3.chestLidController.tickLid();
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.chestLidController.shouldBeOpen(var1 > 0);
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    public void startOpen(Player var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.incrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.decrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean stillValid(Player var0) {
        return Container.stillValidBlockEntity(this, var0);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public float getOpenNess(float var0) {
        return this.chestLidController.getOpenness(var0);
    }
}

