/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;

public class VaultSharedData {
    static final String TAG_NAME = "shared_data";
    static Codec<VaultSharedData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ItemStack.lenientOptionalFieldOf("display_item").forGetter(var0 -> var0.displayItem), (App)UUIDUtil.CODEC_LINKED_SET.lenientOptionalFieldOf("connected_players", Set.of()).forGetter(var0 -> var0.connectedPlayers), (App)Codec.DOUBLE.lenientOptionalFieldOf("connected_particles_range", (Object)VaultConfig.DEFAULT.deactivationRange()).forGetter(var0 -> var0.connectedParticlesRange)).apply((Applicative)var02, VaultSharedData::new));
    private ItemStack displayItem = ItemStack.EMPTY;
    private Set<UUID> connectedPlayers = new ObjectLinkedOpenHashSet();
    private double connectedParticlesRange = VaultConfig.DEFAULT.deactivationRange();
    boolean isDirty;

    VaultSharedData(ItemStack var0, Set<UUID> var1, double var2) {
        this.displayItem = var0;
        this.connectedPlayers.addAll(var1);
        this.connectedParticlesRange = var2;
    }

    VaultSharedData() {
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public boolean hasDisplayItem() {
        return !this.displayItem.isEmpty();
    }

    public void setDisplayItem(ItemStack var0) {
        if (ItemStack.matches(this.displayItem, var0)) {
            return;
        }
        this.displayItem = var0.copy();
        this.markDirty();
    }

    boolean hasConnectedPlayers() {
        return !this.connectedPlayers.isEmpty();
    }

    Set<UUID> getConnectedPlayers() {
        return this.connectedPlayers;
    }

    double connectedParticlesRange() {
        return this.connectedParticlesRange;
    }

    void updateConnectedPlayersWithinRange(ServerLevel var0, BlockPos var12, VaultServerData var2, VaultConfig var3, double var4) {
        Set var6 = var3.playerDetector().detect(var0, var3.entitySelector(), var12, var4, false).stream().filter(var1 -> !var2.getRewardedPlayers().contains(var1)).collect(Collectors.toSet());
        if (!this.connectedPlayers.equals(var6)) {
            this.connectedPlayers = var6;
            this.markDirty();
        }
    }

    private void markDirty() {
        this.isDirty = true;
    }

    void set(VaultSharedData var0) {
        this.displayItem = var0.displayItem;
        this.connectedPlayers = var0.connectedPlayers;
        this.connectedParticlesRange = var0.connectedParticlesRange;
    }
}

