/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class LevelChunk
extends ChunkAccess {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final TickingBlockEntity NULL_TICKER = new TickingBlockEntity(){

        @Override
        public void tick() {
        }

        @Override
        public boolean isRemoved() {
            return true;
        }

        @Override
        public BlockPos getPos() {
            return BlockPos.ZERO;
        }

        @Override
        public String getType() {
            return "<null>";
        }
    };
    private final Map<BlockPos, RebindableTickingBlockEntityWrapper> tickersInLevel = Maps.newHashMap();
    public boolean loaded;
    public final ServerLevel r;
    @Nullable
    private Supplier<FullChunkStatus> fullStatus;
    @Nullable
    private PostLoadProcessor postLoad;
    private final Int2ObjectMap<GameEventListenerRegistry> gameEventListenerRegistrySections;
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<Fluid> fluidTicks;
    private UnsavedListener unsavedListener = chunkcoordintpair1 -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;

    public LevelChunk(Level world, ChunkPos chunkcoordintpair) {
        this(world, chunkcoordintpair, UpgradeData.EMPTY, new LevelChunkTicks<Block>(), new LevelChunkTicks<Fluid>(), 0L, null, null, null);
    }

    public LevelChunk(Level world, ChunkPos chunkcoordintpair, UpgradeData chunkconverter, LevelChunkTicks<Block> levelchunkticks, LevelChunkTicks<Fluid> levelchunkticks1, long i, @Nullable LevelChunkSection[] achunksection, @Nullable PostLoadProcessor chunk_c, @Nullable BlendingData blendingdata) {
        super(chunkcoordintpair, chunkconverter, world, (Registry<Biome>)world.registryAccess().lookupOrThrow(Registries.BIOME), i, achunksection, blendingdata);
        this.r = (ServerLevel)world;
        this.gameEventListenerRegistrySections = new Int2ObjectOpenHashMap();
        for (Heightmap.Types heightmap_type : Heightmap.Types.values()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(heightmap_type)) continue;
            this.heightmaps.put(heightmap_type, new Heightmap(this, heightmap_type));
        }
        this.postLoad = chunk_c;
        this.blockTicks = levelchunkticks;
        this.fluidTicks = levelchunkticks1;
    }

    public LevelChunk(ServerLevel worldserver, ProtoChunk protochunk, @Nullable PostLoadProcessor chunk_c) {
        this(worldserver, protochunk.getPos(), protochunk.getUpgradeData(), protochunk.unpackBlockTicks(), protochunk.unpackFluidTicks(), protochunk.getInhabitedTime(), protochunk.getSections(), chunk_c, protochunk.getBlendingData());
        if (!Collections.disjoint(protochunk.pendingBlockEntities.keySet(), protochunk.blockEntities.keySet())) {
            LOGGER.error("Chunk at {} contains duplicated block entities", (Object)protochunk.getPos());
        }
        for (BlockEntity tileentity : protochunk.getBlockEntities().values()) {
            this.setBlockEntity(tileentity);
        }
        this.pendingBlockEntities.putAll(protochunk.getBlockEntityNbts());
        for (int i = 0; i < protochunk.getPostProcessing().length; ++i) {
            this.postProcessing[i] = protochunk.getPostProcessing()[i];
        }
        this.setAllStarts(protochunk.getAllStarts());
        this.setAllReferences(protochunk.getAllReferences());
        for (Map.Entry<Heightmap.Types, Heightmap> map_entry : protochunk.getHeightmaps()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(map_entry.getKey())) continue;
            this.setHeightmap(map_entry.getKey(), map_entry.getValue().getRawData());
        }
        this.skyLightSources = protochunk.skyLightSources;
        this.setLightCorrect(protochunk.isLightCorrect());
        this.markUnsaved();
        this.needsDecoration = true;
        this.persistentDataContainer = protochunk.persistentDataContainer;
    }

    public void setUnsavedListener(UnsavedListener chunk_e) {
        this.unsavedListener = chunk_e;
        if (this.isUnsaved()) {
            chunk_e.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public void markUnsaved() {
        boolean flag = this.isUnsaved();
        super.markUnsaved();
        if (!flag) {
            this.unsavedListener.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public ChunkAccess.PackedTicks getTicksForSerialization(long i) {
        return new ChunkAccess.PackedTicks(this.blockTicks.pack(i), this.fluidTicks.pack(i));
    }

    @Override
    public GameEventListenerRegistry getListenerRegistry(int i) {
        ServerLevel world = this.r;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = world;
            return (GameEventListenerRegistry)this.gameEventListenerRegistrySections.computeIfAbsent(i, j -> new EuclideanGameEventListenerRegistry(worldserver, i, this::removeGameEventListenerRegistry));
        }
        return super.getListenerRegistry(i);
    }

    @Override
    public BlockState getBlockState(BlockPos blockposition) {
        int i = blockposition.getX();
        int j = blockposition.getY();
        int k = blockposition.getZ();
        if (this.r.isDebug()) {
            BlockState iblockdata = null;
            if (j == 60) {
                iblockdata = Blocks.BARRIER.defaultBlockState();
            }
            if (j == 70) {
                iblockdata = DebugLevelSource.getBlockStateFor(i, k);
            }
            return iblockdata == null ? Blocks.AIR.defaultBlockState() : iblockdata;
        }
        try {
            LevelChunkSection chunksection;
            int l = this.getSectionIndex(j);
            if (l >= 0 && l < this.sections.length && !(chunksection = this.sections[l]).hasOnlyAir()) {
                return chunksection.getBlockState(i & 0xF, j & 0xF, k & 0xF);
            }
            return Blocks.AIR.defaultBlockState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting block state");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being got");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this, i, j, k));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public FluidState getFluidState(BlockPos blockposition) {
        return this.getFluidState(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public FluidState getFluidState(int i, int j, int k) {
        try {
            LevelChunkSection chunksection;
            int l = this.getSectionIndex(j);
            if (l >= 0 && l < this.sections.length && !(chunksection = this.sections[l]).hasOnlyAir()) {
                return chunksection.getFluidState(i & 0xF, j & 0xF, k & 0xF);
            }
            return Fluids.EMPTY.defaultFluidState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting fluid state");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being got");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this, i, j, k));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public BlockState setBlockState(BlockPos blockposition, BlockState iblockdata, int i) {
        ServerLevel world;
        boolean flag4;
        int i1;
        int l;
        int j = blockposition.getY();
        LevelChunkSection chunksection = this.getSection(this.getSectionIndex(j));
        boolean flag = chunksection.hasOnlyAir();
        if (flag && iblockdata.isAir()) {
            return null;
        }
        int k = blockposition.getX() & 0xF;
        BlockState iblockdata1 = chunksection.setBlockState(k, l = j & 0xF, i1 = blockposition.getZ() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.getBlock();
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING)).update(k, j, i1, iblockdata);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).update(k, j, i1, iblockdata);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.OCEAN_FLOOR)).update(k, j, i1, iblockdata);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.WORLD_SURFACE)).update(k, j, i1, iblockdata);
        boolean flag1 = chunksection.hasOnlyAir();
        if (flag != flag1) {
            this.r.getChunkSource().getLightEngine().updateSectionStatus(blockposition, flag1);
            this.r.getChunkSource().onSectionEmptinessChanged(this.chunkPos.x, SectionPos.blockToSectionCoord(j), this.chunkPos.z, flag1);
        }
        if (LightEngine.hasDifferentLightProperties(iblockdata1, iblockdata)) {
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("updateSkyLightSources");
            this.skyLightSources.update(this, k, j, i1);
            gameprofilerfiller.popPush("queueCheckLight");
            this.r.getChunkSource().getLightEngine().checkBlock(blockposition);
            gameprofilerfiller.pop();
        }
        boolean flag2 = !iblockdata1.is(block);
        boolean flag3 = (i & 0x40) != 0;
        boolean bl = flag4 = (i & 0x100) == 0;
        if (flag2 && iblockdata1.hasBlockEntity()) {
            BlockEntity tileentity;
            if (!this.r.isClientSide && flag4 && (tileentity = this.r.getBlockEntity(blockposition)) != null) {
                tileentity.preRemoveSideEffects(blockposition, iblockdata1);
            }
            this.removeBlockEntity(blockposition);
        }
        if ((flag2 || block instanceof BaseRailBlock) && (world = this.r) instanceof ServerLevel) {
            ServerLevel worldserver = world;
            if ((i & 1) != 0 || flag3) {
                iblockdata1.affectNeighborsAfterRemoval(worldserver, blockposition, flag3);
            }
        }
        if (!chunksection.getBlockState(k, l, i1).is(block)) {
            return null;
        }
        if (!(this.r.isClientSide || (i & 0x200) != 0 || this.r.captureBlockStates && !(block instanceof BaseEntityBlock))) {
            iblockdata.onPlace(this.r, blockposition, iblockdata1, flag3);
        }
        if (iblockdata.hasBlockEntity()) {
            BlockEntity tileentity1 = this.getBlockEntity(blockposition, EntityCreationType.CHECK);
            if (tileentity1 != null && !tileentity1.isValidBlockState(iblockdata)) {
                LOGGER.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{blockposition, tileentity1.getType().builtInRegistryHolder().key().location(), iblockdata});
                this.removeBlockEntity(blockposition);
                tileentity1 = null;
            }
            if (tileentity1 == null) {
                tileentity1 = ((EntityBlock)((Object)block)).newBlockEntity(blockposition, iblockdata);
                if (tileentity1 != null) {
                    this.addAndRegisterBlockEntity(tileentity1);
                }
            } else {
                tileentity1.setBlockState(iblockdata);
                this.updateBlockEntityTicker(tileentity1);
            }
        }
        this.markUnsaved();
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void addEntity(Entity entity) {
    }

    @Nullable
    private BlockEntity createBlockEntity(BlockPos blockposition) {
        BlockState iblockdata = this.getBlockState(blockposition);
        return !iblockdata.hasBlockEntity() ? null : ((EntityBlock)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockposition) {
        return this.getBlockEntity(blockposition, EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockposition, EntityCreationType chunk_enumtileentitystate) {
        BlockEntity tileentity1;
        CompoundTag nbttagcompound;
        BlockEntity tileentity = (BlockEntity)this.r.capturedTileEntities.get(blockposition);
        if (tileentity == null) {
            tileentity = (BlockEntity)this.blockEntities.get(blockposition);
        }
        if (tileentity == null && (nbttagcompound = (CompoundTag)this.pendingBlockEntities.remove(blockposition)) != null && (tileentity1 = this.promotePendingBlockEntity(blockposition, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (chunk_enumtileentitystate == EntityCreationType.IMMEDIATE && (tileentity = this.createBlockEntity(blockposition)) != null) {
                this.addAndRegisterBlockEntity(tileentity);
            }
        } else if (tileentity.isRemoved()) {
            this.blockEntities.remove(blockposition);
            return null;
        }
        return tileentity;
    }

    public void addAndRegisterBlockEntity(BlockEntity tileentity) {
        this.setBlockEntity(tileentity);
        if (this.isInLevel()) {
            ServerLevel world = this.r;
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = world;
                this.addGameEventListener(tileentity, worldserver);
            }
            this.r.onBlockEntityAdded(tileentity);
            this.updateBlockEntityTicker(tileentity);
        }
    }

    private boolean isInLevel() {
        return this.loaded || this.r.isClientSide();
    }

    boolean isTicking(BlockPos blockposition) {
        if (!this.r.getWorldBorder().isWithinBounds(blockposition)) {
            return false;
        }
        ServerLevel world = this.r;
        if (!(world instanceof ServerLevel)) {
            return true;
        }
        ServerLevel worldserver = world;
        return this.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING) && worldserver.areEntitiesLoaded(ChunkPos.asLong(blockposition));
    }

    @Override
    public void setBlockEntity(BlockEntity tileentity) {
        BlockPos blockposition = tileentity.getBlockPos();
        BlockState iblockdata = this.getBlockState(blockposition);
        if (!iblockdata.hasBlockEntity()) {
            LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
            new Exception().printStackTrace();
        } else {
            BlockState iblockdata1 = tileentity.getBlockState();
            if (iblockdata != iblockdata1) {
                if (!tileentity.getType().isValid(iblockdata)) {
                    LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
                    return;
                }
                if (iblockdata.getBlock() != iblockdata1.getBlock()) {
                    LOGGER.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{tileentity, blockposition, iblockdata, iblockdata1});
                }
                tileentity.setBlockState(iblockdata);
            }
            tileentity.setLevel(this.r);
            tileentity.clearRemoved();
            BlockEntity tileentity1 = this.blockEntities.put(blockposition.immutable(), tileentity);
            if (tileentity1 != null && tileentity1 != tileentity) {
                tileentity1.setRemoved();
            }
        }
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos blockposition, HolderLookup.Provider holderlookup_a) {
        BlockEntity tileentity = this.getBlockEntity(blockposition);
        if (tileentity != null && !tileentity.isRemoved()) {
            CompoundTag nbttagcompound = tileentity.saveWithFullMetadata(this.r.registryAccess());
            nbttagcompound.putBoolean("keepPacked", false);
            return nbttagcompound;
        }
        CompoundTag nbttagcompound1 = (CompoundTag)this.pendingBlockEntities.get(blockposition);
        if (nbttagcompound1 != null) {
            nbttagcompound1 = nbttagcompound1.copy();
            nbttagcompound1.putBoolean("keepPacked", true);
        }
        return nbttagcompound1;
    }

    @Override
    public void removeBlockEntity(BlockPos blockposition) {
        if (this.isInLevel()) {
            BlockEntity tileentity = (BlockEntity)this.blockEntities.remove(blockposition);
            if (!this.pendingBlockEntities.isEmpty()) {
                this.pendingBlockEntities.remove(blockposition);
            }
            if (tileentity != null) {
                ServerLevel world = this.r;
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver = world;
                    this.removeGameEventListener(tileentity, worldserver);
                }
                tileentity.setRemoved();
            }
        }
        this.removeBlockEntityTicker(blockposition);
    }

    private <T extends BlockEntity> void removeGameEventListener(T t0, ServerLevel worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.getBlockState().getBlock();
        if (block instanceof EntityBlock && (gameeventlistener = ((EntityBlock)((Object)block)).getListener(worldserver, t0)) != null) {
            int i = SectionPos.blockToSectionCoord(t0.getBlockPos().getY());
            GameEventListenerRegistry gameeventlistenerregistry = this.getListenerRegistry(i);
            gameeventlistenerregistry.unregister(gameeventlistener);
        }
    }

    private void removeGameEventListenerRegistry(int i) {
        this.gameEventListenerRegistrySections.remove(i);
    }

    private void removeBlockEntityTicker(BlockPos blockposition) {
        RebindableTickingBlockEntityWrapper chunk_d = this.tickersInLevel.remove(blockposition);
        if (chunk_d != null) {
            chunk_d.rebind(NULL_TICKER);
        }
    }

    public void runPostLoad() {
        if (this.postLoad != null) {
            this.postLoad.run(this);
            this.postLoad = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        CraftServer server = this.r.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((Chunk)bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.r.getSeed());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.chunkPos.x * xRand + (long)this.chunkPos.z * zRand ^ this.r.getSeed());
                CraftWorld world = this.r.getWorld();
                if (world != null) {
                    this.r.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((World)world, random, (Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.r.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        CraftServer server = this.r.getCraftServer();
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((Chunk)bukkitChunk, this.isUnsaved());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Override
    public boolean isUnsaved() {
        return super.isUnsaved() && !this.mustNotSave;
    }

    public boolean isEmpty() {
        return false;
    }

    public void replaceWithPacketData(FriendlyByteBuf packetdataserializer, Map<Heightmap.Types, long[]> map, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        this.clearAllBlockEntities();
        for (LevelChunkSection chunksection : this.sections) {
            chunksection.read(packetdataserializer);
        }
        map.forEach(this::setHeightmap);
        this.initializeLightSources();
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            consumer.accept((blockposition, tileentitytypes, nbttagcompound) -> {
                BlockEntity tileentity = this.getBlockEntity(blockposition, EntityCreationType.IMMEDIATE);
                if (tileentity != null && nbttagcompound != null && tileentity.getType() == tileentitytypes) {
                    tileentity.loadWithComponents(TagValueInput.create(problemreporter_j.forChild(tileentity.problemPath()), (HolderLookup.Provider)this.r.registryAccess(), nbttagcompound));
                }
            });
        }
    }

    public void replaceBiomes(FriendlyByteBuf packetdataserializer) {
        for (LevelChunkSection chunksection : this.sections) {
            chunksection.readBiomes(packetdataserializer);
        }
    }

    public void setLoaded(boolean flag) {
        this.loaded = flag;
    }

    public Level getLevel() {
        return this.r;
    }

    public Map<BlockPos, BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void postProcessGeneration(ServerLevel worldserver) {
        ChunkPos chunkcoordintpair = this.getPos();
        for (int i = 0; i < this.postProcessing.length; ++i) {
            if (this.postProcessing[i] == null) continue;
            for (Short oshort : this.postProcessing[i]) {
                BlockState iblockdata1;
                BlockPos blockposition = ProtoChunk.unpackOffsetCoordinates(oshort, this.getSectionYFromSectionIndex(i), chunkcoordintpair);
                BlockState iblockdata = this.getBlockState(blockposition);
                FluidState fluid = iblockdata.getFluidState();
                if (!fluid.isEmpty()) {
                    fluid.tick(worldserver, blockposition, iblockdata);
                }
                if (iblockdata.getBlock() instanceof LiquidBlock || (iblockdata1 = Block.updateFromNeighbourShapes(iblockdata, worldserver, blockposition)) == iblockdata) continue;
                worldserver.setBlock(blockposition, iblockdata1, 276);
            }
            this.postProcessing[i].clear();
        }
        for (BlockPos blockposition1 : ImmutableList.copyOf(this.pendingBlockEntities.keySet())) {
            this.getBlockEntity(blockposition1);
        }
        this.pendingBlockEntities.clear();
        this.upgradeData.upgrade(this);
    }

    @Nullable
    private BlockEntity promotePendingBlockEntity(BlockPos blockposition, CompoundTag nbttagcompound) {
        BlockEntity tileentity;
        BlockState iblockdata = this.getBlockState(blockposition);
        if ("DUMMY".equals(nbttagcompound.getStringOr("id", ""))) {
            if (iblockdata.hasBlockEntity()) {
                tileentity = ((EntityBlock)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
            } else {
                tileentity = null;
                LOGGER.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockposition, (Object)iblockdata);
            }
        } else {
            tileentity = BlockEntity.loadStatic(blockposition, iblockdata, nbttagcompound, this.r.registryAccess());
        }
        if (tileentity != null) {
            tileentity.setLevel(this.r);
            this.addAndRegisterBlockEntity(tileentity);
        } else {
            LOGGER.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)blockposition);
        }
        return tileentity;
    }

    public void unpackTicks(long i) {
        this.blockTicks.unpack(i);
        this.fluidTicks.unpack(i);
    }

    public void registerTickContainerInLevel(ServerLevel worldserver) {
        ((LevelTicks)worldserver.getBlockTicks()).addContainer(this.chunkPos, this.blockTicks);
        ((LevelTicks)worldserver.getFluidTicks()).addContainer(this.chunkPos, this.fluidTicks);
    }

    public void unregisterTickContainerFromLevel(ServerLevel worldserver) {
        ((LevelTicks)worldserver.getBlockTicks()).removeContainer(this.chunkPos);
        ((LevelTicks)worldserver.getFluidTicks()).removeContainer(this.chunkPos);
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return ChunkStatus.FULL;
    }

    public FullChunkStatus getFullStatus() {
        return this.fullStatus == null ? FullChunkStatus.FULL : this.fullStatus.get();
    }

    public void setFullStatus(Supplier<FullChunkStatus> supplier) {
        this.fullStatus = supplier;
    }

    public void clearAllBlockEntities() {
        this.blockEntities.values().forEach(BlockEntity::setRemoved);
        this.blockEntities.clear();
        this.tickersInLevel.values().forEach(chunk_d -> chunk_d.rebind(NULL_TICKER));
        this.tickersInLevel.clear();
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
        this.blockEntities.values().forEach(tileentity -> {
            ServerLevel world = this.r;
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = world;
                this.addGameEventListener(tileentity, worldserver);
            }
            this.r.onBlockEntityAdded((BlockEntity)tileentity);
            this.updateBlockEntityTicker(tileentity);
        });
    }

    private <T extends BlockEntity> void addGameEventListener(T t0, ServerLevel worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.getBlockState().getBlock();
        if (block instanceof EntityBlock && (gameeventlistener = ((EntityBlock)((Object)block)).getListener(worldserver, t0)) != null) {
            this.getListenerRegistry(SectionPos.blockToSectionCoord(t0.getBlockPos().getY())).register(gameeventlistener);
        }
    }

    private <T extends BlockEntity> void updateBlockEntityTicker(T t0) {
        BlockState iblockdata = t0.getBlockState();
        BlockEntityTicker<?> blockentityticker = iblockdata.getTicker(this.r, t0.getType());
        if (blockentityticker == null) {
            this.removeBlockEntityTicker(t0.getBlockPos());
        } else {
            this.tickersInLevel.compute(t0.getBlockPos(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.createTicker(t0, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.rebind(tickingblockentity);
                    return chunk_d;
                }
                if (this.isInLevel()) {
                    RebindableTickingBlockEntityWrapper chunk_d1 = new RebindableTickingBlockEntityWrapper(tickingblockentity);
                    this.r.addBlockEntityTicker(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends BlockEntity> TickingBlockEntity createTicker(T t0, BlockEntityTicker<T> blockentityticker) {
        return new BoundTickingBlockEntity(t0, blockentityticker);
    }

    @FunctionalInterface
    public static interface PostLoadProcessor {
        public void run(LevelChunk var1);
    }

    @FunctionalInterface
    public static interface UnsavedListener {
        public void setUnsaved(ChunkPos var1);
    }

    public static enum EntityCreationType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }

    private static class RebindableTickingBlockEntityWrapper
    implements TickingBlockEntity {
        private TickingBlockEntity ticker;

        RebindableTickingBlockEntityWrapper(TickingBlockEntity tickingblockentity) {
            this.ticker = tickingblockentity;
        }

        void rebind(TickingBlockEntity tickingblockentity) {
            this.ticker = tickingblockentity;
        }

        @Override
        public void tick() {
            this.ticker.tick();
        }

        @Override
        public boolean isRemoved() {
            return this.ticker.isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return this.ticker.getPos();
        }

        @Override
        public String getType() {
            return this.ticker.getType();
        }

        public String toString() {
            return String.valueOf(this.ticker) + " <wrapped>";
        }
    }

    private class BoundTickingBlockEntity<T extends BlockEntity>
    implements TickingBlockEntity {
        private final T blockEntity;
        private final BlockEntityTicker<T> ticker;
        private boolean loggedInvalidBlockState;

        BoundTickingBlockEntity(BlockEntity tileentity, BlockEntityTicker blockentityticker) {
            this.blockEntity = tileentity;
            this.ticker = blockentityticker;
        }

        @Override
        public void tick() {
            BlockPos blockposition;
            if (!((BlockEntity)this.blockEntity).isRemoved() && ((BlockEntity)this.blockEntity).hasLevel() && LevelChunk.this.isTicking(blockposition = ((BlockEntity)this.blockEntity).getBlockPos())) {
                try {
                    ProfilerFiller gameprofilerfiller = Profiler.get();
                    gameprofilerfiller.push(this::getType);
                    ((BlockEntity)this.blockEntity).tickTimer.startTiming();
                    BlockState iblockdata = LevelChunk.this.getBlockState(blockposition);
                    if (((BlockEntity)this.blockEntity).getType().isValid(iblockdata)) {
                        this.ticker.tick(LevelChunk.this.r, ((BlockEntity)this.blockEntity).getBlockPos(), iblockdata, this.blockEntity);
                        this.loggedInvalidBlockState = false;
                    } else if (!this.loggedInvalidBlockState) {
                        this.loggedInvalidBlockState = true;
                        LOGGER.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::getType), LogUtils.defer(this::getPos), iblockdata});
                    }
                    gameprofilerfiller.pop();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking block entity");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block entity being ticked");
                    ((BlockEntity)this.blockEntity).fillCrashReportCategory(crashreportsystemdetails);
                    throw new ReportedException(crashreport);
                }
                finally {
                    ((BlockEntity)this.blockEntity).tickTimer.stopTiming();
                }
            }
        }

        @Override
        public boolean isRemoved() {
            return ((BlockEntity)this.blockEntity).isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return ((BlockEntity)this.blockEntity).getBlockPos();
        }

        @Override
        public String getType() {
            return BlockEntityType.getKey(((BlockEntity)this.blockEntity).getType()).toString();
        }

        public String toString() {
            String s = this.getType();
            return "Level ticker for " + s + "@" + String.valueOf(this.getPos());
        }
    }
}

