/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public void tick(ServerLevel worldserver, boolean flag, boolean flag1) {
        if (flag && worldserver.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            RandomSource randomsource = worldserver.random;
            --this.nextTick;
            if (this.nextTick <= 0) {
                this.nextTick += (60 + randomsource.nextInt(60)) * 20;
                if (worldserver.getSkyDarken() >= 5 || !worldserver.dimensionType().hasSkyLight()) {
                    for (ServerPlayer entityplayer : worldserver.players()) {
                        FluidState fluid;
                        BlockState iblockdata;
                        BlockPos blockposition1;
                        DifficultyInstance difficultydamagescaler;
                        if (entityplayer.isSpectator()) continue;
                        BlockPos blockposition = entityplayer.blockPosition();
                        if (worldserver.dimensionType().hasSkyLight() && (blockposition.getY() < worldserver.getSeaLevel() || !worldserver.canSeeSky(blockposition)) || !(difficultydamagescaler = worldserver.getCurrentDifficultyAt(blockposition)).isHarderThan(randomsource.nextFloat() * 3.0f)) continue;
                        ServerStatsCounter serverstatisticmanager = entityplayer.getStats();
                        int i = Mth.clamp(serverstatisticmanager.getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
                        int j = 24000;
                        if (randomsource.nextInt(i) < 72000 || !NaturalSpawner.isValidEmptySpawnBlock(worldserver, blockposition1 = blockposition.above(20 + randomsource.nextInt(15)).east(-10 + randomsource.nextInt(21)).south(-10 + randomsource.nextInt(21)), iblockdata = worldserver.getBlockState(blockposition1), fluid = worldserver.getFluidState(blockposition1), EntityType.PHANTOM)) continue;
                        SpawnGroupData groupdataentity = null;
                        int k = 1 + randomsource.nextInt(difficultydamagescaler.getDifficulty().getId() + 1);
                        for (int l = 0; l < k; ++l) {
                            Phantom entityphantom = EntityType.PHANTOM.create(worldserver, EntitySpawnReason.NATURAL);
                            if (entityphantom == null) continue;
                            entityphantom.snapTo(blockposition1, 0.0f, 0.0f);
                            groupdataentity = entityphantom.finalizeSpawn(worldserver, difficultydamagescaler, EntitySpawnReason.NATURAL, groupdataentity);
                            worldserver.addFreshEntityWithPassengers(entityphantom, CreatureSpawnEvent.SpawnReason.NATURAL);
                        }
                    }
                }
            }
        }
    }
}

