/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender EMPTY = new Blender(new Long2ObjectOpenHashMap(), new Long2ObjectOpenHashMap()){

        @Override
        public BlendingOutput blendOffsetAndFactor(int var0, int var1) {
            return new BlendingOutput(1.0, 0.0);
        }

        @Override
        public double blendDensity(DensityFunction.FunctionContext var0, double var1) {
            return var1;
        }

        @Override
        public BiomeResolver getBiomeResolver(BiomeResolver var0) {
            return var0;
        }
    };
    private static final NormalNoise SHIFT_NOISE = NormalNoise.create(new XoroshiroRandomSource(42L), NoiseData.DEFAULT_SHIFT);
    private static final int HEIGHT_BLENDING_RANGE_CELLS = QuartPos.fromSection(7) - 1;
    private static final int HEIGHT_BLENDING_RANGE_CHUNKS = QuartPos.toSection(HEIGHT_BLENDING_RANGE_CELLS + 3);
    private static final int DENSITY_BLENDING_RANGE_CELLS = 2;
    private static final int DENSITY_BLENDING_RANGE_CHUNKS = QuartPos.toSection(5);
    private static final double OLD_CHUNK_XZ_RADIUS = 8.0;
    private final Long2ObjectOpenHashMap<BlendingData> heightAndBiomeBlendingData;
    private final Long2ObjectOpenHashMap<BlendingData> densityBlendingData;

    public static Blender empty() {
        return EMPTY;
    }

    public static Blender of(@Nullable WorldGenRegion var0) {
        if (var0 == null) {
            return EMPTY;
        }
        ChunkPos var1 = var0.getCenter();
        if (!var0.isOldChunkAround(var1, HEIGHT_BLENDING_RANGE_CHUNKS)) {
            return EMPTY;
        }
        Long2ObjectOpenHashMap var2 = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap var3 = new Long2ObjectOpenHashMap();
        int var4 = Mth.square(HEIGHT_BLENDING_RANGE_CHUNKS + 1);
        for (int var5 = -HEIGHT_BLENDING_RANGE_CHUNKS; var5 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var5) {
            for (int var6 = -HEIGHT_BLENDING_RANGE_CHUNKS; var6 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var6) {
                int var8;
                int var7;
                BlendingData var9;
                if (var5 * var5 + var6 * var6 > var4 || (var9 = BlendingData.getOrUpdateBlendingData(var0, var7 = var1.x + var5, var8 = var1.z + var6)) == null) continue;
                var2.put(ChunkPos.asLong(var7, var8), (Object)var9);
                if (var5 < -DENSITY_BLENDING_RANGE_CHUNKS || var5 > DENSITY_BLENDING_RANGE_CHUNKS || var6 < -DENSITY_BLENDING_RANGE_CHUNKS || var6 > DENSITY_BLENDING_RANGE_CHUNKS) continue;
                var3.put(ChunkPos.asLong(var7, var8), (Object)var9);
            }
        }
        if (var2.isEmpty() && var3.isEmpty()) {
            return EMPTY;
        }
        return new Blender((Long2ObjectOpenHashMap<BlendingData>)var2, (Long2ObjectOpenHashMap<BlendingData>)var3);
    }

    Blender(Long2ObjectOpenHashMap<BlendingData> var0, Long2ObjectOpenHashMap<BlendingData> var1) {
        this.heightAndBiomeBlendingData = var0;
        this.densityBlendingData = var1;
    }

    public BlendingOutput blendOffsetAndFactor(int var0, int var1) {
        int var3;
        int var2 = QuartPos.fromBlock(var0);
        double var4 = this.getBlendingDataValue(var2, 0, var3 = QuartPos.fromBlock(var1), BlendingData::getHeight);
        if (var4 != Double.MAX_VALUE) {
            return new BlendingOutput(0.0, Blender.heightToOffset(var4));
        }
        MutableDouble var6 = new MutableDouble(0.0);
        MutableDouble var7 = new MutableDouble(0.0);
        MutableDouble var8 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.heightAndBiomeBlendingData.forEach((var52, var62) -> var62.iterateHeights(QuartPos.fromSection(ChunkPos.getX(var52)), QuartPos.fromSection(ChunkPos.getZ(var52)), (var5, var6, var7) -> {
            double var9 = Mth.length(var2 - var5, var3 - var6);
            if (var9 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                return;
            }
            if (var9 < var8.doubleValue()) {
                var8.setValue(var9);
            }
            double var11 = 1.0 / (var9 * var9 * var9 * var9);
            var7.add(var7 * var11);
            var6.add(var11);
        }));
        if (var8.doubleValue() == Double.POSITIVE_INFINITY) {
            return new BlendingOutput(1.0, 0.0);
        }
        double var9 = var7.doubleValue() / var6.doubleValue();
        double var11 = Mth.clamp(var8.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        var11 = 3.0 * var11 * var11 - 2.0 * var11 * var11 * var11;
        return new BlendingOutput(var11, Blender.heightToOffset(var9));
    }

    private static double heightToOffset(double var0) {
        double var2 = 1.0;
        double var4 = var0 + 0.5;
        double var6 = Mth.positiveModulo(var4, 8.0);
        return 1.0 * (32.0 * (var4 - 128.0) - 3.0 * (var4 - 120.0) * var6 + 3.0 * var6 * var6) / (128.0 * (32.0 - 3.0 * var6));
    }

    public double blendDensity(DensityFunction.FunctionContext var0, double var1) {
        int var5;
        int var4;
        int var3 = QuartPos.fromBlock(var0.blockX());
        double var6 = this.getBlendingDataValue(var3, var4 = var0.blockY() / 8, var5 = QuartPos.fromBlock(var0.blockZ()), BlendingData::getDensity);
        if (var6 != Double.MAX_VALUE) {
            return var6;
        }
        MutableDouble var8 = new MutableDouble(0.0);
        MutableDouble var9 = new MutableDouble(0.0);
        MutableDouble var10 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.densityBlendingData.forEach((var62, var72) -> var72.iterateDensities(QuartPos.fromSection(ChunkPos.getX(var62)), QuartPos.fromSection(ChunkPos.getZ(var62)), var4 - 1, var4 + 1, (var6, var7, var8, var9) -> {
            double var11 = Mth.length(var3 - var6, (var4 - var7) * 2, var5 - var8);
            if (var11 > 2.0) {
                return;
            }
            if (var11 < var10.doubleValue()) {
                var10.setValue(var11);
            }
            double var13 = 1.0 / (var11 * var11 * var11 * var11);
            var9.add(var9 * var13);
            var8.add(var13);
        }));
        if (var10.doubleValue() == Double.POSITIVE_INFINITY) {
            return var1;
        }
        double var11 = var9.doubleValue() / var8.doubleValue();
        double var13 = Mth.clamp(var10.doubleValue() / 3.0, 0.0, 1.0);
        return Mth.lerp(var13, var11, var1);
    }

    private double getBlendingDataValue(int var0, int var1, int var2, CellValueGetter var3) {
        int var4 = QuartPos.toSection(var0);
        int var5 = QuartPos.toSection(var2);
        boolean var6 = (var0 & 3) == 0;
        boolean var7 = (var2 & 3) == 0;
        double var8 = this.getBlendingDataValue(var3, var4, var5, var0, var1, var2);
        if (var8 == Double.MAX_VALUE) {
            if (var6 && var7) {
                var8 = this.getBlendingDataValue(var3, var4 - 1, var5 - 1, var0, var1, var2);
            }
            if (var8 == Double.MAX_VALUE) {
                if (var6) {
                    var8 = this.getBlendingDataValue(var3, var4 - 1, var5, var0, var1, var2);
                }
                if (var8 == Double.MAX_VALUE && var7) {
                    var8 = this.getBlendingDataValue(var3, var4, var5 - 1, var0, var1, var2);
                }
            }
        }
        return var8;
    }

    private double getBlendingDataValue(CellValueGetter var0, int var1, int var2, int var3, int var4, int var5) {
        BlendingData var6 = (BlendingData)this.heightAndBiomeBlendingData.get(ChunkPos.asLong(var1, var2));
        if (var6 != null) {
            return var0.get(var6, var3 - QuartPos.fromSection(var1), var4, var5 - QuartPos.fromSection(var2));
        }
        return Double.MAX_VALUE;
    }

    public BiomeResolver getBiomeResolver(BiomeResolver var0) {
        return (var1, var2, var3, var4) -> {
            Holder<Biome> var5 = this.blendBiome(var1, var2, var3);
            if (var5 == null) {
                return var0.getNoiseBiome(var1, var2, var3, var4);
            }
            return var5;
        };
    }

    @Nullable
    private Holder<Biome> blendBiome(int var0, int var1, int var2) {
        MutableDouble var3 = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableObject var4 = new MutableObject();
        this.heightAndBiomeBlendingData.forEach((var52, var62) -> var62.iterateBiomes(QuartPos.fromSection(ChunkPos.getX(var52)), var1, QuartPos.fromSection(ChunkPos.getZ(var52)), (var4, var5, var6) -> {
            double var7 = Mth.length(var0 - var4, var2 - var5);
            if (var7 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                return;
            }
            if (var7 < var3.doubleValue()) {
                var4.setValue((Object)var6);
                var3.setValue(var7);
            }
        }));
        if (var3.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double var5 = SHIFT_NOISE.getValue(var0, 0.0, var2) * 12.0;
        double var7 = Mth.clamp((var3.doubleValue() + var5) / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        if (var7 > 0.5) {
            return null;
        }
        return (Holder)var4.getValue();
    }

    public static void generateBorderTicks(WorldGenRegion var0, ChunkAccess var1) {
        ChunkPos var2 = var1.getPos();
        boolean var3 = var1.isOldNoiseGeneration();
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        BlockPos var5 = new BlockPos(var2.getMinBlockX(), 0, var2.getMinBlockZ());
        BlendingData var6 = var1.getBlendingData();
        if (var6 == null) {
            return;
        }
        int var7 = var6.getAreaWithOldGeneration().getMinY();
        int var8 = var6.getAreaWithOldGeneration().getMaxY();
        if (var3) {
            for (int var9 = 0; var9 < 16; ++var9) {
                for (int var10 = 0; var10 < 16; ++var10) {
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var9, var7 - 1, var10));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var9, var7, var10));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var9, var8, var10));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var9, var8 + 1, var10));
                }
            }
        }
        for (Direction var10 : Direction.Plane.HORIZONTAL) {
            if (var0.getChunk(var2.x + var10.getStepX(), var2.z + var10.getStepZ()).isOldNoiseGeneration() == var3) continue;
            int var11 = var10 == Direction.EAST ? 15 : 0;
            int var12 = var10 == Direction.WEST ? 0 : 15;
            int var13 = var10 == Direction.SOUTH ? 15 : 0;
            int var14 = var10 == Direction.NORTH ? 0 : 15;
            for (int var15 = var11; var15 <= var12; ++var15) {
                for (int var16 = var13; var16 <= var14; ++var16) {
                    int var17 = Math.min(var8, var1.getHeight(Heightmap.Types.MOTION_BLOCKING, var15, var16)) + 1;
                    for (int var18 = var7; var18 < var17; ++var18) {
                        Blender.generateBorderTick(var1, var4.setWithOffset(var5, var15, var18, var16));
                    }
                }
            }
        }
    }

    private static void generateBorderTick(ChunkAccess var0, BlockPos var1) {
        FluidState var3;
        BlockState var2 = var0.getBlockState(var1);
        if (var2.is(BlockTags.LEAVES)) {
            var0.markPosForPostprocessing(var1);
        }
        if (!(var3 = var0.getFluidState(var1)).isEmpty()) {
            var0.markPosForPostprocessing(var1);
        }
    }

    public static void addAroundOldChunksCarvingMaskFilter(WorldGenLevel var0, ProtoChunk var12) {
        ChunkPos var22 = var12.getPos();
        ImmutableMap.Builder var32 = ImmutableMap.builder();
        for (Direction8 var7 : Direction8.values()) {
            int var9;
            int var8 = var22.x + var7.getStepX();
            BlendingData var10 = var0.getChunk(var8, var9 = var22.z + var7.getStepZ()).getBlendingData();
            if (var10 == null) continue;
            var32.put((Object)var7, (Object)var10);
        }
        ImmutableMap var4 = var32.build();
        if (!var12.isOldNoiseGeneration() && var4.isEmpty()) {
            return;
        }
        DistanceGetter var5 = Blender.makeOldChunkDistanceGetter(var12.getBlendingData(), (Map<Direction8, BlendingData>)var4);
        CarvingMask.Mask var6 = (var1, var2, var3) -> {
            double var8;
            double var6;
            double var4 = (double)var1 + 0.5 + SHIFT_NOISE.getValue(var1, var2, var3) * 4.0;
            return var5.getDistance(var4, var6 = (double)var2 + 0.5 + SHIFT_NOISE.getValue(var2, var3, var1) * 4.0, var8 = (double)var3 + 0.5 + SHIFT_NOISE.getValue(var3, var1, var2) * 4.0) < 4.0;
        };
        var12.getOrCreateCarvingMask().setAdditionalMask(var6);
    }

    public static DistanceGetter makeOldChunkDistanceGetter(@Nullable BlendingData var0, Map<Direction8, BlendingData> var12) {
        ArrayList var22 = Lists.newArrayList();
        if (var0 != null) {
            var22.add(Blender.makeOffsetOldChunkDistanceGetter(null, var0));
        }
        var12.forEach((var1, var2) -> var22.add(Blender.makeOffsetOldChunkDistanceGetter(var1, var2)));
        return (var1, var3, var5) -> {
            double var7 = Double.POSITIVE_INFINITY;
            for (DistanceGetter var10 : var22) {
                double var11 = var10.getDistance(var1, var3, var5);
                if (!(var11 < var7)) continue;
                var7 = var11;
            }
            return var7;
        };
    }

    private static DistanceGetter makeOffsetOldChunkDistanceGetter(@Nullable Direction8 var0, BlendingData var1) {
        double var2 = 0.0;
        double var4 = 0.0;
        if (var0 != null) {
            for (Direction var7 : var0.getDirections()) {
                var2 += (double)(var7.getStepX() * 16);
                var4 += (double)(var7.getStepZ() * 16);
            }
        }
        double var6 = var2;
        double var82 = var4;
        double var102 = (double)var1.getAreaWithOldGeneration().getHeight() / 2.0;
        double var122 = (double)var1.getAreaWithOldGeneration().getMinY() + var102;
        return (var8, var10, var12) -> Blender.distanceToCube(var8 - 8.0 - var6, var10 - var122, var12 - 8.0 - var82, 8.0, var102, 8.0);
    }

    private static double distanceToCube(double var0, double var2, double var4, double var6, double var8, double var10) {
        double var12 = Math.abs(var0) - var6;
        double var14 = Math.abs(var2) - var8;
        double var16 = Math.abs(var4) - var10;
        return Mth.length(Math.max(0.0, var12), Math.max(0.0, var14), Math.max(0.0, var16));
    }

    static interface CellValueGetter {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public record BlendingOutput(double alpha, double blendingOffset) {
    }

    public static interface DistanceGetter {
        public double getDistance(double var1, double var3, double var5);
    }
}

