/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class SimpleBlockFeature
extends Feature<SimpleBlockConfiguration> {
    public SimpleBlockFeature(Codec<SimpleBlockConfiguration> var0) {
        super(var0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> var0) {
        SimpleBlockConfiguration var1 = var0.config();
        WorldGenLevel var2 = var0.level();
        BlockPos var3 = var0.origin();
        BlockState var4 = var1.toPlace().getState(var0.random(), var3);
        if (!var4.canSurvive(var2, var3)) return false;
        if (var4.getBlock() instanceof DoublePlantBlock) {
            if (!var2.isEmptyBlock(var3.above())) return false;
            DoublePlantBlock.placeAt(var2, var4, var3, 2);
        } else if (var4.getBlock() instanceof MossyCarpetBlock) {
            MossyCarpetBlock.placeAt(var2, var3, var2.getRandom(), 2);
        } else {
            var2.setBlock(var3, var4, 2);
        }
        if (!var1.scheduleTick()) return true;
        var2.scheduleTick(var3, var2.getBlockState(var3).getBlock(), 1);
        return true;
    }
}

