/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class BlobFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<BlobFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> BlobFoliagePlacer.blobParts(var0).apply((Applicative)var0, BlobFoliagePlacer::new));
    protected final int height;

    protected static <P extends BlobFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider, Integer> blobParts(RecordCodecBuilder.Instance<P> var02) {
        return BlobFoliagePlacer.foliagePlacerParts(var02).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(var0 -> var0.height));
    }

    public BlobFoliagePlacer(IntProvider var0, IntProvider var1, int var2) {
        super(var0, var1);
        this.height = var2;
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.BLOB_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        for (int var9 = var8; var9 >= var8 - var6; --var9) {
            int var10 = Math.max(var7 + var5.radiusOffset() - 1 - var9 / 2, 0);
            this.placeLeavesRow(var0, var1, var2, var3, var5.pos(), var10, var9, var5.doubleTrunk());
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return this.height;
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return var1 == var4 && var3 == var4 && (var0.nextInt(2) == 0 || var2 == 0);
    }
}

