/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TrunkVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final TrunkVineDecorator INSTANCE = new TrunkVineDecorator();

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.TRUNK_VINE;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        RandomSource var1 = var0.random();
        var0.logs().forEach(var2 -> {
            BlockPos var3;
            if (var1.nextInt(3) > 0 && var0.isAir(var3 = var2.west())) {
                var0.placeVine(var3, VineBlock.EAST);
            }
            if (var1.nextInt(3) > 0 && var0.isAir(var3 = var2.east())) {
                var0.placeVine(var3, VineBlock.WEST);
            }
            if (var1.nextInt(3) > 0 && var0.isAir(var3 = var2.north())) {
                var0.placeVine(var3, VineBlock.SOUTH);
            }
            if (var1.nextInt(3) > 0 && var0.isAir(var3 = var2.south())) {
                var0.placeVine(var3, VineBlock.NORTH);
            }
        });
    }
}

