/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class DarkOakTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<DarkOakTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> DarkOakTrunkPlacer.trunkPlacerParts(var0).apply((Applicative)var0, DarkOakTrunkPlacer::new));

    public DarkOakTrunkPlacer(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.DARK_OAK_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        int var18;
        int var17;
        ArrayList var6 = Lists.newArrayList();
        BlockPos var7 = var4.below();
        DarkOakTrunkPlacer.setDirtAt(var0, var1, var2, var7, var5);
        DarkOakTrunkPlacer.setDirtAt(var0, var1, var2, var7.east(), var5);
        DarkOakTrunkPlacer.setDirtAt(var0, var1, var2, var7.south(), var5);
        DarkOakTrunkPlacer.setDirtAt(var0, var1, var2, var7.south().east(), var5);
        Direction var8 = Direction.Plane.HORIZONTAL.getRandomDirection(var2);
        int var9 = var3 - var2.nextInt(4);
        int var10 = 2 - var2.nextInt(3);
        int var11 = var4.getX();
        int var12 = var4.getY();
        int var13 = var4.getZ();
        int var14 = var11;
        int var15 = var13;
        int var16 = var12 + var3 - 1;
        for (var17 = 0; var17 < var3; ++var17) {
            BlockPos var19;
            if (var17 >= var9 && var10 > 0) {
                var14 += var8.getStepX();
                var15 += var8.getStepZ();
                --var10;
            }
            if (!TreeFeature.isAirOrLeaves(var0, var19 = new BlockPos(var14, var18 = var12 + var17, var15))) continue;
            this.placeLog(var0, var1, var2, var19, var5);
            this.placeLog(var0, var1, var2, var19.east(), var5);
            this.placeLog(var0, var1, var2, var19.south(), var5);
            this.placeLog(var0, var1, var2, var19.east().south(), var5);
        }
        var6.add(new FoliagePlacer.FoliageAttachment(new BlockPos(var14, var16, var15), 0, true));
        for (var17 = -1; var17 <= 2; ++var17) {
            for (var18 = -1; var18 <= 2; ++var18) {
                if (var17 >= 0 && var17 <= 1 && var18 >= 0 && var18 <= 1 || var2.nextInt(3) > 0) continue;
                int var19 = var2.nextInt(3) + 2;
                for (int var20 = 0; var20 < var19; ++var20) {
                    this.placeLog(var0, var1, var2, new BlockPos(var11 + var17, var16 - var20 - 1, var13 + var18), var5);
                }
                var6.add(new FoliagePlacer.FoliageAttachment(new BlockPos(var11 + var17, var16, var13 + var18), 0, false));
            }
        }
        return var6;
    }
}

