/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class EnvironmentScanPlacement
extends PlacementModifier {
    private final Direction directionOfSearch;
    private final BlockPredicate targetCondition;
    private final BlockPredicate allowedSearchCondition;
    private final int maxSteps;
    public static final MapCodec<EnvironmentScanPlacement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Direction.VERTICAL_CODEC.fieldOf("direction_of_search").forGetter(var0 -> var0.directionOfSearch), (App)BlockPredicate.CODEC.fieldOf("target_condition").forGetter(var0 -> var0.targetCondition), (App)BlockPredicate.CODEC.optionalFieldOf("allowed_search_condition", (Object)BlockPredicate.alwaysTrue()).forGetter(var0 -> var0.allowedSearchCondition), (App)Codec.intRange((int)1, (int)32).fieldOf("max_steps").forGetter(var0 -> var0.maxSteps)).apply((Applicative)var02, EnvironmentScanPlacement::new));

    private EnvironmentScanPlacement(Direction var0, BlockPredicate var1, BlockPredicate var2, int var3) {
        this.directionOfSearch = var0;
        this.targetCondition = var1;
        this.allowedSearchCondition = var2;
        this.maxSteps = var3;
    }

    public static EnvironmentScanPlacement scanningFor(Direction var0, BlockPredicate var1, BlockPredicate var2, int var3) {
        return new EnvironmentScanPlacement(var0, var1, var2, var3);
    }

    public static EnvironmentScanPlacement scanningFor(Direction var0, BlockPredicate var1, int var2) {
        return EnvironmentScanPlacement.scanningFor(var0, var1, BlockPredicate.alwaysTrue(), var2);
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext var0, RandomSource var1, BlockPos var2) {
        BlockPos.MutableBlockPos var3 = var2.mutable();
        WorldGenLevel var4 = var0.getLevel();
        if (!this.allowedSearchCondition.test(var4, var3)) {
            return Stream.of(new BlockPos[0]);
        }
        for (int var5 = 0; var5 < this.maxSteps; ++var5) {
            if (this.targetCondition.test(var4, var3)) {
                return Stream.of(var3);
            }
            var3.move(this.directionOfSearch);
            if (var4.isOutsideBuildHeight(var3.getY())) {
                return Stream.of(new BlockPos[0]);
            }
            if (!this.allowedSearchCondition.test(var4, var3)) break;
        }
        if (this.targetCondition.test(var4, var3)) {
            return Stream.of(var3);
        }
        return Stream.of(new BlockPos[0]);
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.ENVIRONMENT_SCAN;
    }
}

