/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class Structure {
    public static final Codec<Structure> DIRECT_CODEC = BuiltInRegistries.STRUCTURE_TYPE.byNameCodec().dispatch(Structure::type, StructureType::codec);
    public static final Codec<Holder<Structure>> CODEC = RegistryFileCodec.create(Registries.STRUCTURE, DIRECT_CODEC);
    protected final StructureSettings settings;

    public static <S extends Structure> RecordCodecBuilder<S, StructureSettings> settingsCodec(RecordCodecBuilder.Instance<S> var02) {
        return StructureSettings.CODEC.forGetter(var0 -> var0.settings);
    }

    public static <S extends Structure> MapCodec<S> simpleCodec(Function<StructureSettings, S> var0) {
        return RecordCodecBuilder.mapCodec(var1 -> var1.group(Structure.settingsCodec(var1)).apply((Applicative)var1, var0));
    }

    protected Structure(StructureSettings var0) {
        this.settings = var0;
    }

    public HolderSet<Biome> biomes() {
        return this.settings.biomes;
    }

    public Map<MobCategory, StructureSpawnOverride> spawnOverrides() {
        return this.settings.spawnOverrides;
    }

    public GenerationStep.Decoration step() {
        return this.settings.step;
    }

    public TerrainAdjustment terrainAdaptation() {
        return this.settings.terrainAdaptation;
    }

    public BoundingBox adjustBoundingBox(BoundingBox var0) {
        if (this.terrainAdaptation() != TerrainAdjustment.NONE) {
            return var0.inflatedBy(12);
        }
        return var0;
    }

    public StructureStart generate(Holder<Structure> var0, ResourceKey<Level> var1, RegistryAccess var2, ChunkGenerator var3, BiomeSource var4, RandomState var5, StructureTemplateManager var6, long var7, ChunkPos var9, int var10, LevelHeightAccessor var11, Predicate<Holder<Biome>> var12) {
        StructurePiecesBuilder var16;
        StructureStart var17;
        ProfiledDuration var13 = JvmProfiler.INSTANCE.onStructureGenerate(var9, var1, var0);
        GenerationContext var14 = new GenerationContext(var2, var3, var4, var5, var6, var7, var9, var11, var12);
        Optional<GenerationStub> var15 = this.findValidGenerationPoint(var14);
        if (var15.isPresent() && (var17 = new StructureStart(this, var9, var10, (var16 = var15.get().getPiecesBuilder()).build())).isValid()) {
            if (var13 != null) {
                var13.finish(true);
            }
            return var17;
        }
        if (var13 != null) {
            var13.finish(false);
        }
        return StructureStart.INVALID_START;
    }

    protected static Optional<GenerationStub> onTopOfChunkCenter(GenerationContext var0, Heightmap.Types var1, Consumer<StructurePiecesBuilder> var2) {
        ChunkPos var3 = var0.chunkPos();
        int var4 = var3.getMiddleBlockX();
        int var5 = var3.getMiddleBlockZ();
        int var6 = var0.chunkGenerator().getFirstOccupiedHeight(var4, var5, var1, var0.heightAccessor(), var0.randomState());
        return Optional.of(new GenerationStub(new BlockPos(var4, var6, var5), var2));
    }

    private static boolean isValidBiome(GenerationStub var0, GenerationContext var1) {
        BlockPos var2 = var0.position();
        return var1.validBiome.test(var1.chunkGenerator.getBiomeSource().getNoiseBiome(QuartPos.fromBlock(var2.getX()), QuartPos.fromBlock(var2.getY()), QuartPos.fromBlock(var2.getZ()), var1.randomState.sampler()));
    }

    public void afterPlace(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, PiecesContainer var6) {
    }

    private static int[] getCornerHeights(GenerationContext var0, int var1, int var2, int var3, int var4) {
        ChunkGenerator var5 = var0.chunkGenerator();
        LevelHeightAccessor var6 = var0.heightAccessor();
        RandomState var7 = var0.randomState();
        return new int[]{var5.getFirstOccupiedHeight(var1, var3, Heightmap.Types.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1, var3 + var4, Heightmap.Types.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1 + var2, var3, Heightmap.Types.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1 + var2, var3 + var4, Heightmap.Types.WORLD_SURFACE_WG, var6, var7)};
    }

    public static int getMeanFirstOccupiedHeight(GenerationContext var0, int var1, int var2, int var3, int var4) {
        int[] var5 = Structure.getCornerHeights(var0, var1, var2, var3, var4);
        return (var5[0] + var5[1] + var5[2] + var5[3]) / 4;
    }

    protected static int getLowestY(GenerationContext var0, int var1, int var2) {
        ChunkPos var3 = var0.chunkPos();
        int var4 = var3.getMinBlockX();
        int var5 = var3.getMinBlockZ();
        return Structure.getLowestY(var0, var4, var5, var1, var2);
    }

    protected static int getLowestY(GenerationContext var0, int var1, int var2, int var3, int var4) {
        int[] var5 = Structure.getCornerHeights(var0, var1, var3, var2, var4);
        return Math.min(Math.min(var5[0], var5[1]), Math.min(var5[2], var5[3]));
    }

    @Deprecated
    protected BlockPos getLowestYIn5by5BoxOffset7Blocks(GenerationContext var0, Rotation var1) {
        int var2 = 5;
        int var3 = 5;
        if (var1 == Rotation.CLOCKWISE_90) {
            var2 = -5;
        } else if (var1 == Rotation.CLOCKWISE_180) {
            var2 = -5;
            var3 = -5;
        } else if (var1 == Rotation.COUNTERCLOCKWISE_90) {
            var3 = -5;
        }
        ChunkPos var4 = var0.chunkPos();
        int var5 = var4.getBlockX(7);
        int var6 = var4.getBlockZ(7);
        return new BlockPos(var5, Structure.getLowestY(var0, var5, var6, var2, var3), var6);
    }

    protected abstract Optional<GenerationStub> findGenerationPoint(GenerationContext var1);

    public Optional<GenerationStub> findValidGenerationPoint(GenerationContext var0) {
        return this.findGenerationPoint(var0).filter(var1 -> Structure.isValidBiome(var1, var0));
    }

    public abstract StructureType<?> type();

    public static final class StructureSettings
    extends Record {
        final HolderSet<Biome> biomes;
        final Map<MobCategory, StructureSpawnOverride> spawnOverrides;
        final GenerationStep.Decoration step;
        final TerrainAdjustment terrainAdaptation;
        static final StructureSettings DEFAULT = new StructureSettings(HolderSet.direct(new Holder[0]), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        public static final MapCodec<StructureSettings> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.BIOME).fieldOf("biomes").forGetter(StructureSettings::biomes), (App)Codec.simpleMap(MobCategory.CODEC, StructureSpawnOverride.CODEC, (Keyable)StringRepresentable.keys(MobCategory.values())).fieldOf("spawn_overrides").forGetter(StructureSettings::spawnOverrides), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(StructureSettings::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)StructureSettings.DEFAULT.terrainAdaptation).forGetter(StructureSettings::terrainAdaptation)).apply((Applicative)var0, StructureSettings::new));

        public StructureSettings(HolderSet<Biome> var0) {
            this(var0, StructureSettings.DEFAULT.spawnOverrides, StructureSettings.DEFAULT.step, StructureSettings.DEFAULT.terrainAdaptation);
        }

        public StructureSettings(HolderSet<Biome> var0, Map<MobCategory, StructureSpawnOverride> var1, GenerationStep.Decoration var2, TerrainAdjustment var3) {
            this.biomes = var0;
            this.spawnOverrides = var1;
            this.step = var2;
            this.terrainAdaptation = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StructureSettings.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StructureSettings.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StructureSettings.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this, var0);
        }

        public HolderSet<Biome> biomes() {
            return this.biomes;
        }

        public Map<MobCategory, StructureSpawnOverride> spawnOverrides() {
            return this.spawnOverrides;
        }

        public GenerationStep.Decoration step() {
            return this.step;
        }

        public TerrainAdjustment terrainAdaptation() {
            return this.terrainAdaptation;
        }

        public static class Builder {
            private final HolderSet<Biome> biomes;
            private Map<MobCategory, StructureSpawnOverride> spawnOverrides;
            private GenerationStep.Decoration step;
            private TerrainAdjustment terrainAdaption;

            public Builder(HolderSet<Biome> var0) {
                this.spawnOverrides = StructureSettings.DEFAULT.spawnOverrides;
                this.step = StructureSettings.DEFAULT.step;
                this.terrainAdaption = StructureSettings.DEFAULT.terrainAdaptation;
                this.biomes = var0;
            }

            public Builder spawnOverrides(Map<MobCategory, StructureSpawnOverride> var0) {
                this.spawnOverrides = var0;
                return this;
            }

            public Builder generationStep(GenerationStep.Decoration var0) {
                this.step = var0;
                return this;
            }

            public Builder terrainAdapation(TerrainAdjustment var0) {
                this.terrainAdaption = var0;
                return this;
            }

            public StructureSettings build() {
                return new StructureSettings(this.biomes, this.spawnOverrides, this.step, this.terrainAdaption);
            }
        }
    }

    public static final class GenerationContext
    extends Record {
        private final RegistryAccess registryAccess;
        final ChunkGenerator chunkGenerator;
        private final BiomeSource biomeSource;
        final RandomState randomState;
        private final StructureTemplateManager structureTemplateManager;
        private final WorldgenRandom random;
        private final long seed;
        private final ChunkPos chunkPos;
        private final LevelHeightAccessor heightAccessor;
        final Predicate<Holder<Biome>> validBiome;

        public GenerationContext(RegistryAccess var0, ChunkGenerator var1, BiomeSource var2, RandomState var3, StructureTemplateManager var4, long var5, ChunkPos var7, LevelHeightAccessor var8, Predicate<Holder<Biome>> var9) {
            this(var0, var1, var2, var3, var4, GenerationContext.makeRandom(var5, var7), var5, var7, var8, var9);
        }

        public GenerationContext(RegistryAccess var0, ChunkGenerator var1, BiomeSource var2, RandomState var3, StructureTemplateManager var4, WorldgenRandom var5, long var6, ChunkPos var8, LevelHeightAccessor var9, Predicate<Holder<Biome>> var10) {
            this.registryAccess = var0;
            this.chunkGenerator = var1;
            this.biomeSource = var2;
            this.randomState = var3;
            this.structureTemplateManager = var4;
            this.random = var5;
            this.seed = var6;
            this.chunkPos = var8;
            this.heightAccessor = var9;
            this.validBiome = var10;
        }

        private static WorldgenRandom makeRandom(long var0, ChunkPos var2) {
            WorldgenRandom var3 = new WorldgenRandom(new LegacyRandomSource(0L));
            var3.setLargeFeatureSeed(var0, var2.x, var2.z);
            return var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{GenerationContext.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "registryAccess", "chunkGenerator", "biomeSource", "randomState", "structureTemplateManager", "random", "seed", "chunkPos", "heightAccessor", "validBiome"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GenerationContext.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "registryAccess", "chunkGenerator", "biomeSource", "randomState", "structureTemplateManager", "random", "seed", "chunkPos", "heightAccessor", "validBiome"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GenerationContext.class, "registryAccess;chunkGenerator;biomeSource;randomState;structureTemplateManager;random;seed;chunkPos;heightAccessor;validBiome", "registryAccess", "chunkGenerator", "biomeSource", "randomState", "structureTemplateManager", "random", "seed", "chunkPos", "heightAccessor", "validBiome"}, this, var0);
        }

        public RegistryAccess registryAccess() {
            return this.registryAccess;
        }

        public ChunkGenerator chunkGenerator() {
            return this.chunkGenerator;
        }

        public BiomeSource biomeSource() {
            return this.biomeSource;
        }

        public RandomState randomState() {
            return this.randomState;
        }

        public StructureTemplateManager structureTemplateManager() {
            return this.structureTemplateManager;
        }

        public WorldgenRandom random() {
            return this.random;
        }

        public long seed() {
            return this.seed;
        }

        public ChunkPos chunkPos() {
            return this.chunkPos;
        }

        public LevelHeightAccessor heightAccessor() {
            return this.heightAccessor;
        }

        public Predicate<Holder<Biome>> validBiome() {
            return this.validBiome;
        }
    }

    public record GenerationStub(BlockPos position, Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> generator) {
        public GenerationStub(BlockPos var0, Consumer<StructurePiecesBuilder> var1) {
            this(var0, (Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder>)Either.left(var1));
        }

        public StructurePiecesBuilder getPiecesBuilder() {
            return (StructurePiecesBuilder)this.generator.map(var0 -> {
                StructurePiecesBuilder var1 = new StructurePiecesBuilder();
                var0.accept(var1);
                return var1;
            }, var0 -> var0);
        }
    }
}

